<?php



include_once("constantes.php");




class IntElServer {
  /**
   * @var string Despus de iniciar sesin, se obtiene el access token que sirve para realizar el resto de las operaciones contra El Server
   */
  private $access_token;

  /**
   * @var string Si al realizar alguna operacin se produce un error, se setea este atributo con una descripcin del error.
   */
  private $error;

  /**
   * Hace la consulta de disponibilidad de un dominio
   * 
   * @param string $dominio un nombre de dominio vlido
   * 
   * @return string Retorna: "Disponible" o "No disponible"
   */
  public function ConsultaWhoIs($dominio)
  {
    // Bouml preserved body begin 0001F402

	$parametros = "/domain/whois/?access_token=".$this->access_token."&domain=".$dominio;
	$rta = json_decode($this->EjecutarConsulta($parametros));

	if($rta->{'data'})
		return $rta;
	elseif($rta->{'error'})
	{
                $this->error = array("tipo" =>  $rta->{'error'}->{'type'},"mensaje" => $rta->{'error'}->{'message'});
                return false;
	}
	else
	{
		$this->error = array("tipo" => "Inesperado", "mensaje" => "No se pudo acceder al api de El Server");
		return false;
	}


//puede devolver falso si no se conecta
//error
//data con los datos del dominio o available = true
	
    // Bouml preserved body end 0001F402
  }

  /**
   * Consulta el progreso de la registracin de un dominio.
   * 
   * @param string Identificador del trmite.
   * 
   * @return string Retorna: "En trmite" si todava no fu registrado.
   *          		"Registrado" cuando el proceso de registracin del dominio concluye.
   */
  public function ConsultarEstadoDelTramite($codTramite)
  {
    // Bouml preserved body begin 0001F502
    // Bouml preserved body end 0001F502
  }

  /**
   * @return string Devuelve el ltimo error que se produjo.
   * 
   */
  public function getError()
  {
    // Bouml preserved body begin 0001F682
	return $this->error;
    // Bouml preserved body end 0001F682
  }

  /**
   * Loguea un usuario SSO al sistema y obtiene un access_token con el que hace el resto de las operaciones.
   * Si se pudo loguear returna true, caso contrario retorna false y setea el atributo error.
   */
  public function IniciarSesion()
  {
    // Bouml preserved body begin 0001F602
	
	$parametros = "/sso/login/?sso=".urlencode(USUARIO)."&password=".urlencode(CLAVE)."&ctx=".urlencode(CONTEXTO);
	$rta = $this->EjecutarConsulta($parametros);
	$rta = json_decode($rta);
	if($rta->{'access_token'})
	{
		$this->access_token = $rta->{'access_token'};
		define("DOMAIN","/domain/?access_token=".$this->access_token."&account=".CUENTA);
		return true;
	}
	elseif($rta->{'error'})
	{
		$this->error = array("tipo" =>  $rta->{'error'}->{'type'},"mensaje" => $rta->{'error'}->{'message'});
		return false;
	}
	else
	{
		$this->error = array("tipo" => "Inesperado", "mensaje" => "No se pudo acceder al api de El Server");
		return false;
	}

    // Bouml preserved body end 0001F602
  }

  /**
   * Lista los dominios que fueron dados de alta por Iplan
   * 
   * @return false u object(stdClass) con le listado de dominios
   */
  public function ListarDominios()
  {
    // Bouml preserved body begin 0001F802
	$parametros = DOMAIN."&offset=&limit=&q=&sortorder=&by=";
	$rta = json_decode($this->EjecutarConsulta($parametros));
	if($rta->{'error'})
        {
                $this->error = array("tipo" =>  $rta->{'error'}->{'type'},"mensaje" => $rta->{'error'}->{'message'});
                return false;
        }
	else
	{
		return $rta;
	}

    // Bouml preserved body end 0001F802
  }

  /**
   * Modifica los datos con que fue dado de alta el Dominio.
   * 
   * Retorna: true si pudo modificar los datos o false si hubo algn error.
   */
  public function ModificarDatosDominio($datosDominio)
  {
    // Bouml preserved body begin 0001F582
    // Bouml preserved body end 0001F582
  }

  /**
   * Realiza la registracin del dominio en "El Server".
   * 
   * @param string $dominio un nombre de dominio vlido
   * 
   * @return bool Retorna true si se registro o false si hubo un error y setea la variable $error
   */
  public function RegistrarDominio($dominio)
  {
    // Bouml preserved body begin 0001F482
//Se puede pasar el array completo desde la funcion que lo llama
	
	$data = array(	
			'access_token' => $this->access_token,
			'account' 	=> CUENTA,
			'domain' => $dominio, 
			'period' => '1',
			'custom' => '',	//Campo de texto para uso libre hasta 255 caracteres,
			'autorenew' => '',//Renovar automaticamente por 1 ao cuando el registro esta por vencer. Requiere crditos disponibles. Por defecto es 1
			'ns1_name' => '' ,
			'ns1_ip'   => '' ,
			'ns2_name' => '' ,
			'ns2_ip'   => '' ,
			'ns3_name' => '' ,
			'ns3_ip'   => '' ,
			'ns4_name' => '' ,
			'ns4_ip'   => '' ,
			'ns5_name' => '' ,
			'ns5_ip'   => ''
		     );

	$data = "access_token="	. $this->access_token 	."&".
                "account="	. CUENTA		."&".
		"domain="	. $dominio		."&".
		"period="	. '' ."&".
		"custom="	. '' ."&".
		"autorenew="	. '' ."&".
		"ns1_name="	. '' ."&".
		"ns1_ip="	. '' ."&".
		"ns2_name="	. '' ."&".
		"ns2_ip="	. '' ."&".
		"ns3_name="	. '' ."&".
		"ns3_ip="	. '' ."&".
		"ns4_name="	. '' ."&".
		"ns4_ip="	. '' ."&".
		"ns5_name="	. '' ."&".
		"ns5_ip=";






	$rta = json_decode($this->EjecutarConsulta($data,1));
echo "<br>vardump(";
var_dump($rta);
echo ")<br><br>";
	if($rta->{'error'})
	{
                $this->error = array("tipo" =>  $rta->{'error'}->{'type'},"mensaje" => $rta->{'error'}->{'message'});
                return false;
	}

	return $rta;
    // Bouml preserved body end 0001F482
  }

  /**
   * Envia variables por GET
   * @param array - Contine las variables GET que se envian al api de "El Server"
   * 
   * @return string - Consulta al api.
   */
  private function EjecutarConsulta($parametros, $post = null)
  {
    // Bouml preserved body begin 0001F702

	$ch = curl_init();
	curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

	if($post == 1)
	{
		curl_setopt($ch, CURLOPT_URL, URL."/domain/");
		curl_setopt($ch, CURLOPT_POST, 1);
		curl_setopt($ch, CURLOPT_POSTFIELDS, $parametros);
	}
	else{

		$consulta = URL.$parametros;
		curl_setopt($ch, CURLOPT_URL, $consulta);
	}

	$ret = curl_exec($ch);
	curl_close($ch);
	
	return $ret;



    // Bouml preserved body end 0001F702
  }

}
?>
