<?php

require_once('PHPCisco.php');
require_once('../controlador/constantes.php');
require_once('Logs.php');
require_once('WebSocketLog.php');
require_once('../controlador/BaseDeDatos.php');

error_reporting(E_ALL);
/*
	Example Chatbox Script
	 - Uses WebSocket for client and server communication
	 - Works with: ws api.php
	
	Starting the server
	 - Open any browser and visit server.php once (this file). For example: http://127.0.0.1/chatbox/server.php
	   The page should appear to "never load", this is supposed to happen and means the server is running.
	
	Connecting to the chatbox
	 - Open Firefox 6 and visit index.html. For example: http://127.0.0.1/chatbox/
	 - Type a IP into the top right box, and press the connect button.
	   You should now be able to send messages, receive messages, and see a list of connected users.
	
	Protocol
	 - This example chatbox script uses a very basic text protocol.
	
	Client -> Server:
		JOIN IP
		QUIT
		TEXT text here
	
	Server -> Client:
		ONJOIN IP
		ONQUIT IP
		ONTEXT IP text here
		SERVER text here
	
	SERVER sends text to a client that is not chat text, for example: Username already taken
	QUIT does not need to take a IP because the server stores IPs for clients in $users.
*/

// settings

// for other computers to connect, you will probably need to change this to your LAN IP or external IP,
// alternatively use: gethostbyaddr(gethostbyname($_SERVER['SERVER_NAME']))
define('CB_SERVER_BIND_HOST', '190.210.130.10');
//define('CB_SERVER_BIND_HOST', 'audiocodes.iplan.com.ar');

// also change at top of main.js
define('CB_SERVER_BIND_PORT', 8080);

// also change at top of main.js
define('CB_MAX_USERNAME_LENGTH', 18);




// prevent the server from timing out
set_time_limit(0);

// include the web sockets server script (the server is started at the far bottom of this file)
require 'WebSocketApi.php';

/*
 * Se escribe el PID en un archivo, para que lo pueda chequear el Monit
*/
  $pid=getmypid();
  $fd= fopen(PID_FILE,"w");
  fwrite($fd,$pid);
  fclose($fd);

// users are stored in this global array with syntax: $users[ integer ClientID ] = string Username
$users = array();
$telnet = array();
$telnetRead = array();
$logTelnet = array();
$logWebSocket = new WebSocketLog(true, $loglevel=WebSocketLog::LEVEL_DEBUG);
// when a client sends data to the server
function wsOnMessage($clientID, $message, $messageLength, $binary) {
    global $telnet;
    global $telnetRead;
    global $logTelnet;
    global $logWebSocket;

	// check if message length is 0
	if ($messageLength == 0) {
      $logWebSocket->log("Recibimos un mensaje vacio!",WebSocketLog::LEVEL_ERROR);
		wsClose($clientID);
		return;
	}
   $logWebSocket->log("Mensaje recibido de la web: $message");
	// split the message by spaces into an array, and fetch the command
	$message = explode(' ', $message);
	$command = array_shift($message);
	
	// check which command was received
	if ($command == 'TEXT') {
		// a client has sent chat text to the server
		
		if (!isUser($clientID)) {
         $logWebSocket->log("Recibimos un mensaje TEXT de un cliente que no envio JOIN!",WebSocketLog::LEVEL_ERROR);
			// the client has not yet sent a JOIN with a valid IP, and is trying to send a TEXT
			wsClose($clientID);
		return;
		}
		
		// put the message back into a string
		$text = implode(' ', $message);
		
    	$telnet[$clientID][0]->DoCommand($text);	
		// the text is actually also sent back to the client which sent the text, which sort of acts as a confirmation that the text worked
		$ip = getIP($clientID);
	}
	elseif ($command == 'JOIN') {
		// a client is joining the chat
		
		if (isUser($clientID)) {
         $logWebSocket->log("Recibimos un mensaje JOIN de un cliente que ya envió JOIN!",WebSocketLog::LEVEL_ERROR);
			// the client has already sent a JOIN with a valid IP
			wsClose($clientID);
			return;
		}
		
		// fetch IP, and trim any whitespace before and after the IP
		$ip = trim($message[0]);
		$usuario = trim($message[1]);
		if ($ip == '') {
			// the IP is blank
         $logWebSocket->log("Recibimos un mensaje JOIN con IP vacía!",WebSocketLog::LEVEL_ERROR);
			wsClose($clientID);
			return;
		}
		
		// add the user
		addUser($clientID, $ip);

      // MARTIN //
      $telnet[$clientID] = array();
      $telnet[$clientID][0] = new PHPCiscoTelnet();
      $telnet[$clientID][1] = $usuario;

      switch($telnet[$clientID][0]->Connect($ip, IAD_USER_ADMIN, IAD_PASS_ADMIN)){
          case 0:
                $telnetRead[$clientID] = $telnet[$clientID][0]->enable(IAD_PASS_ENABLE);
                if ($telnetRead[$clientID]==false){
                    $texto = "La password de enable no coincide con la configurada en la plataforma, por favor verificá si el equipo $ip se encuentra dado de alta correctamente en la plataforma.";
                    $error=true;
                }else{
                    sendChat($clientID,$telnet[$clientID][0]->GetPrompt());
                    $texto = "El usuario $usuario ingresó por telnet a $ip";
                    $logWebSocket->log($texto);
                    $telnet[$clientID][2] = $telnet[$clientID][0]->GetPrompt();
                    loguear($usuario,TELNET_CISCO,$texto,$ip);
                    $error= false;
                    }
                break;
          case 1:
                $texto = "No se pudo conectar a la IP $ip. Verificá si los datos son correctos";
                $error= true;
                break;
          case 3:
                $texto = "Estas intentando ingresar a un equipo Audiocodes";
                $error= true;
                break;
          case 4:
                $texto = "Posiblemente el equipo que intentas ingresar tiene tacacs o no tiene configurado el usuario nociplan";
                $error= true;
                break;
          default:
                $texto = "Error desconocido";
                $error= true;
                break;
     }
    
     if ($error){
        $logWebSocket->log($texto,WebSocketLog::LEVEL_ERROR);
        $telnet[$clientID][2]= $texto;
        sendChat($clientID,$texto);
        wsClose($clientID);
        removeUser($clientID);
      }
/*
      if ($telnet[$clientID][0]->Connect($ip, IAD_USER_ADMIN, IAD_PASS_ADMIN)==0){
        $telnetRead[$clientID] = $telnet[$clientID][0]->enable(IAD_PASS_ENABLE);
        sendChat($clientID,$telnet[$clientID][0]->GetPrompt());
        $telnet[$clientID][1] = $usuario;
	     $texto = "El usuario $usuario ingresó por telnet a $ip";
        $logWebSocket->log($texto);
        $telnet[$clientID][2] = $telnet[$clientID][0]->GetPrompt();
        loguear($usuario,TELNET_CISCO,$texto,$ip);
      }else{
        $texto = "No se pudo conectar a la IP $ip. Verificá si los datos son correctos";
        $logWebSocket->log($texto,WebSocketLog::LEVEL_ERROR);
        sendChat($clientID,$texto);
		  wsClose($clientID);
		  removeUser($clientID);
      }*/
      // FIN MARTIN //
	}
	elseif ($command == 'QUIT') {
		// a client is leaving the chat
		
		if (!isUser($clientID)) {
			// the client has not yet sent a JOIN with a valid IP, and is trying to send a QUIT
         $logWebSocket->log("Recibimos un mensaje QUIT de un cliente que no envio JOIN!",WebSocketLog::LEVEL_ERROR);
			wsClose($clientID);
			return;
		}
		// remove the user
      $telnet[$clientID][0]->Disconnect();
		removeUser($clientID);
	}
	else {
		// unknown command received, close connection
      $logWebSocket->log("Recibimos el mensaje $mensaje que es desconocido!",WebSocketLog::LEVEL_ERROR);
		wsClose($clientID);
	}
}

// when a client closes or lost connection
function wsOnClose($clientID, $status) {
	// check if the client has sent a JOIN with a valid IP
	if (isUser($clientID)) {
		removeUser($clientID);
	}
}

// user functions
function isUser($clientID) {
	// checks if a user exists (if JOIN has previously been received from the client, with a valid IP)
	global $users;
	return isset($users[$clientID]);
}

function addUser($clientID, $ip) {
	global $users;
	
	// store the user's client ID and IP
	$users[$clientID] = $ip;
}

function removeUser($clientID) {
	global $users;
	global $telnet;
   global $logWebSocket;
   global $telnetRead;
	// fetch IP for the user leaving
	$ip = getIP($clientID);
   
   //El usuario se desconecto y guardamos en la DB el historial de comandos
   loguear($telnet[$clientID][1],LOG_CISCO,$telnet[$clientID][2],$ip);	
	
   // remove data stored for the user leaving
   $texto = "Se desconectó el usuario ".$telnet[$clientID][1]." de la ip $ip";
   $logWebSocket->log($texto);
	unset($users[$clientID],$telnetRead[$clientID]);
}

// IP functions
function getIP($clientID) {
	// returns the IP of IAD for a client
	global $users;
	return $users[$clientID];
}

// chat functions
function sendChat($clientID, $text) {
   global $logWebSocket;
   $logWebSocket->log("Se envía a la web: $text");
	wsSend($clientID, 'ONTEXT '.$text);
}

function loguear($usuario,$id_log,$texto,$ip)
{   		
    global $logWebSocket;
    $db = BaseDeDatos::conectar(); 
    $log = new Logs($usuario,$id_log,$texto,$ip);
    $logWebSocket->log("Se guarda en DB el log: $texto");
    $log->guardar($db);
    $db->desconectar();
} 

// start the server
wsStartServer(CB_SERVER_BIND_HOST, CB_SERVER_BIND_PORT);

?>
