<?
require_once 'controlador/SistemaNavegacionWeb.php';
$IP7600 = array ("190.210.110.19","190.210.110.30");

$accesList = listarACL("172.16.210.103");
//echo $accesList."\n";

function listarACL($ip){

    $telnet = new PHPCiscoTelnet();
    $result = $telnet->Connect($ip, "cisco", "cisco");
    
    switch ($result) {
    case 0:
         if (!$telnet->enable("cisco"))
             return array(false,"Password enable incorrecta");
         $telnet->DoCommand("show ip access-list SEC-BROADSOUT-OUT\n");
         sleep(1);
         $telnet->GetResponse($rta);
         //$telnet->GetResponseUntilPrompt($rta);
         var_dump($rta);
         $telnet->Disconnect();
         return array(true,$telnet->display());
    case 1:
         return array(false,"[Telnet] Connect failed: Unable to open network connection");
    case 2:
         return array(false,"[Telnet] Connect failed: Unknown host");
    case 3:
         return array(false,"[Telnet] Connect failed: Login failed");
    default:
    }

}

function confExecTimeOut($ip){
    $telnet = new PHPCiscoTelnet();
    $result = $telnet->Connect($ip, IAD_USER_ADMIN, IAD_PASS_ADMIN);
    
    switch ($result) {
    case 0:
         if (!$telnet->enable(IAD_PASS_ENABLE))
             return array(false,"Password enable incorrecta");
         $telnet->DoCommand("conf t\n");
         sleep(1);
         $telnet->changeEnable($password);
         sleep(1);
         $telnet->Disconnect();
         return array(true,$telnet->display());
    case 1:
         return array(false,"[Telnet] Connect failed: Unable to open network connection");
    case 2:
         return array(false,"[Telnet] Connect failed: Unknown host");
    case 3:
         return array(false,"[Telnet] Connect failed: Login failed");
    default:
    }
}
  
function cambiarPasswordCisco($ip,$password){
    //Verificamos si es un alta o baja de equipo en la red, preguntando por la password que se le quiere poner
    if ($password == IAD_PASS_ENABLE){
        $curEnablePW = IAD_DF_PASS_ENABLE;
    }
    else{
        $curEnablePW = IAD_PASS_ENABLE;
    }
    
    $telnet = new PHPCiscoTelnet();
    $result = $telnet->Connect($ip, IAD_USER_ADMIN, IAD_PASS_ADMIN);
    
    switch ($result) {
    case 0:
         if (!$telnet->enable($curEnablePW))
             return array(false,"Password enable incorrecta");
         $telnet->DoCommand("conf t\n");
         sleep(1);
         $telnet->changeEnable($password);
         sleep(1);
         $telnet->Disconnect();
         return array(true,$telnet->display());
    case 1:
         return array(false,"[Telnet] Connect failed: Unable to open network connection");
    case 2:
         return array(false,"[Telnet] Connect failed: Unknown host");
    case 3:
         return array(false,"[Telnet] Connect failed: Login failed");
    default:
         return array(false,"Default");
    }
}
