<?php
require_once '/www/pkgtester/iplan/database/Connection.php';


/**
* Author: Jorge Alexis Viqueira
* Date: 2010-08-24
* Last Modified: 2010-08-26
* 
*/
/**
 * Concreci�n de una conexi�n Oracle
 */
class OracleConnection extends Connection {
  private $host;

  private $port;

  private $schema;

  private $user;

  private $password;

  /**
   * Un arreglo que permite un acceso r�pido a los tipos de datos nativos
   */
  private static $oraTypes = array(
	Connection::T_BLOB => SQLT_BLOB,
	Connection::T_BINARY_FILE => SQLT_BFILEE,
	Connection::T_CBLOB => SQLT_CLOB,
	Connection::T_BINARY_FILE => SQLT_BFILEE,
	Connection::T_CHAR => SQLT_CHR,
	Connection::T_CHARACTER_FILE => SQLT_CFILEE,
	Connection::T_CURSOR => SQLT_RSET,
	Connection::T_CUSTOM => SQLT_NTY,
	Connection::T_LONG => SQLT_LNG,
	Connection::T_INT => SQLT_INT,
	Connection::T_VARCHAR=>SQLT_CHR
);

  private static $oraTransactionModes = array(Connection::TR_DEFAULT=>OCI_DEFAULT,
         Connection::TR_AUTO_COMMIT=>OCI_COMMIT_ON_SUCCESS,
	 Connection::TR_NO_AUTO_COMMIT=>OCI_DEFAULT);

  private $session_mode;

  /**
   * Almacena temporalmente la conexi�n
   */
  private $connection = null;

  /**
   * Crea una instancia del objeto en base a los datos especificados
   */
  public function __construct($host, $port, $schema, $user, $password, $session_mode = OCI_DEFAULT)
  {
    // Bouml preserved body begin 00036385
    $this->host    = $host;
    if ($port==-1) {
        $port=1521;
    }
    $this->port    = $port;
    $this->schema  = $schema;
    $this->user    = $user;
    $this->password= $password;
    $this->session_mode=$session_mode;
    return $this;
    // Bouml preserved body end 00036385
  }

  /**
   * Cierra la conexi�n antes de destruir el objeto
   */
  public function __destruct()
  {
if ($this->isConnected()) {
    $this->close();
}
  }

  /**
   * Recupera la cantidad de filas afectadas (modificadas) por la �ltima operaci�n
   */
  public function affectedRows($query)
  {
    // Bouml preserved body begin 00039805
    return oci_num_rows($query);
    // Bouml preserved body end 00039805
  }

  /**
   * Inicia una transacci�n
   */
  public function beginTransaction()
  {
    // Bouml preserved body begin 00032885
    $statement = oci_parse($this->connection,"SAVEPOINT StartTransaction");
    return oci_execute($statement, OracleConnection::$oraTransactionModes[Connection::TR_NO_AUTO_COMMIT]);
    // Bouml preserved body end 00032885
  }

  /**
   * Asocia el valor de $value a la variable $name del prepared statement. Para ello se debe indicar adem�s el tama�o (-1 para que tome el sizeof() de $value) y el tipo de datos.
   */
  public function bind($preparedStatement, $name, &$value, $size = -1, $type = Connection::T_VARCHAR)
  {
    // Bouml preserved body begin 0003B205
    return ocibindbyname($preparedStatement, $name, $value, $size, OracleConnection::$oraTypes[$type]);
    // Bouml preserved body end 0003B205
  }

  /**
   * Cierra la conexi�n si est� abierta
   */
  public function close()
  {
    // Bouml preserved body begin 00032985
    $result = oci_close($this->connection);
    if ($result) $this->connection=null;
    return $result;
    // Bouml preserved body end 00032985
  }

  /**
   * Hace un commit de los cambios hasta el momento
   */
  public function commit()
  {
    // Bouml preserved body begin 00032A05
    return oci_commit($this->connection);
    // Bouml preserved body end 00032A05
  }

  /**
   * Establece la conexi�n con los par�metros que posee registrados en la clase
   */
  public function connect()
  {
    // Bouml preserved body begin 00032A85
    $strConnectionString ="(DESCRIPTION = (ADDRESS = (PROTOCOL = TCP)(HOST =$this->host)(PORT = $this->port))
                            (CONNECT_DATA =(SERVER = DEDICATED) (SERVICE_NAME = $this->schema)))";
    $connection= $this->connection = oci_connect($this->user, $this->password, $strConnectionString);
    return $connection;
    // Bouml preserved body end 00032A85
  }

  /**
   * Crea un cursor sobre la conexi�n especificada
   */
  public function createCursor()
  {
    // Bouml preserved body begin 0003CC85
    return oci_new_cursor($this->connection);
    // Bouml preserved body end 0003CC85
  }

  /**
   * Ejecuta el sql indicado y retorna lo que devuelva
   */
  public function execute($statement, $mode = Connection::TR_DEFAULT)
  {
    // Bouml preserved body begin 00032B05
    $result = null;
    if (is_string($statement)) {
        $statement = oci_parse($this->connection, $statement);
    }

    if ($mode==Connection::TR_DEFAULT) {
        try {
            $result= oci_execute($statement);
        }  catch (ErrorException $e) {
            $result = false;
        }
    } else {
        $result = oci_execute($statement, OracleConnection::$oraTransactionModes[$mode]);
    }
    return $result;
    // Bouml preserved body end 00032B05
  }

  /**
   * Ejecuta una funci�n en la base de datos y retorna el valor.
   * Es posible, indicar la variable en la cual queremos bindear el resultado, su tipo y tama�o en caso de ser necesario. Si la misma no se especifica se utiliza un valor interno y se retorna una copia del valor del resultado.-
   */
  public function executeFunction($name, &$params, &$result = null, $type = Connection::T_VARCHAR, $size = -1)
  {
    // Bouml preserved body begin 0003CB85
    $strParams ="";//Preparo el string de los parámetros
    foreach($params as $key=>$value) {
        $strParams .= ":param$key, ";
    }
    $strParams = "(". substr($strParams, 0, strlen($strParams)-2) .")";
    $strSQL = "begin :data := $name$strParams; end;";
    $preparedStatement = $this->prepareStatement($strSQL);
    if ($preparedStatement===false) {
        return false;
    }
    
    //Bindeo el resultado con lo que me pasaron o algo propio
    if (oci_bind_by_name($preparedStatement,":data",$result,$size,OracleConnection::$oraTypes[$type])) {
        //Luego los resultados
        foreach($params as $key => $value) {
            if (!oci_bind_by_name($preparedStatement, ":param$key", $params[$key])) {
                return false;
            }
        }
        if ($this->execute($preparedStatement)) {
            return $result;
        } else {
            return false;
        }
    } else {
        return false;
    }
    // Bouml preserved body end 0003CB85
  }

  /**
   * Ejecuta el procedimiento bindeando los valores de los par�metros en el orden en que se encuentren
   */
  public function executeProcedure($name, &$params)
  {
    // Bouml preserved body begin 00037E05
    $strParams ="";//Preparo el string de los parámetros
    foreach($params as $key=>$value) {
        $strParams .= ":param$key, ";
    }
    $strParams = "(". substr($strParams, 0, strlen($strParams)-2) .")";
    $strSQL = "begin $name$strParams; end;";
    $preparedStatement = $this->prepareStatement($strSQL);
    if ($preparedStatement===false) { return false; }
    //Bindeo los parámetros
    foreach($params as $key => $value) {
        if (!ocibindbyname($preparedStatement, ":param$key", $params[$key])) {
            return false;
        }
    }
    return $this->execute($preparedStatement);
    // Bouml preserved body end 00037E05
  }

  /**
   * Restorna una fila del conjunto de resultados en un arreglo indexado como se indique en $mode y avanza una posici�n el cursor del $resource
   */
  public function fetch($resource, $mode = Connection::M_ASSOCIATIVE)
  {
    // Bouml preserved body begin 00032D05
    if ($mode==Connection::M_ASSOCIATIVE) {
        return oci_fetch_array($resource, OCI_ASSOC);
    } else {
        return oci_fetch_array($resource, OCI_NUM);
    }
    // Bouml preserved body end 00032D05
  }

  /**
   * Retorna un arreglo con los registros recuperados de la consulta. Se provee la facilidad de indicar que se saltee tantos registros como se indiquen en $offest y que se recuperen s�lo una cierta cantidad de ellos; se una -1 en caso de querer recuperar todas las filas disponibles desde $offset.
   * En forma predeterminada retorna un arreglo asociativo, lo cual puede cambiarse con el par�metro $mode.
   */
  public function fetchAll($resource, $mode = Connection::M_ASSOCIATIVE, $offset = 0, $count = -1)
  {
    // Bouml preserved body begin 00032D85
    if ($mode==Connection::M_ASSOCIATIVE) {
        $flags=OCI_FETCHSTATEMENT_BY_ROW+OCI_ASSOC;
    } else {
        $flags=OCI_FETCHSTATEMENT_BY_ROW+OCI_NUM;
    }
    if (oci_fetch_all($resource, $result, $offset, $count, $flags)) {
        return $result;
    } else {
        return false;
    }
    // Bouml preserved body end 00032D85
  }

  /**
   * Libera un recurso previamente asignado.
   */
  public function free(&$resource)
  {
    // Bouml preserved body begin 00032E05
    return oci_free_statement($resource);
    // Bouml preserved body end 00032E05
  }

  /**
   * Retorna true si la conexi�n est� activa o false en caso contrario
   */
  public function isConnected()
  {
    // Bouml preserved body begin 00032E85

    if (isset($this->connection)) {
        return !is_null($this->connection) && ($this->connection != false);
    } else return false;
    // Bouml preserved body end 00032E85
  }

  /**
   * Retorna un texto que describe el �ltimo error que sucedi� en la conexi�n. Si se desea se puede acompa�ar del handler que retorno la funci�n que fall� o de lo contrario se retorna el �ltimo error que se dio en la conexi�n.
   */
  public function lastError($over = -1)
  {
    // Bouml preserved body begin 00032F05
    if ($over == -1) {
        $data = oci_error();
    } else {
        $data = oci_error($over);
    }

    if ($data == false) {
        return false;
    } else {
        return $data['message'];
    }
    // Bouml preserved body end 00032F05
  }

  /**
   * Retorna el c�digo del �ltimo error que se present� en la conexi�n o en el handler del par�metro
   */
  public function lastErrorCode($over = -1)
  {
    // Bouml preserved body begin 00032F85
    if ($over == -1) {
        $data = oci_error();
    } else {
        $data = oci_error($over);
    }

    if ($data != false) {
        return $data['code'];
    } else {
        return false;
    }
    // Bouml preserved body end 00032F85
  }

  /**
   * Salta al siguiente conjunto de resultados
   */
  public function nextResultset($handler)
  {
    // Bouml preserved body begin 00033005
    return false;
    // Bouml preserved body end 00033005
  }

  /**
   * Retorna el n�mero de columnas del handler del query especificado
   */
  public function numColumns($query)
  {
    // Bouml preserved body begin 00033085
    return oci_num_fields($query);
    // Bouml preserved body end 00033085
  }

  /**
   * Retorna el n�mero de filas que devolvi� el query especificado
   */
  public function numRows($query)
  {
    // Bouml preserved body begin 00033105
    if (oci_statement_type($query)=="SELECT") {
        return 0;
    } else {
        return oci_num_rows($query);
    }
    // Bouml preserved body end 00033105
  }

  /**
   * Retorna un handler a un prepared statement
   */
  public function prepareStatement($sql)
  {
    // Bouml preserved body begin 00033185
    return oci_parse($this->connection, $sql);
    // Bouml preserved body end 00033185
  }

  /**
   * Ejecuta la instrucci�n SQL y retorna el resultado.
   */
  public function query($sql)
  {
    // Bouml preserved body begin 00033205
    $statement = oci_parse($this->connection, $sql);
    oci_execute($statement, OracleConnection::$oraTransactionModes[Connection::TR_NO_AUTO_COMMIT]);
    return $statement;
    // Bouml preserved body end 00033205
  }

  /**
   * Si el motor de la base de datos lo soporta, hace un rollback de la �ltima transacci�n
   */
  public function rollback()
  {
    // Bouml preserved body begin 00033285
    //return oci_rollback($this->connection);
    $statement = oci_parse($this->connection, "ROLLBACK TO SAVEPOINT StartTransaction");
    return oci_execute($statement);
    // Bouml preserved body end 00033285
  }

  /**
   * Retorna la informaci�n de status del motor
   */
  public function status()
  {
    // Bouml preserved body begin 00033305
    return false;
    // Bouml preserved body end 00033305
  }

}
?>
