<?php
session_start();
require_once('krumo/class.krumo.php');
require_once "iplan/database/OracleConnection.php";

function valuePost($postParameter) {
    if (isset($_POST[$postParameter])) {
        return ' value="'.$_POST[$postParameter].'"';
    } else return '';
}


$showError = false;
if (isset ($_POST['action'])) {
    $action   = $_POST['action'];

    switch ($action) {
        case 'connect':
                    $oracle = new OracleConnection($_POST['host'],$_POST['port'],$_POST['database'],$_POST['user'],$_POST['password']);
                    if (@$oracle->connect()) {
                        $_SESSION['connected']=true;
                        $_SESSION['host']=$_POST['host'];
                        $_SESSION['port']=$_POST['port'];
                        $_SESSION['database']=$_POST['database'];
                        $_SESSION['user']=$_POST['user'];
                        $_SESSION['password']=$_POST['password'];
                        $_SESSION['rows-per-page']=50;
                        $_SESSION['page']=0;
                    } else {
                       $showError = true;
                    }
                    break;
        case 'disconnect':
                    session_destroy();
                    unset($_SESSION['connected']);
                    break;
        default:
    }
}
?>
<html>
    <head>
        <title>
            Oracle Query Packages - (OQP, OCUPE jeje :P)
        </title>
        <!--link rel="stylesheet" href="css/ui-lightness/jquery-ui-1.8.5.custom.css"-->
        <link rel="stylesheet" type="text/css" href="css/blitzer/jquery-ui-1.8.5.custom.css">
        <link rel="stylesheet" type="text/css" href="css/general.css"/>
        <script type="text/javascript" src="js/jquery-1.4.2.min.js" charset="utf-8"></script>
        <script type="text/javascript" src="js/jquery.corner.js"></script>
        <script type="text/javascript" src="js/jquery-ui-1.8.5.custom.min.js"></script>
        <script type="text/javascript" src="js/jquery.getattributes.min.js"></script>
        <script type="text/javascript" src="js/splitter.js"></script>
        <script type="text/javascript" src="js/jquery.simpletip-1.3.1.js"></script>
        <script type="text/javascript" src="js/general.js"></script>
        <style>
            img {border-style: none;}
            .desktop {position:absolute; top: 0; left: 0; width: 100%; height: 100%; background: #CCF;}
            .groupbox {border-style: solid; border-color: activeborder; border-width: 2px;background-color: buttonface;}
                .title {font-family: sans-serif; font-size: 1em; font-weight: bold; vertical-align: middle; background-color: buttonshadow; min-height: 22px;}
            .label {font-family: sans-serif; font-size: 1em; font-weight: normal;}
                .label:after {content: " "}
            .value {font-family: sans-serif;color: green;}
            .break {display: block;}
            .button {border-style: outset; border-width: thin; border-color: buttonshadow; background-color: buttonface; color: buttontext; margin: 2px;}
            .separator {margin-left: -20px}
            .separator_text {}
            
            .column {display: inline-table;border-style: double;}
            .column_head{font-family: sans-serif; background-color: buttonhighlight; color: captiontext;display: block;border-bottom-style: double;}
            .column_data{font-family: sans-serif; background-color: buttonface; color: buttontext;display: block}

            .debugBox {top:300px;width: 200px; min-height: 200px;border-color: #CCA;border-style: solid; overflow: hidden;}
            .bold {font-weight: bold}
            .italic {font-style: italic}

            .tabContent {overflow: scroll;}
            <?if (isset($_SESSION['connected'])) {?>
            .topbar {width: 100%; min-height:150px; background: blue;display: inline-table;}
            <?}?>
                #database {height: 100%; min-width: 250px;max-width: 430px;display: table-cell;}
                #query {height: 100%;display: table-cell;}
            #resultset {width: 100%;}

            .hsplitbar { height: 3px; background: #aaa;}
        </style>
        <script type="text/javascript">
            var $tmp_tab_content;
            var $tmp_tab_content_title = "";
            var $tabs;
            var $tabNames = new Array();
            var $panels = new Array();

            function help() {
                blockScreen("");
                var helpText = '<span style="text-align:left">Modo de uso<br><pre>    [<span class="bold">/</span><span class="italic" style="color:red">nombreSolapa</span>?[<span class="bold" style="color:#00EE10">:</span>|<span class="bold" style="color:#0000EE">::</span>]] INSTRUCCI&Oacute;N SQL<span class="bold">;</span>\n\
\n\
<span class="bold">Donde:</span>\n\
      <span class="italic" style="color:red">nombreSolapa</span> es el "alias" de la solapa una vez que se resuelva la consulta\n\
      <span class="bold" style="color:#00EE10">:</span> indica que es un llamado a funci&oacute;n que retorna un valor simple\n\
      <span class="bold" style="color:#0000EE">::</span> indica que es una funci&oacute;n que retorna un cursor\n\
      <span class="bold">;</span> es el separador de instrucciones, si es una sola no es necesario\n\
(*) para usar estas opciones la <span class="bold">/</span> es obligatoria.\n\
\n\
<span class="bold">Ejemplos:</span>\n\
  /Cantidad SELECT COUNT(*) FROM USUARIO;\n\
  /Datos SELECT id, nombre, apellido FROM personas;\n\
  /AdminHabilitado: DBMS_SESSION.IS_ROLE_ENABLED (\'admin\');\n\
\n\
<span class="bold">Nuevo:</span> Se incorpor&oacute; la posibilidad de indicar "alias" a las subconsultas de una solapa.\n\
      Esto se consigue indicando el nombreSolapa con la siguiente sintaxis:\n\
          <span class="italic" style="color:red">nombreSolapa</span><span class="bold" style="color:blue;">&lt;</span><span style="color:green;">alias</span>\n\
<b>Ejemplo:</b>\n\
   /Llamados&lt;Origen:: PACKAGE.FU_GET(\'01143150630\');\n\
   /Llamados&lt;Destino::PACKAGE.FU_GET(\'02214225019\');\n\
</pre>\n\</span>';
                messageBlockScreen(helpText, false, true);
            }

            function showOracleHelp($error) {
                
            }

            function changeRowsPerPage() {
                blockScreen('Cambiando la configuraci&oacute;n de filas.<br>por favor espere...');
                send('PKG_tester.php', {'action':'change_rows_per_page',
                                        'rows_per_page':$('#rowsPerPage').val()},
                    function (data, extra) {
                        unBlockScreen();
                        $(data).find('status');
                    }, true);
            }

            function execute() {
                blockScreen('Ejecutando la consulta...');
                var sql = $("#sql_text").val();
                $panels = new Array();
                $tabNames = new Array();
                send('PKG_tester.php', {'action':'exec_sql', 'sql':sql},
                        function (data, extra) {
                            for(var i=$tabs.tabs("length"); i > 0;i--) {
                                $tabs.tabs("remove",i-1);
                            }
                            var status = $(data).find('status').text();
                            if (status == "ERROR") {
                                messageBlockScreen($(data).find('result').text(), false, true);
                            } else {
                                var resultsets = $(data).find('resultset').each(loadResultsetTab);
                                unBlockScreen();
                            }
                        }, true);
            }

            function loadResultsetTab() {
                var resultset = $(this);
                var rows = null;
                var columns = new Array();
                if (resultset.attr('status')==1) {
                    rows = resultset.find('row');
                    if (rows.length > 0) {
                        var fields = rows.get(0).attributes;
                        for(var i = fields.length-1; i >= 0; i--) {
                            columns.push(fields.item(i).nodeName);
                        }
                    }
                    $tmp_tab_content = '<table border="1">' + buildTitles(columns) +  fillTable(rows, columns) + "</table>";
                } else {
                    $tmp_tab_content = '<a href="http://www.techonthenet.com/oracle/errors/ora'+resultset.find("error").text()+'.php">'+resultset.find("error").text()+'</a>: '+resultset.find("description").text();
                }
                
                //Si ya está creada agrega el contenido a continuación del existente, sino crea una solapa nueva
                var into = resultset.attr("into");
                var tabName = "#tab-";
                var subqueryText = "";
                if (into == "") {
                    tabName +=resultset.attr("id");
                    $tmp_tab_content_title="";
                } else {
                    tabName += into;
                    $tmp_tab_content_title = resultset.attr("id");
                }

                if ($.inArray(tabName, $tabNames)==-1) {
                    $tabNames.push(tabName);
                    if (into == "") $tabs.tabs("add", tabName, resultset.attr("id"));
                    else $tabs.tabs("add", tabName, into);
                } else {
                    appendContent(tabName, $tmp_tab_content);
                }

                if (resultset.attr('status')==0) {
                    tabName = "#"+tabName.substr(5);
                    $(tabName).find("img").attr("src", "images/error.png");
                }
            }

            function appendContent(tabName, content) {
                $($panels[$.inArray(tabName, $tabNames)]).append('<div class="separator"><span>'+(($tmp_tab_content_title=="")?"Subquery":$tmp_tab_content_title)+'</span></div>'+content);
            }

            function fillTable(rows, attributes) {
                var html = "";
                if (rows != null) {
                    $(rows).each(function() {
                        var row = $(this);
                        html += "<tr>";
                        for(var i = 0; i < attributes.length; i++) {
                            if (row.attr(attributes[i]) != "") {
                                html += "<td>"+row.attr(attributes[i])+"</td>";
                            } else {html += "<td style=\"font-style: italic\">null</td>";}
                        }
                        html += "</tr>";
                    });
                } else {
                    html = "<tr><td style=\"font-style: italic\">Empty</td></tr>";
                }
                return html;
            }

            function buildTitles(columns) {
                var html='<tr>';
                if (columns.length > 0) {
                    for(var i = 0; i < columns.length;i++) {
                        html += '<th style="text-transform: capitalize">'+columns[i]+'</th>';
                    }
                } else {
                    html += "<th>Empty set</th>";
                }
                return html+'</tr>';
            }

            function resizeTextArea() {
                var area = $('#sql_text');
                alert("X: "+area.width()+", Y: "+area.height());
            }

            function initialize() {
                initializeScreenBlocker("Procesando...");
                $tabs = $('#tabs').tabs();
                //<span style="background:url(images/OK.png);min-width:16px;height:16px;">&nbsp;</span>
                //<img src="images/OK.png">
                $tabs.tabs("option", 'tabTemplate', '<li id="#{label}"><img src="images/OK.png" style="float:left;"> <a href="#{href}">#{label}</a></li>');
                $tabs.tabs("option", 'add', function(event, ui) {
                                                panel = $(ui.panel);
                                                $panels.push(panel);
                                                panel.addClass("tabContent");
                                                if ($tmp_tab_content_title != "") {
                                                    panel.append('<div class="separator">'+$tmp_tab_content_title+'</span>');
                                                }
                                                panel.append($tmp_tab_content);
                                                });
                <?if ($showError) {
                    echo "messageBlockScreen('Se produjo un error:<br>".$oracle->lastErrorCode().": ".$oracle->lastError()." ', false, true);";
                }
                if (isset($_SESSION['connected'])) {
                    echo "$('.desktop').splitter({splitHorizontal:true, sizeTop:true});";
                    echo '$("#query").attr(\'onresize\', "javascript:resizeTextArea();");';
                }?>
                
            }
            
            $(document).ready(initialize);
        </script>
    </head>
    <body>
        <div class="desktop">
            <div class="topbar">
                <div id="database" class="groupbox">
                    <div class="title">Database</div>
                        <form action="index.php" method="post">
                    <?if (!isset($_SESSION['connected'])) {?>
                        <input type="hidden" name="action" value="connect"/>
                        <span class="label">Host</span><input name="host" type="text" tabindex="1" size="20" <?=valuePost('host')?>/>
                        <span class="label">Port</span><input name="port" type="text" tabindex="2" size="4" <?=valuePost('port')?>/><span class="break"></span>
                        <span class="label">Database</span><input name="database" type="text" tabindex="3" size="30" <?=valuePost('database')?>/><span class="break"></span>
                        <span class="label">User</span><input name="user" type="text" tabindex="4" size="10" <?=valuePost('user')?>/>
                        <span class="label">Password</span><input name="password" type="password" tabindex="5" size="15" <?=valuePost('password')?>/><span class="break"></span>
                        <span class="break">&nbsp;</span>
                        <center><input type="submit" value="Try connect..."/><input name="clear" type="reset" value="Clear fields"/></center>
                    <?} else {?>
                        <input type="hidden" name="action" value="disconnect"/>
                        <span class="label">Host</span><span class="value"><?=$_SESSION['host']?></span>
                        <span class="label">Port</span><span class="value"><?=$_SESSION['port']?></span><span class="break"></span>
                        <span class="label">Database</span><span class="value"><?=$_SESSION['database']?></span><span class="break"></span>
                        <span class="label">User</span><span class="value"><?=$_SESSION['user']?></span><span class="break"></span>
                        <span class="break">&nbsp;</span>
                        <center><input type="submit" value="Disconnect"/></center>
                    <?}?>
                        </form>
                </div>
        <?if (isset($_SESSION['connected'])) {?>
                <div id="query" class="groupbox">
                        <div class="title">Query <a href="javascript:help();"><img src="images/1287693122_help.png" alt="Ayuda"></a></div>
                    <form>
                        <span class="label">SQL Instruction</span><span style="float:right"><a class="button" href="javascript:execute();">Execute</a></span>
                        <span class="break"></span>
                        <textarea id="sql_text" tabindex="1" cols="120" rows="5"><?if(isset($_SESSION['sql'])) echo $_SESSION['sql'];?></textarea>
                    </form>
                </div>
        <?}?>
            </div>
        <?if (isset($_SESSION['connected'])) {?>
        <div id="resultset" class="groupbox">
            <div class="title">Resultset<span style="float:right;"><span class="label">Rows per page</span><select id="rowsPerPage" onchange="javascript:changeRowsPerPage();">
                                <option value="10">10</option>
                                <option value="20">20</option>
                                <option value="50" selected>50</option>
                                <option value="100">100</option>
                                <option value="200">200</option>
                                <option value="1000">1000</option>
                          </select></span>
            </div>
            <div id="tabs"><ul></ul></div>
        </div>
        <?}?>
        </div>
    </body>
</html>