<?php
session_start();
error_reporting(E_ALL);
require_once "iplan/database/OracleConnection.php";
/*
 * Genera un elemento XML en base al tag y una arreglo de atributos.
 * Nótese que si en el array de atributos alguna Key tiene "_" es
 * reemplazado por un "-".
 */
function makeXMLElement($strTag, $arrAttributes) {
    $strAttributes = '';
    foreach($arrAttributes as $strAttr => $strValue) {
	$strValue2 = str_replace(array("\"","'","&","<", ">"), array("&#34;","&#39;","&#38;","&#60;","&#62;"), $strValue);
        $strAttributes .= ("$strAttr=\"$strValue2\" ");
    }
    return "<$strTag ".$strAttributes."/>";
}

/*
 * Verifica la existencia del parámetro en el $_POST y si no existe retorna el valor por default.
 */
function getParam($strParamName, $defaultValue='') {
    if (isset($_POST[$strParamName])) {
        $value = $_POST[$strParamName];
    } else {
        if (isset($_GET[$strParamName])) {
            $value = $_GET[$strParamName];
        } else {
            $value=$defaultValue;
        }
    }
    return $value;
}

function connect() {
    global $oracle; global $result;
    $oracle = new OracleConnection($_SESSION['host'],$_SESSION['port'],$_SESSION['database'],$_SESSION['user'],$_SESSION['password']);
    if (!$oracle->connect()) {
        $action='';
        setError();
        return false;
    }
    return true;
}

function report($resulsetName, $status, $into, $response, $over = "") {
    global $oracle, $result;
    $error = "";
    if ($status==0) {
        if ($over != "") {
            $error = "<error>".str_pad($oracle->lastErrorCode($over),5,"0",STR_PAD_LEFT)."</error><description>".$oracle->lastError($over)."</description>";
        } else {
            $error = "<error>".$oracle->lastErrorCode()."</error><description>".$oracle->lastError()."</description>";
        }
    }
    $result .= "<resultset id=\"$resulsetName\" status=\"$status\" into=\"$into\">$response$error</resultset>";
}

function setError() {
    global $result;
    $error = $oracle->lastErrorCode() . ": ".$oracle->lastError();
    $result = "<msg>Error al conectar [$error]</msg>";
}

function parse($sql) {
    $open = '';
    $scape = false;
    $block = false;
    $from  = 0;
    $result = array();
    for($i=0;$i<strlen($sql);$i++) {
       if ($scape) {
           $scape=false;
       } else {
           switch ($sql[$i]) {
               case '\\': $scape=true; break 1;
               case '"' : if ($open == '"') $open = '';   break 1;
               case "'" : if ($open == "'") $open = '';   break 1;
               case "[" : if ($open == "") $block = true; break 1;
               case "]" : if ($open == "") {
                             $block = false;
                             $tmp_result[] = trim(substr($sql, $from, $i-$from));
                             $from=$i+1;
                          }
                          break 1;
               case ";" : if ($open == "" && !$block) {
                             $value = trim(substr($sql, $from, $i-$from));
                             if ($value != "") $tmp_result[] = $value;
                             $from=$i+1;
                          }
                          break 1;
               default:
           }
       }
    }
   if ($from <> $i) $tmp_result[] = trim(substr($sql, $from, $i-$from));

   $noName=1;
   foreach($tmp_result as $str) {
       if ($str[0] == "/") {
           $i = strpos($str, " ");
           $result[] = array('name'=>substr($str, 1, $i-1), 'sql'=>substr($str, $i+1));
       } else {
           $result[]=array('name'=>"Unamed_".$noName++, 'sql'=>$str);
       }
   }
   return $result;
}


$action   = getParam('action', '');//La acción invocada
$status   = false;//True si esta todo OK o false de lo contrario
$result= "";//El conjunto de salida, generalmente un XML o un texto de error
$oracle = null;

//Si no hay sesión conectada, se sale directamente sin hacer nada.
if (!isset($_SESSION['connected']) || !$_SESSION['connected']) {
    $result = "Usted no está conectado";
    $action="";
}

switch ($action) {
    case 'exec_sql':
                $sql = getParam('sql', false);
                if (get_magic_quotes_gpc()) {
                    $sql = stripslashes($sql);
                }
                if (connect() && $sql) {
                    $_SESSION['sql'] = $sql;
                    $querys_sql=parse(trim($sql));
                    if ($querys_sql) {
                        foreach($querys_sql as $query_arr) {
                            $key = $query_arr['name'];
                            $into="";
                            if ($division=strpos($key, "<")) {
                                list($into, $key)=preg_split("/</", $key);
                            }
                            $query_sql = $query_arr['sql'];
                            switch ($key[strlen($key)-1]) {
                                case ":": //Función
                                    if ($query = $oracle->prepareStatement("begin :result := $query_sql; end;")) {
                                        if ($key[strlen($key)-2]==":") { //Función que retorna un cursor
                                            $key = substr($key, 0, strlen($key)-2);
                                            $output = $oracle->createCursor();
                                            if (!$oracle->bind($query, ":result", $output, -1, Connection::T_CURSOR))
                                                $status = 0;
                                        } else {
                                            $key = substr($key, 0, strlen($key)-1);
                                            $output = "";
                                            $oracle->bind($query, ":result", $output);
                                        }

                                        if ($oracle->execute($query)) {
                                            switch(true) {
                                                case (is_array($output)):
                                                        $result_query = "";
                                                        foreach($output as $row) {
                                                            $result_query .= makeXMLElement('row', $row);
                                                        }
                                                        report($key, 1, $into, $result_query);
//                                                        $result .= "<resultset id=\"$key\" status=\"1\" into=\"$into\">$result_query</resultset>";
                                                        break;
                                                case (is_resource($output)):
                                                        $oracle->execute($output);
                                                        $tmpResult = $oracle->fetchAll($output, Connection::M_ASSOCIATIVE, 0, $_SESSION['rows-per-page']);
                                                        $result_query = "";
                                                        if ((count($tmpResult)>0) && ($tmpResult)) {
                                                            foreach($tmpResult as $row) {
                                                                $result_query .= makeXMLElement('row', $row);
                                                            }
                                                        }
                                                        report($key, 1, $into, $result_query);
                                                        break;
                                                default:
                                                    report($key, 1, $into, $output);
                                            }
                                        } else {
                                            report($key, 0, $into, "", $query);
                                        }

                                    } else {
                                        report($key, 0, $into, "");
                                    }
                                    break 1;
                                case "[": //Bloque de ejecución
                                    /*Acá hay un tema con la declaración, debiera ser parseada más "finito" para contemplar la asignación
                                     * para el caso de IN OUT:
                                     *
                                     *        /miBloque[ :variable|type,subtype=valor
                                     *
                                     * El tema que valor puede ser un string con lo cual debiera de parsearse al estilo "tiene comillita,
                                     * entonces ignoro". Me da fiaca
                                     */
                                    $key = substr($key, 0, strlen($key)-1);//Saco el "["

                                    //Separo la primer lína para definición de variables y el resto para SQL
                                    $fstLine = strpos($query_sql, "\n");
                                    $var_declaration = substr($query_sql, 0, $fstLine);
                                    $var_sql = substr($query_sql, $fstLine+1);

                                    //Si el SQL es válido entonces parseo las variables
                                    if ($prepared_statement = $oracle->prepareStatement("BEGIN\n$var_sql\nEND;")) {
                                        //Se separan por espacios
                                        $tmpVars = preg_split("/\s/", trim($var_declaration), -1, PREG_SPLIT_NO_EMPTY);

                                        //Parseo las variables, pongo la expresión regular con grupos nombrados para ayuda
                                        foreach($tmpVars as $txtVar) {
                                            //preg_match("/(?P<name>\w+)[|]?(?P<type>\w*)[,]?(?P<subtype>\w*)[=]?(?P<value>\w*)/i", $txtVar, $tmpParts);
                                            preg_match("/(\w+)[|]?(\w*)[(]?(\d*)[)]?[,]?(\w*)[=]?(\w*)/i", $txtVar, $tmpParts);
                                            $vars[]= $tmpParts;
                                        }
                                        /*
                                         * En $vars queda un arreglo por cada variable con los siguientes campos:
                                         * 0 = El string parseado
                                         * 1 = El nombre de la variable
                                         * 2 = El tipo
                                         * 3 = El tamaño (usado para OUT)
                                         * 4 = El subtipo (información para display)
                                         * 5 = El valor inicial
                                         */

                                        //Esto se tendría que ejecutar por cada instrucción, detectando las variables que intervienen y reemplazando su valor.

                                        foreach($vars as $idx => $var) { //Bindeo las variables
                                            $var_type=($var[2] == "")?Connection::T_VARCHAR:eval ("return Connection::T_".strtoupper($var[2]).";");
                                            if (!$oracle->bind($prepared_statement, $var[1], $vars[$idx][5], (($var[3]=="")?-1:(int)$var[3]), $var_type)) {
                                                report($key, 0, $into, "", $prepared_statement);
                                                break;
                                            }
                                        }
                                        if (@$oracle->execute($prepared_statement)) { //Ejecuto el bloque
                                            $var_values = "";
                                            foreach($vars as $var) {
                                                $var_values .= makeXMLElement("row", array("Variable"=>$var[1], "Value"=>$var[5]));
                                            }
                                            report($key, 1, $into, $var_values);
                                        } else {
                                            report($key, 0, $into, "", $prepared_statement);
                                        }
                                    } else {
                                        report($key, 0, $into, "");
                                    }
                                    break 1;
                                default: //Select común
                                    $query= $oracle->prepareStatement($query_sql);
                                    if (@$oracle->execute($query)) {
                                        $tmpResult = $oracle->fetchAll($query, Connection::M_ASSOCIATIVE, 0, $_SESSION['rows-per-page']);
                                        $result_query = "";
                                        foreach($tmpResult as $row) {
                                            $result_query .= makeXMLElement('row', $row);
                                        }
                                        if (is_numeric($key)) $key="SQL_$key";
                                        report($key, 1, $into, $result_query);
                                    } else {
                                        report($key, 0, $into, "", $query);
                                    }
                            }//Fin del switch
                        }
                    }
                    $status=true;
                }
                break;
    case 'change_rows_per_page':
                    if ($rowsPerPage = getParam('rows_per_page', false)) {
                        $_SESSION['rows-per-page'] = $rowsPerPage;
                        $status = true;
                    } else {
                        $result = "No se pasó el nro. de páginas";
                    }
                break;
    case 'first_page':
    case 'next_page':
    case 'prev_page':
    case 'last_page':
                break;
    case 'clear_result':
                break;
    case 'get_debug_info':
                    $status=true;
                    foreach($_SESSION as $key=>$value) {
                        $result .= makeXMLElement("property", array('key'=>$key, 'value'=>$value));
                    }
                break;
    default:
        break;

}

if (($oracle != null) && $oracle->isConnected()) {
    $oracle->close();
}

header('Content-type: text/xml');
echo '<?xml version="1.0" encoding="UTF8"?><response><status>'.(($status)?"OK":"ERROR")."</status><result>$result</result></response>";
//echo $result;
?>