<?php
//Ejemplo sacadro de php.net: http://www.php.net/manual/en/language.oop5.visibility.php
    abstract class Dispatcher {
        protected function &accessProperty (self $pObj, $pName) {
            return $pObj->$pName;
        }
        protected function invokeMethod ($pObj, $pName, $pArgs) {
            return call_user_func_array(array($pObj, $pName), $pArgs);
        }
    }

        class Person extends Dispatcher {
        private $name;
        protected $phoneNumbers;

        public function __construct ($pName) {
            $this->name = $pName;
            $this->phoneNumbers = array();
        }
        public function addNumber (PhoneNumber $pNumber, $pLabel) {
            $this->phoneNumbers[$pLabel] = $pNumber;

            // this does not work, because "owner" is protected:
            // $pNumber->owner = $this;

            // instead, we get a reference from the dispatcher:
            $p =& $this->accessProperty($pNumber, "owner");

            // ... and change that:
            $p = $this;
        }
        public function call ($pLabel) {
            // this does not work since "call" is protected:
            // $this->phoneNumbers[$pLabel]->call();

            // instead, we dispatch the call request:
            $this->invokeMethod($this->phoneNumbers[$pLabel], "call", array());
        }
    }

    class PhoneNumber extends Dispatcher {
        private $countryCode;
        private $areaCode;
        private $number;
        protected $owner;

        public function __construct ($pCountryCode, $pAreaCode, $pNumber) {
            $this->countryCode = $pCountryCode;
            $this->areaCode = $pAreaCode;
            $this->number = $pNumber;
        }

        protected function call () {
            echo("calling " . $this->countryCode . "-" . $this->areaCode . "-" . $this->number . "\n");
        }
    }

    $person = new Person("John Doe");
    $number1 = new PhoneNumber(12, 345, 67890);
    $number2 = new PhoneNumber(34, 5678, 90123);
    $person->addNumber($number1, "home");
    $person->addNumber($number2, "office");
    $person->call("home");
?>