<?php
require_once 'iplan/web/Layout.php';
require_once 'iplan/web/Component.php';
require_once 'iplan/web/EmptyComponent.php';



/**
* Author: Jorge Alexis Viqueira
* 
*/
class GridLayout extends Layout {
  /**
   * @var int la mxima cantidad de filas del layout
   */
  protected $rows;

  /**
   * @var int el nmero mximo de columnas que tiene la grilla del layout
   */
  protected $cols;

  /**
   * Crea una distribucin en grilla de las dimensiones indicadas.
   * 
   * @param int $rows la cantidad de filas de la grilla
   * @param int $cols la cantidad de columnas de la grilla
   * 
   * @return GridLayout La instancia de GridLayout 
   */
  public function __construct($rows, $cols)
  {
    // Bouml preserved body begin 000E5105
    $this->rows=$rows;
    $this->cols=$cols;
    return $this;
    // Bouml preserved body end 000E5105
  }

  /**
   * Agrega un componente al layout
   * 
   * @param Component $component el componente a agregar
   * @param int $row la fila del layout donde se ubica el componente
   * @param int $col la columna del layout donde se ubica el componente
   * @param int $horizontalSize el tamao que ocupa el componente en la horizontal
   * @param int $verticalSize el tamao que ocupa el componente en la vertical
   * 
   * @return GridLayout El mismo objeto GridLayour modificado.
   */
  public function addComponent($component, $row, $col, $horizontalSize = 1, $verticalSize = 1)
  {
    // Bouml preserved body begin 000E5085

    //Chequeo las dimensiones de la grilla
    if ((($row+$horizontalSize) <= $this->rows) && (($col+$verticalSize) <= $this->cols)) {
        $this->items[$row][$col]=array($component, $horizontalSize, $verticalSize);
    } else {
        throw new Exception("Desborde de la grilla. El layout es de [$this->rows,$this->cols] y se intentó ubicar un componente en [$row,$col] con dimensiones [H:$horizontalSize, V: $verticalSize]");
    }

    // Bouml preserved body end 000E5085
  }

  public function toArray()
  {
    // Bouml preserved body begin 000E7105
    $result = array();
    $empty = new EmptyComponent();
    
    for($row=0;$row <= $this->rows; $row++) {
        if (isset($this->items[$row])) {
            for($col=0; $col <= $this->cols; $col++) {
                if (isset($this->items[$row][$col])) {
                    list($component, $width, $height) = $this->items[$row][$col];
                    $result[$row][$col]=array($component->toArray(), $width, $height);
                } else {
                    $result[$row][$col]=array($empty->toArray(), 1, 1);
                }
            }
        }
    }
    return array_merge(parent::toArray(), array('items'=>$result));
    // Bouml preserved body end 000E7105
  }

}
?>