<?php
require_once 'iplan/web/Component.php';
require_once 'iplan/web/TemplateInterface.php';



/**
* Author: Jorge Alexis Viqueira
* 
*/
class Form implements TemplateInterface {
  /**
   * @var string es el nombre de la clase sobre la que se modela el formulario, es opcional
   */
  private $class;

  /**
   * @var string el t�tulo del formulario
   */
  private $title;

  /**
   * @var array la lista de items del formulario
   */
  private $items;

  /**
   * Configura la clase base del formulario
   * @param string $class la clase sobre la que pivotea el formulario
   * 
   * @return Form El formulario configurado con la clase indicada
   */
  public function setClass($class)
  {
    // Bouml preserved body begin 000E6D05
    $this->class = $class;
    return $this;
    // Bouml preserved body end 000E6D05
  }

  /**
   * Configura el t�tulo del formulario.
   * 
   * @param string $title el t�tulo que figurar� como encabezado del formulario
   * 
   * @return Form el formulario con el t�tulo configurado
   */
  public function setTitle($title)
  {
    // Bouml preserved body begin 000E8D85
    $this->title = $title;
    return $this;
    // Bouml preserved body end 000E8D85
  }

  /**
   * Agrega un elemento al formulario.
   * 
   * @param Component $component el elemento a agregar
   * 
   * @return Form el formulario al que se le agreg� el elemento.
   */
  public function addComponent($component)
  {
    // Bouml preserved body begin 000E6D85
    $this->items[]=$component;
    return $this;
    // Bouml preserved body end 000E6D85
  }

  /**
   * Retorna un arreglo de todos 
   */
  public function toArray()
  {
    // Bouml preserved body begin 000E8E85
    $result = array(
        'class' =>  $this->class,
        'title' =>  $this->title,
        'items' =>  $this->items);
    // Bouml preserved body end 000E8E85
  }

}
?>