<?php
require_once 'iplan/web/TemplateInterface.php';



/**
* Author: Jorge Alexis Viqueira
* 
*/
/**
 * Es la base de la jerarquia de componentes HTML.
 * 
 * @method string getId()
 * @method Component setId()
 * @method string getName()
 * @method Component setName()
 * @method string getLabel()
 * @method Component setLabel()
 * @method string getStyle()
 * @method Component setStyle()
 * @method string getHint()
 * @method Component setHint()
 * @method string getValidate()
 * @method Component setValidate()
 * @method string getMaps()
 * @method Component setMaps()
 * @method string getValue()
 * @method Component setValue()
 */
class Component implements TemplateInterface {
  /**
   * @var string el identificador con el que se crea el componente en HTML.
   */
  private $id;

  /**
   * @var string el nombre del parmetro que ser remitido al script que procesa el formulario
   */
  private $name;

  /**
   * @var string el rtulo que acompaa al componente en pantalla, es opcional
   */
  private $label;

  /**
   * @var string El estilo personalizado que se aplica al componente (CSS)
   */
  private $style;

  /**
   * @var string descripcin de la funcin del componente o de como usarlo
   */
  private $hint;

  /**
   * @var array|string el conjunto de validaciones que debe aplicarse al componente
   */
  private $validate;

  /**
   * @var string opcional, es el atributo del que se toma o al que le asigna valor el componente
   */
  private $maps;

  /**
   * @var string el valor del dato que visualiza el componente
   */
  private $value;

  /**
   * @var bool indica si el componente est deshabilitado
   */
  private $disabled;

  /**
   * Retorna un arreglo con la informacin para renderizar el objeto.
   * 
   * @return array El arreglo que representa el objeto y sus propiedades
   */
  public function toArray()
  {
    // Bouml preserved body begin 000E5205
    return array(
        'id'        =>$this->id,
        'name'      =>$this->name,
        'label'     =>$this->label,
        'style'     =>$this->style,
        'hint'      =>$this->hint,
        'validate'  =>$this->validate,
        'maps'      =>$this->maps,
        'value'     =>$this->value,
        'disabled'  =>$this->disabled,
        'type'      =>'default'
    );
    // Bouml preserved body end 000E5205
  }

  /**
   * Uso este mtodo para hacer los setter y getter
   */
  public function __call($method, $params)
  {
    // Bouml preserved body begin 000E6C85
    $methodStart = substr($method, 0, 3);
    //Parche para Twig: si se llama a una propiedad como método, se asume "get" + propiedad.
    if (!in_array($methodStart, array('get', 'set'))) {
        $propertyName = substr($method, 3);
    }
    if(strlen($propertyName) > 0) $propertyName[0]=strtolower($propertyName[0]);
    switch ($methodStart) {
        case "get":
                return $this->$propertyName;
            break;
        case "set":
                $this->$propertyName = $params[0];
                return $this;
            break;
        default:
                throw new Exception("La propiedad $propertyName no existe");
            break;
    }
    // Bouml preserved body end 000E6C85
  }

}
?>