<?php
require_once '/home/jviqueira/Documents/Desarrollo-code/wholesale/iplan/users/UserGroup.php';
require_once '/home/jviqueira/Documents/Desarrollo-code/wholesale/iplan/orm/ORMObject.php';
require_once '/home/jviqueira/Documents/Desarrollo-code/wholesale/iplan/orm/ORMDefinition.php';
require_once '/home/jviqueira/Documents/Desarrollo-code/wholesale/iplan/orm/ORM.php';


/**
* Author: Jorge Alexis Viqueira
* 
*/
/**
 * Representa un usuario del sistema, es decir alguien que opera directamente sobre el sistema de gestin sea cliente o no.
 * @method User setName()
 * @method string getName()
 * @method User setMail()
 * @method string getMail()
 * @method User setUserName()
 * @method string getUserName()
 * @method User setpassword()
 * @method string getpassword()
 */
class User extends \iplan\orm\ORMObject {
  protected $name;

  protected $mail;

  protected $userName;

  protected $password;

  protected $state;

  /**
   * @var UserGroup el perfil de acceso del usuario
   */
  protected $userGroup;

  /**
   * Retorna un objeto de definicin predeterminado al cual hay que agregarle los mapeos pertinentes.
   * 
   * @param ORM $orm el objeto que maneja las definiciones
   * @return ORMDefinition la definicin default
   */
  public static function define($orm = null)
  {
    // Bouml preserved body begin 00050705
    return parent::define($orm)
               ->setTable('USUARIO')
               ->addField('id', 'USUARIO_ID', ORM_TYPES::INTEGER)
               ->setKey('id')
               ->addField('name', 'NOMBRE', ORM_TYPES::STRING, 255)
               ->addField('userName', 'USUARIO', ORM_TYPES::STRING, 20)
               ->addField('mail', 'MAIL', ORM_TYPES::STRING, 255)
               ->addField('password', 'PASSWORD', ORM_TYPES::STRING, 10)
               ->addField('state', 'ESTADO', ORM_TYPES::INTEGER)
               ->addInstance('userGroup', 'PERFIL_ID', __NAMESPACE__.'\UserGroup');
    // Bouml preserved body end 00050705
  }

}
?>
