<?php
require_once '/home/jviqueira/Documents/Desarrollo-code/wholesale/iplan/users/UserGroup.php';
require_once '/home/jviqueira/Documents/Desarrollo-code/wholesale/iplan/users/ActionType.php';
require_once '/home/jviqueira/Documents/Desarrollo-code/wholesale/iplan/users/Module.php';
require_once '/home/jviqueira/Documents/Desarrollo-code/wholesale/iplan/orm/ORMDefinition.php';
require_once '/home/jviqueira/Documents/Desarrollo-code/wholesale/iplan/orm/ORM.php';
require_once '/home/jviqueira/Documents/Desarrollo-code/wholesale/iplan/orm/ORMObject.php';


/**
* Author: Jorge Alexis Viqueira
* 
*/
/**
 * Representa una accin del sistema.
 * 
 * @method Action setName()
 * @method string getName()
 * @method Action setValue()
 * @method string getValue()
 * @method Action setActionType()
 * @method ActionType getActionType()
 * @method Action setCreated()
 * @method DateTime getCreated()
 * @method Action setModified()
 * @method DateTime getModified()
 * @method Action setDeleted()
 * @method DateTime getDeleted()
 * @method Action setStatus()
 * @method int getStatus()
 * @method ORMCollection getUserGroups()
 * @method boolean addUserGroup()
 * @method boolean delUserGroup()
 * 
 */
class Action extends \iplan\orm\ORMObject {
  /**
   * El nombre de la accion
   */
  protected $name = "";

  /**
   * @var string el valor de la accin
   */
  protected $value;

  /**
   * @var Date la fecha de creacin
   */
  protected $created;

  /**
   * @var Date la fecha de ltima modificacin
   */
  protected $modified;

  /**
   * @var Date la fecha de borrado
   */
  protected $deleted;

  /**
   * @var int el cdigo de estado
   */
  protected $status;

  /**
   * @var array la lista de perfiles que incluyen la accin
   */
  protected $userGroups;

  protected $actionType;

  /**
   * @var Module el mdulo al que pertenece la accin
   */
  protected $module;

  /**
   * Retorna un objeto de definicin predeterminado al cual hay que agregarle los mapeos pertinentes.
   * 
   * @param ORM $orm el objeto que maneja las definiciones
   * @return ORMDefinition la definicin default
   */
  public static function define($orm = null)
  {
    // Bouml preserved body begin 00055805
    return parent::define($orm)
            ->setTable('PERMISO')
            ->addField('id', "PERMISO_ID", ORM_TYPES::INTEGER)
            ->setKey('id')
            ->addField('name', 'DESCRIPCION', ORM_TYPES::STRING, 255)
            ->addField('value', 'VALOR', ORM_TYPES::STRING, 255)
            ->addField('created', 'FE_ALTA', ORM_TYPES::DATE)
            ->addField('modified', 'FE_MODIFICACION', ORM_TYPES::DATE)
            ->addField('deleted', 'FE_BAJA', ORM_TYPES::DATE)
            ->addRelationNxM('userGroups', 'PERMISOPERFIL', 'PERMISO_ID', __NAMESPACE__.'\UserGroup', 'PERFIL_ID')
            ->addInstance('actionType', 'T_PERMISO_ID', __NAMESPACE__.'\ActionType');
    // Bouml preserved body end 00055805
  }

}
?>
