<?php
require_once "iplan/twig/node/ActionNode.php";
require_once "iplan/security/Application.php";

class ActionTokenParser extends Twig_TokenParser {
    private $application;

    public function __construct(Application $application) {
        $this->application = $application;
    }

    public function parse(Twig_Token $token) {
        $lineno = $token->getLine();
/*        $module_alias = $this->parser->getStream()->expect(\Twig_Token::NAME_TYPE)->getValue();
        $this->parser->getStream()->expect(\Twig_Token::PUNCTUATION_TYPE, '.');
        $action_name = $this->parser->getStream()->expect(\Twig_Token::NAME_TYPE)->getValue();
 */
        $expr = $this->parser->getExpressionParser()->parseExpression();
        $this->parser->getStream()->expect(Twig_Token::BLOCK_END_TYPE);   //El fin de bloque
        $orm = $this->application->getORM();
        //Busco si la acción existe.
        $context = $this->application->getContext();
        $queryAction = $orm->query('Action');
        $queryAction->filterBy('method', '=', $action_name)
              ->filterBy('facade.alias','=', $module_alias)
              ->orderBy('id', 'ASC');
        $action = $queryAction->findOne();
        $value = null;
        if ($action != FALSE) {
            //Chequeo que dicha acción esté en un perfil asociado al usuario para este proveedor
            $queryPermission = $orm->query('Profile')
                        ->filterBy('users.id','=',$context->getUser()->getId())
                        ->filterBy('provider.id','=',$context->getProvider()->getId())
                        ->filterBy('actions.id', '=',$action->getId())
                         ->orderBy('id', 'ASC');
            $profile = $queryPermission->findOne();
            if ($profile != false) {//Existe el perfil que vincula User/Provider/Action.
                $value=$context->getProvider()->getBaseURL()."index.php?action=".$action->getUrlCode();
            } else {
                $value = "javascript:alert('Usted no posee permisos para ejecutar esta acción: $module_alias.$action_name');return false;";
            }
            return new ActionNode($value, $lineno, $this->getTag());
        } else {
            new Twig_Error_Syntax("La acción $module_alias.$action_name no existe",$lineno);
        }
    }

    public function getTag() {
        return 'Action';
    }
}
?>