<?php
require_once "iplan/twig/tokenParser/ActionTokenParser.php";
require_once "iplan/twig/tokenParser/ShowTokenParser.php";

class IPlanExtension extends Twig_Extension {
    private $application;
    private $twig;

    public function __construct($application) {
        $this->application = $application;
        $loader = new Twig_Loader_String();
        $this->twig = new Twig_Environment($loader);
    }

    public function getName() {
        return 'IPlan';
    }

    public function getGlobals() {
        return parent::getGlobals();
    }

    public function getFilters() {
        //return parent::getFilters();
        /*Examples:
         *         return array(
         *               'rot13' => new Twig_Filter_Method($this, 'rot13Filter'),
         *          );
         */
        return array(
                'parse'   => new Twig_Filter_Method ($this, 'parse_filter', array('needs_environment' => true)),
                'register'=> new Twig_Filter_Method ($this, 'register_filter', array('needs_environment' => true)),
                'first'   => new Twig_Filter_Method($this, 'first_function'),
                'last'   => new Twig_Filter_Method  ($this, 'last_function')
        );
    }

    public function getTokenParsers() {
        return array(new ActionTokenParser($this->application), new ShowTokenParser());
    }

    /**
     * Returns a list of global functions to add to the existing list.
     *
     * @return array An array of global functions
     */
    public function getFunctions()
    {
        return array(
            'link' => new Twig_Function_Method($this, 'link'),
            'AJAH' => new Twig_Function_Method($this, 'AJAH'),
            'first' => new Twig_Function_Method($this, 'first_function'),
            'last' => new Twig_Function_Method($this, 'last_function')
            );
    }

    /**
     * Returns a list of filters to add to the existing list.
     *
     * @return array An array of filters
     */
    public function getTests()
    {
        return array(
            'anArray'        => new Twig_Test_Function('is_array')
        );
    }

    /**
     * Dada una acción verifica que exista algún perfil para el usuario/proveedor
     * actual que la permita.
     * @param Action $action la acción a verificar
     * @return boolean TRUE si la acción está permitida, FALSE en caso contrario.
     */
    private function __isPermitted($action) {
        $orm = $this->application->getORM();
        $context = $this->application->getContext();
        //Chequeo que dicha acción esté en un perfil asociado al usuario para este proveedor
        $queryPermission = $orm->query('Profile')
                            ->filterBy('users.id','=',$context->getUser()->getId())
                            ->filterBy('provider.id','=',$context->getProvider()->getId())
                            ->filterBy('actions.id', '=',$action->getId())
                            ->orderBy('id ASC');
        return $queryPermission->findOne() != FALSE;
    }

    /**
     * Dado un texto de la forma Alias.Action desarma las partes y retorna la
     * acción indicada siempre y cuando el usuario tenga permiso.
     * @param string $text el texto del template
     * @return Array(bool, Action|string) Un arreglo cuya primer componente es el status de la
     *  operación y la segunda es la acción ó un mensaje de error en caso que algo no esté bien.
     */
    private function __getActionFromString($text) {
        $status = false; $result = null;
        if (strpos($text, ".")) { //Si no tiene Alias.Action está mal
            $parts = explode('.', $text);
            if (count($parts)==2) {
                $module_alias = $parts[0];
                $action_name = $parts[1];
                //Busco si la acción existe.
                $context = $this->application->getContext();
                $orm = $this->application->getORM();
                $queryAction = $orm->query('Action')
                                ->filterBy('method', '=', $action_name)
                                ->filterBy('facade.alias','=', $module_alias)
                                ->orderBy('id ASC');
                $action = $queryAction->findOne();
                if ($action != FALSE) {
                    $status = true;
                    $result = $action;
                } else {
                    $result = "La acción $text no existe";
                }
            } else $result = "Error en la sintaxis de $text";
        } else $result = "La acción $text no existe";
        return array($status, $result);
    }

    public function link($action, $extraParams=null) {
        $context = $this->application->getContext();
        if (is_string($action)) {
            list($status, $action2) = $this->__getActionFromString($action);
            if (!$status) return $context->getProvider()->getBaseURL()."index.php?action=showError&mainicon=delete&title=Error de formato&icon=document_delete2&msg=$action2.";
            $action = $action2;
        } elseif (is_a($action, 'Menu')) {
            $menu = $action;
            $action = $menu->getAction();
        }

        if ($this->__isPermitted($action)) {
            $value=$context->getProvider()->getBaseURL()."index.php?action=".$action->getUrlCode()."&$extraParams";
            if (isset($menu))
                $value .= '&params='.$menu->getParams();
            return $value;
        } else {
            return $context->getProvider()->getBaseURL()."index.php?action=showError&mainicon=delete&title=Error de Permisos&icon=user_delete2&msg=Usted no tiene permisos para ejecutar esta acción";
        }
    }

    public function AJAH($action, $params=null, $target=null, $block=null) {
        $context = $this->application->getContext();
        $status = true;
        if (is_string($action))
            list($status, $action) = $this->__getActionFromString($action);
        elseif (is_a($action, 'Menu')) {
            $menu = $action;
            $action = $menu->getAction();
        }

        if ($status) {
            if ($this->__isPermitted($action)) {
                $url=$context->getProvider()->getBaseURL()."request.php";
                $str_params="";
                if (isset($menu)) {
                    $menu_params = preg_split("&", $menu.getParams());
                    if ($menu_params) {
                        foreach ($menu_params as $param) {
                            list($key, $value)=preg_split("=",$param);
                            $str_params="'$key':'$value',";
                        }
                    }
                }
                if (is_null($target)) $target="desktop_center_content";
                if ($block)
                    return "return uws_load('$url', {'action':'".$action->getUrlCode()."', $str_params $params},'$target', '$block');";
                else
                    return "return uws_load('$url', {'action':'".$action->getUrlCode()."',$str_params $params},'$target');";
            } else {
                return "alert('El usuario actual no tiene permisos para ejecutar esta acción');return false;";
            }
        } else {
            return "alert('$action');return false;";
        }
    }

    public function action($action) {
        $context = $this->application->getContext();
        if (is_string($action)) {
            list($status, $action) = $this->__getActionFromString($action);
            if (!$status) return "javascript:alert('No se pudo reconocer la acción');return false;";
        }
        if ($this->__isPermitted($action)) {
            $value=$context->getProvider()->getBaseURL()."index.php?action=".$action->getUrlCode();
            return $value;
        } else {
            return "javascript:alert('El usuario actual no tiene permisos para ejecutar esta acción');return false;";
        }
    }

    public function parse_filter(Twig_Environment $env, $string) {
        $template = $this->twig->loadTemplate($string);
        return $template->render(array());
    }

    public function register_filter(Twig_Environment $env, $name, $value) {
        $this->twig->addGlobal($name, $value);
        return '';
    }

    public function first_function($string, $count) {
        return substr($string, 0, $count);
    }

    public function last_function($string, $count) {
        return substr($string, $count*-1);
    }

//    public function __call($name, $arguments) {
//
//    }
}
?>