<?php
require_once 'iplan/security/AbstractManager.php';
require_once 'iplan/security/ApplicationContext.php';
require_once 'iplan/security/Renderable.php';



/**
* Author: Jorge Alexis Viqueira
* 
*/
class SecurityManager extends AbstractManager {
  /**
   * Retorna una lista de m�todos que pueden ser invocados desde la aplicaci�n.
   * 
   * @return array Un arreglo (clave, valor) donde la clave es un string con el nombre ficticio de la operaci�n y el valor el nombre del m�todo que le corresponde.
   */
  public function __listActions()
  {
    // Bouml preserved body begin 000AFE85
    return array(
        'defaultPage'=>'defaultPage',
        'login'      => 'login',
        'logout'     => 'logout',
        'mainPage'   => 'mainPage',
        'redirect'   => 'redirect',
        'showErrors' => 'showErrors');
    // Bouml preserved body end 000AFE85
  }

  /**
   * Muesta la home page que se ve sin iniciar sesi�n
   * @param iplan\security\Context $context el contexto donde se solicit� la acci�n.
   * @return iplan\security\renderable La p�gina en cuesti�n.
   */
  public function defaultPage(&$context, $ajax = false)
  {
    // Bouml preserved body begin 000AFF05
    $context->set('page_title', 'Bienvenidos clientes de '.$context->getProvider()->getName());
    return new Renderable('welcome.xhtml');
    // Bouml preserved body end 000AFF05
  }

  /**
   * Acci�n que intenta autenticar un usuario en el sistema o, en caso que se llame sin par�metros, devuelve el formulario de login.
   * @param iplan\security\Context $context el contexto donde se solicit� la acci�n
   * @param boolean $ajax un flag que indica si el llamado requiere una respuesta por AJAX/AJAH
   * @return Renderable Si la autenticaci�n es concretada correctamente retorna un Renderable con la p�gina principal de la aplicaci�n, sino remite de nuevo al login (si hubo error con un mensaje, sino vac�o).
   */
  public function login(&$context, $ajax = false)
  {
    // Bouml preserved body begin 000AFF85
    $app = $this->application;
    //Si están los parámetros valido; sino muestro.
    $username = $app->getParam('username', '', 'P');
    $password = $app->getParam('password', '', 'P');
    $context->set('username', $username);
    $paramsDefined = ($username != '') && ($password != '');
    if ($paramsDefined) {
        $orm = $app->getORM();
        $user = $orm->query('User')
                ->filterBy('provider.id', '=', $context->getProvider()->getId())
                ->filterBy('username', '=', $username)->findOne();
        if ($user) {
            if ($user->getPassword()==sha1($password)) {
                $_SESSION['uws_user_id']=$user->getId();
                $context->setUser($user);
                return $this->mainPage($context, $ajax);
                //$context->set('url', $provider->getBaseURL()."index.php?action=mainpage");
                //return $this->redirect();
            }
        }
        $form_errors['title']='Error al intentar ingresar al sitio';
        $form_errors['messages'][0]['description']='Los datos ingresados al formulario no son válidos';
        $context->set('form_errors', $form_errors);
    } else {
        if ($username) {
            $form_errors['title']='Error al intentar ingresar al sitio';
            $form_errors['messages'][0]['description']='Debe ingresar una clave';
            $form_errors['messages'][0]['field']='password';
            $context->set('form_errors', $form_errors);
        }
        if ($password) {
            $form_errors['title']='Error al intentar ingresar al sitio';
            $form_errors['messages'][0]['description']='Debe ingresar un nombre de usuario';
            $form_errors['messages'][0]['field']='username';
            $context->set('form_errors', $form_errors);
        }
    }
    return new Renderable('login.xhtml');
    // Bouml preserved body end 000AFF85
  }

  /**
   * Termina la sesi�n y vuelve a la defaultPage.
   * @param iplan\security\Context $context el contexto donde se solicit� la acci�n.
   * @return iplan\security\Renderable La home page que corresponde cuando no se inici� sesi�n.
   */
  public function logout(&$context, $ajax = false)
  {
    // Bouml preserved body begin 000B0085
    $this->application->reset($context->getProvider()->getId());
    return $this->defaultPage($context, $ajax);
    // Bouml preserved body end 000B0085
  }

  /**
   * Retorna la p�gina principal.
   * @param iplan\security\Context $context el contexto donde se solicit� la acci�n.
   * @return iplan\security\Renderable El objeto que permite mostrar la p�gina principal.
   */
  public function mainPage(&$context, $ajax = false)
  {
    // Bouml preserved body begin 000B0005
    return new Renderable('main.xhtml');
    // Bouml preserved body end 000B0005
  }

  /**
   * Redirige a una p�gina pasada por GET como "url".
   * @param iplan\security\Context $context el contexto donde se solicit� la acci�n.
   * @return iplan\security\Renderable El objeto que permite mostrar la p�gina principal.
   */
  public function redirect(&$context, $ajax)
  {
    // Bouml preserved body begin 000BB605
//    header('HTTP/1.1 303 See Other');
    header('Location: '.$context->getParam('params', $context->getParam(0, null)));
//    flush();
//    header("Connection: close");
    exit;
    return false;
    // Bouml preserved body end 000BB605
  }

  /**
   * Lista los usuarios del sistema.
   * @param ApplicationContext $context el contexto de la aplicaci�n
   * @param boolean $ajax indica si el llamado es para p�gina completa o para ser devuelto en background
   * 
   * @return Renderable el template a devolver
   */
  public function listUsers(&$context, $ajax)
  {
    // Bouml preserved body begin 000C6C05

    $options['columns'] = array(
        array(
            'title'=>'Identificador',
            'maps'=>'id',
            'hide'=>true
        ),
        array(
            'title'=>'Nombre y Apellido',
            'maps'=>array('name', 'surname'),
            'template'=>'{{surname}}, {{name}}',
            'sortable'=>true
            ),
        array(
            'title'=>'Usuario',
            'maps'=>'username',
            'sortable'=>true
        ),
        array(
            'title'=>'Perfiles',
            'maps'=>'profiles.name',
            'action'=>'Security.viewProfile',
            'mode'  =>'inline-popup',
            'params'=>array('id'=>'profiles.id')
        ),
        array(
            'title'=>'Acciones',
            'actions'=>array(
                'Modificar Usuario'=>array(
                    'action' =>'Security.modifyUser',
                    'mode'   =>'inline-popup',
                    'params' =>array('id'),
                    'refresh'=>'row',
                    'icon'   =>'user_red_edit'
                ),
                'Borrar Usuario'=>array(
                    'action' =>'Security.deleteUser',
                    'mode'   =>'inline',
                    'params' =>array('id'),
                    'refresh'=>'list',
                    'icon'   =>'user_red_delete'
                )
            )
        )
    );
    $options['actions']=array(
        'Agregar Usuario'=>array(
            'action' =>'Security.saveUser',
            'mode'   =>'inline-popup',
            'refresh'=>'list',
            'size'   => 32,
            'icon'   =>'user_red_add'
        ),
        'Exportar a PDF'=>array(
            'action' =>'General.List2PDF',
            'params' =>array('url' => 'listUsers'),
            'mode'   =>'inline',
            'refresh'=>'none'
        )
    );



    $filters = array(
        'FirstRow'=> array (
            'Nombre'  => array(
                'position'   => array(1,1),
                'control'    => array(
                    'type'   => 'textEdit',
                    'name'   => 'fltName',
                    'size'   => 15
                )
            ),
            'Perfil'  => array(
                'position'   => array(1,2),
                'control'    => array(
                    'type'   => 'comboBox',
                    'name'   => 'fltPerfil',
                    'size'   => 10,
                    'length' => 6
                )
            )
         ),
        'SecondRow' => array(
            'Usuario' => array(
                'position'   => array(2,1),
                'control'    => array(
                    'type'   => 'comboBox',
                    'name'   => 'fltPerfil',
                    'size'   => 12
                )
            ),
            'Estado'  => array(
                'position'   => array(2,2),
                'control'    => array(
                    'type'   => 'comboBox',
                    'name'   => 'fltPerfil',
                    'size'   => 10,
                    'length' => 6
                )
            )
        )
    );


    //Accesos rápidos
    $app = $this->application;
    $orm = $app->getORM();

    //Si el provider no tiene owner traigo los datos de todos
    if ($isMaster=is_null($context->getProvider()->getOwner())) {

    } else {//Sino recupero todos los ids dependientes del provider actual
        //TODO: hacer un while "mientras haya dependencias" y que sea recursivo!
        //por ahora lo dejo solo con el id del provider actual
        $providers = array($context->getProvider()->getId());
    }

    //Busco usuarios
    $query = $orm->query('User');
    //Si es master traigo la info de todo el mundo, sino tengo que filtrar por provider
    if (!$isMaster)
           $query->filterBy('provider.id','IN', $providers);

    //Establezco que campos voy a traer
    $query->attributes('id', 'name', 'surname', 'username');

    //Si hay criterios de ordenamiento
    $sorts = $app->getParam('sorts[]', false, 'PG');
    if ($sorts) {
        foreach($sorts as $sort) {
            list($column, $order)=explode(' ', $sort);
            $query->orderBy("$column ".(($order=='ASC')?'DESC':'ASC'));
        }
    } else {
        //Sort por default
        $query->orderBy('name ASC');
    }

    $mainResult = $query->find();

    for($i=0; $i<count($mainResult);$i++)
        $ids[]=$mainResult[$i]['id'];

    if (isset($ids)) {
        $query2 = $orm->query('Profile');
        $query2->filterBy('users.id','IN', $ids)
               ->attributes('users.id', 'id', 'name' )
               ->orderBy('users.id');
        $secondaryResult = $query2->find();
    }

    $this->merge($mainResult, array('id'=>'users.id'), $secondaryResult, array('name'=>'profiles.name', 'id'=>'profiles.id'));
    $context->set('list_options', $options);
    $context->set('list_items', $mainResult);
    return new Renderable("list.xhtml");
    // Bouml preserved body end 000C6C05
  }

  /**
   * Agrega un usuario al sistema, bajo el dominio del provider o presenta un formulario para dar de alta un usuario nuevo.
   * 
   * @param ApplicationContext $context el contexto de la aplicaci�n
   * @param boolean $ajax indica si el llamado es para p�gina completa o para ser devuelto en background
   */
  public function saveUser(&$context, $ajax)
  {
    // Bouml preserved body begin 000C6C85
    $app = $this->application;
    $orm = $app->getORM();
/*    $user_id = $app->getParam('id', null, 'P');*/
    
	$a = $context->getUser()->getName();
	$b = $context->getUser()->getSurname();
	$c = $context->getUser()->getUsername();
	$d = $context->getUser()->getPassword();
	$e = $context->getUser()->getProvider();
	$f = $context->getUser()->getProfiles();
	
	$u =	$context->getUser();
	
	
	/*krumo($a);
	krumo($b);
	krumo($c);
	krumo($d);
	krumo($e);
	krumo($f);*/
	
	function Form ($title, $class, $components) {
		return  array (
					'Title' => 'Titulo del Form xd',
					'Class' => 'User',
					'Components' => $components);
	}

	function Components ($component) {
		$arr = array();
		foreach(func_get_args() as $_comp) {
			$arr[]=$_comp;
		}
		return $arr;
	}
	
	
	
	/* Componentes */
	/*$compNombre = new Text("Nombre");
	$compNombre->setLabel("xd")
			   ->setMaps('name');
//			   ->setType("text");

	
	// Gran Layout contenedor de lays 
	$oGranLayout = new GridLayout(1, 2);

	// Layout 1 magia xd 
	$oLayout1 = new GridLayout(5, 2);
	$oLayout1->addComponent($compNombre, 1, 2)
			 ->addComponent($compApellido, 1, 1)
			 ->addComponent($compEquisdeis, 1, 1);

	// Layout 2 magia xd 
	$oLayout2 = new GridLayout(1, 1);
	$oLayout2->addComponent($compNombre, 1, 2);
	// Compone 
	$oGranLayout->addComponent($oLayout1);
	$oGranLayout->addComponent($oLayout2);
	
	
	$options = Form('Titulo del Form xd', 'User', $oGranLayout);
	*/

	$compNombre = new TextComponent();
	$compNombre->setLabel("Nombre")
			   ->setMaps('name')
			   ->setSize("20")
			   ->setMaxlength("10")
			   ->setStyle('')
			   ->setId('id_name')
			   ->setValidate('alpha')
			   ->setValue('Juan');

	$compApellido = new TextComponent();
	$compApellido->setLabel("Apellido")
				 ->setMaps('surname')
				 ->setSize("20")
				 ->setMaxlength("10")
				 ->setId('id_surname')
				 ->setValidate('alpha')
				 ->setValue('Perez');

	$compUsuario = new TextComponent();
	$compUsuario->setLabel("Usuario")
				->setMaps('username')
				->setSize("20")
				->setMaxlength("10")
				->setId('id_username')
				->setValidate(array('alpha', 'aphanumeric'))
				->setValue('jperezxd');

	
	$compPassword = new PasswordComponent();
	$compPassword->setLabel("Password")
				 ->setMaps('password')
				 ->setSize("20")
				 ->setMaxlength("10")
				 ->setId('id_username')
				 ->setValidate(array('alpha', 'aphanumeric'));

	$compConfPassword = new PasswordComponent();
	$compConfPassword->setLabel("Conf. password")
					 ->setName('conf_password')
					 ->setSize("20")
					 ->setMaxlength("10")
					 ->setId('id_conf_password')
					 ->setValidate(array('alpha', 'aphanumeric'));
	
	
	$compProvider = new SelectComponent();
	$compProvider->setLabel("Provider")
				 ->setMaps('provider')
				 ->setId('id_provider')
				 ->setValues(array('1' => 'Iplan Networks.-', '2' => 'XD Networks.-', '3' => 'XD 2 Networks.-', '4' => 'XD 3 Networks.-', '5' => 'XD 4 Networks.-'))
				 ->setSelected(array("2"));
	
	$compPerfiles = new MultiselectComponent();
	$compPerfiles->setLabel("Perfiles")
				 ->setMaps('profile')
				 ->setRows('5')
				 ->setValues(array('1' => 'Perfil xd 1', '2' => 'Perfil xd 2', '3' => 'Perfil xd 3', '4' => 'Perfil xd 4', '5' => 'Perfil xd 5'))
				 ->setSelected(array("2", "3"));
	
	$compSexo = new RadioComponent();
	$compSexo->setLabel("Sexo")
			 ->setMaps('sex')
			 ->setValues(array('1' => 'Hombre', '2' => 'Mujer'))
			 ->setSelected(array("2"));
	
	$compPreferencias = new CheckboxComponent();
	$compPreferencias->setLabel("Preferencias")
					 ->setMaps('arriba')
					 ->setValues(array('1' => 'Hombres', '2' => 'Mujeres', '3' => 'Otros'))
					 ->setSelected(array("1", "3"));
	
	$compBotonete = new ButtonComponent();
	$compBotonete->setLabel("Preferencias")
				 ->setId('id_botonete')
				 ->setName('botonete')
				 ->setValue("Soy un botonete");
	
	$compFilenete = new FileComponent();
	$compFilenete->setLabel("Preferencias")
				 ->setId('id_filenete')
				 ->setName('filenete')
				 ->setTypes('*.jpg')
				 ->setValue("Soy un filenete");
	
	
	//$options = Form('Titulo del Form xd', 'User');
	
	$oLayout1 = new GridLayout(5, 2);
	$oLayout1->addComponent($compNombre, 1, 1)
			 ->addComponent($compApellido, 1, 2)
			 ->addComponent($compUsuario, 2, 1)
			 ->addComponent($compPassword, 3, 1)
			 ->addComponent($compConfPassword, 3, 2)
			 ->addComponent($compProvider, 4, 1, 2, 1)
			 ->addComponent($compPerfiles, 5, 1, 2, 1)
			 ->addComponent($compSexo, 6, 1, 2, 1)
			 ->addComponent($compPreferencias, 7, 1, 2, 1)
			 ->addComponent($compBotonete, 8, 1, 2, 1)
			 ->addComponent($compFilenete, 9, 1, 2, 1);
	
	$oForm1 = new Form();
	$oForm1->setClass("User")
		   ->setTitle("Titulo del form xd")
		   ->addComponent($oLayout1);
	
	$options = $oForm1->toArray();
	
	/*
	$options = array(
		'Title' => 'Titulo del Form xd',
		'Class' => 'User',
		'Components' => array(
			 array(
				'label' => 'Nombre',
				'maps' => 'name',
				'type' => 'text',
				'size' => '20',
				'maxlength' => '10',
				'style' => '',
				'id' => 'id_name',
				'validate' => 'alpha',
				'value' => 'Juan'
			),
			array(
				'label' => 'Apellido',
				'maps' => 'surname',
				'type' => 'text',
				'size' => '20',
				'maxlength' => '10',
				'style' => '',
				'id' => 'id_surname',
				'validate' => 'alpha',
				'value' => 'Perez'
			),
			array(
				'label' => 'Usuario',
				'maps' => 'username',
				'type' => 'text',
				'size' => '20',
				'maxlength' => '10',
				'style' => '',
				'id' => 'id_username',
				'validate' => array('alpha', 'aphanumeric'),
				'value' => 'jperezxd'
			),
			array(
				'label' => 'Password',
				'maps' => 'password',
				'type' => 'password',
				'size' => '20',
				'maxlength' => '20',
				'style' => '',
				'validate' => array('aphanumeric'),
				'value' => ''
			),
			array(
				'label' => 'Provider',
				'maps' => 'provider',
				'type' => 'select',
				'style' => '',
				'validate' => '',
				'values' => array('1' => 'Iplan Networks.-', '2' => 'XD Networks.-', '3' => 'XD 2 Networks.-', '4' => 'XD 3 Networks.-', '5' => 'XD 4 Networks.-'),
				'selected' => array("2")
			),
			array(
				'label' => 'Perfiles',
				'maps' => 'profile',
				'type' => 'multiple',
				'rows' => '5',
				'style' => '',
				'validate' => '',
				'values' => array('1' => 'Perfil xd 1', '2' => 'Perfil xd 2', '3' => 'Perfil xd 3', '4' => 'Perfil xd 4', '5' => 'Perfil xd 5'),
				'selected' => array("2", "3")
			),
			array(
				'label' => 'Sexo',
				'maps' => 'sex',
				'type' => 'radio',
				'style' => '',
				'validate' => '',
				'values' => array('1' => 'Hombre', '2' => 'Mujer'),
				'selected' => "2"
			),
			array(
				'label' => 'Preferencias',
				'maps' => 'arriba',
				'type' => 'checkbox',
				'style' => '',
				'validate' => '',
				'values' => array('1' => 'Hombres', '2' => 'Mujeres', '3' => 'Otros'),
				'selected' => array('1', '3')
			),
			array(
				'id' => 'id_botonete',
				'name' => 'botonete',
				'type' => 'button',
				'style' => '',
				'value' => "Soy un botonete"
			),
			array(
				'id' => 'id_filenete',
				'name' => 'filenete',
				'type' => 'file',
				'style' => '',
				'value' => "Soy un filenete"
			)
		)
	);
	*/
	
	$context->set('options', $options);
	
  
	

    return new Renderable('fede.xhtml');
    

    // Bouml preserved body end 000C6C85
  }

  /**
   * Borra el usuario identificado por "user_id".
   */
  public function deleteUser(&$context, $ajax)
  {
    // Bouml preserved body begin 000C6D05
    return new Renderable("sorry.xhtml");
    // Bouml preserved body end 000C6D05
  }

  /**
   * Cambia la contrase�a del usuario actual
   */
  public function changePassword(&$context, $ajax)
  {
    // Bouml preserved body begin 000C6D85
    return new Renderable("sorry.xhtml");
    // Bouml preserved body end 000C6D85
  }

  /**
   * Lista los perfiles relacionados al provider
   */
  public function listProfiles(&$context)
  {
    // Bouml preserved body begin 000C6E05
    return new Renderable("sorry.xhtml");
    // Bouml preserved body end 000C6E05
  }

  /**
   * Guarda o modifica el perfil indicado
   */
  public function saveProfile(&$context, $ajax)
  {
    // Bouml preserved body begin 000C6E85
    return new Renderable("sorry.xhtml");
    // Bouml preserved body end 000C6E85
  }

  /**
   * Borra el perfil especificado
   */
  public function deleteProfile(&$context, $ajax)
  {
    // Bouml preserved body begin 000C6F05
    return new Renderable("sorry.xhtml");
    // Bouml preserved body end 000C6F05
  }

  /**
   * Lista las acciones relacionadas al provider
   */
  public function listActions(&$context, $ajax)
  {
    // Bouml preserved body begin 000C6F85
    return new Renderable("sorry.xhtml");
    // Bouml preserved body end 000C6F85
  }

  /**
   * Crea o guarda la acci�n indicada
   */
  public function saveAction(&$context, $ajax)
  {
    // Bouml preserved body begin 000C7005
    return new Renderable("sorry.xhtml");
    // Bouml preserved body end 000C7005
  }

  /**
   * Borra la acci�n indicada
   */
  public function deleteAction(&$context, $ajax)
  {
    // Bouml preserved body begin 000C7085
    return new Renderable("sorry.xhtml");
    // Bouml preserved body end 000C7085
  }

  /**
   * Muestra un mensaje de error personalizado
   */
  public function showError(&$context, $ajax)
  {
    // Bouml preserved body begin 000D1105
    $app = $this->application;

    $title = $app->getParam('title', 'Error Desconocido', 'PG');
    $msg = $app->getParam('msg', 'No hay Descripción', 'PG');
    $mainicon = $app->getParam('mainicon', 'blank', 'PG');
    $icon = $app->getParam('icon', 'blank', 'PG');

    $errors['title']   = $title;
    $errors['subject'] = '';
    $errors['icon']= $mainicon;
    $errors['messages'][0]['icon'] = $icon;
    $errors['messages'][0]['description'] = $msg;

    $context->set('errors', $errors);
    return new Renderable('lib/show_errors.xhtml');
//errors[title]
//errors[subject]
//errors[messages][0][icon]
//errors[messages][0][description]
//errors[messages][0][field]
    // Bouml preserved body end 000D1105
  }

}
?>