<?php
require_once 'iplan/security/Menu.php';
require_once 'iplan/security/User.php';
require_once 'iplan/security/Profile.php';
require_once 'iplan/security/Facade.php';
require_once 'iplan/orm/ORM.php';
require_once 'iplan/orm/ORMObject.php';

require_once "iplan/orm/ORMDefinition.php";


/**
* Author: Jorge Alexis Viqueira
* 
*/
/**
 * El Provider es la entidad que representa a los proveedores de servicio. Un provider tpicamente es la empresa que presta servicios a un conjunto de usuarios, aunque tambin puede ser proveedor de otro provider.
 * 
 * @method string getName()
 * @method Provider setName()
 * @method string getDescription()
 * @method Provider setDescription()
 * @method array getUsers()
 * @method Provider addUser()
 * @method Provider delUser()
 * @method array getProfiles()
 * @method Provider addProfile()
 * @method Provider delProfile()
 * @method Provider getOwner()
 * @method Provider setOwner()
 * @method array getFacades()
 * @method Provider addFacade()
 * @method Provider delFacade()
 */
class Provider extends ORMObject {
  /**
   * @var string el nombre del proveedor del servicio
   */
  protected $name;

  /**
   * @var string un nombre de una sola palabra que sea utilizado para identificar al proveedor
   */
  protected $alias;

  /**
   * @var string la URL base del sistema de gestin del proveedor.
   */
  protected $baseURL;

  /**
   * @var array la lista de menues que pertenecen al provider
   */
  protected $menus;

  /**
   * @var array una coleccin de los usuarios que pertenecen al proveedor de servicio en cuestin
   */
  protected $users;

  /**
   * @var array la lista de perfiles asociados al proveedor
   */
  protected $profiles;

  /**
   * @var array la lista de Facades habilitados al provider
   */
  protected $facades;

  protected $anonymous;

  /**
   * Retorna un objeto de definicin predeterminado al cual hay que agregarle los mapeos pertinentes.
   * @param iplan\orm\ORM $orm el manejador de objetos para el cual se registra la definicin
   * @return ORMDefinition la definicin default
   */
  public static function define(&$orm)
  {
    // Bouml preserved body begin 000B3505
    return parent::define($orm)
            ->setClass('Provider')
            ->setTable('UWS_PROVIDER')
            ->addField('id', 'PROVIDER_ID', ORMDefinition::INTEGER)
            ->setKey('id')
            ->addField('name', 'PROVIDER_NAME', ORMDefinition::STRING, 25, 0, FALSE)
            ->addField('alias', 'PROVIDER_ALIAS', ORMDefinition::STRING, 25, 0, FALSE)
            ->addField('baseURL', 'PROVIDER_URL', ORMDefinition::STRING, 255, 0, FALSE)
            ->addInstance('anonymous', 'ANONYMOUS_ID', 'User', true, "", null, ORMDefinition::LAZY_LOAD)
            ->addInstance('owner', 'PROVIDER_OWNER', 'Provider', true, "", null, ORMDefinition::LAZY_LOAD)
            ->addRelation1xN('profiles', 'PROVIDER_ID', 'Profile')
            ->addRelation1xN('menus', 'PROVIDER_ID', 'Menu')
            ->addRelation1xN('users', 'PROVIDER_ID', 'User')
            ->addRelationNxM('facades', 'UWS_PROVIDER_FACADE', 'PROVIDER_ID', 'Facade', 'FACADE_ID');
//            ->addRelationNxM('users', 'UWS_PROVIDER_USER', 'PROVIDER_ID', 'User', 'USER_ID')
    // Bouml preserved body end 000B3505
  }

  /**
   * Quin es el propietario directo del Provider. El nico que debera ser null en este atributo es iPlan.
   */
  protected $owner;

}
?>