<?php
require_once 'iplan/security/User.php';
require_once 'iplan/security/Action.php';
require_once 'iplan/security/Provider.php';
require_once 'iplan/orm/ORMDefinition.php';
require_once 'iplan/orm/ORM.php';
require_once 'iplan/orm/ORMObject.php';

require_once "iplan/orm/ORMDefinition.php";


/**
* Author: Jorge Alexis Viqueira
* 
*/
/**
 * Un perfil es una entidad que nuclea el un conjunto de acciones para realizar una tarea o un conjunto de tareas relacionadas.
 * Los perfiles se relacionan del mismo modo con los usuarios habilitndo a stos ltimos a realizar dichas tareas.
 * Los son creados por el Provider y dependen de l.
 * 
 * @method string getName()
 * @method Profile setName()
 * @method string getDescription()
 * @method Profile setDescription()
 * @method Provider getProvider()
 * @method Profile setProvider()
 * @method array getActions()
 * @method array getUsers()
 * @method Profile addAction()
 * @method Profile delAction()
 * @method Profile addUser()
 * @method Profile delUser()
 */
class Profile extends ORMObject {
  protected $name;

  protected $description;

  /**
   * @var array $users la lista de usuarios del perfil
   */
  protected $users;

  /**
   * @var array $actions la lista de acciones relacionadas al perfil
   */
  protected $actions;

  /**
   * @var \iplan\security\Provider el proveedor que configur el grupo
   */
  protected $provider;

  /**
   * Retorna un objeto de definicin predeterminado al cual hay que agregarle los mapeos pertinentes.
   * @param iplan\orm\ORM $orm el manejador de objetos para el cual se registra la definicin
   * @return ORMDefinition la definicin default
   */
  public static function define(&$orm)
  {
    // Bouml preserved body begin 000A6005
    return parent::define($orm)
                ->setClass('Profile')
                ->setTable('UWS_PROFILE')
                ->addField('id', 'PROFILE_ID', ORMDefinition::INTEGER, 10)
                ->setKey('id')
                ->addField('name', 'PROFILE_NAME', ORMDefinition::STRING, 50, 0, FALSE)
                ->addField('description', 'PROFILE_DESCRIPTION', ORMDefinition::STRING, 2048)
                ->addInstance('provider', 'PROVIDER_ID', 'Provider', false)
                ->addRelationNxM('users', 'UWS_USER_PROFILE', 'PROFILE_ID', 'User', 'USER_ID')
                ->addRelationNxM('actions', 'UWS_PROFILE_ACTION', 'PROFILE_ID', 'Action', 'ACTION_ID');
    // Bouml preserved body end 000A6005
  }

}
?>