<?php
require_once 'iplan/security/Renderable.php';
require_once 'iplan/security/Facade.php';
require_once 'iplan/security/Profile.php';
require_once 'iplan/security/ApplicationContext.php';
require_once 'iplan/orm/ORMDefinition.php';
require_once 'iplan/orm/ORM.php';
require_once 'iplan/orm/ORMObject.php';

require_once "iplan/orm/ORMDefinition.php";


/**
* Author: Jorge Alexis Viqueira
* 
*/
/**
 * Una accin del sistema es una funcin particular que puede ser realizada en el mismo. Las acciones pertenecen a un Facade que es una especie de mdulo que las aglutina y se relacionan con los usuarios a travs de los perfiles.
 * 
 * @method string getDescription()
 * @method Action setDescription()
 * @method string getName()
 * @method Action setName()
 * @method string getMethod()
 * @method Action setMethod()
 * @method string getUrlCode()
 * @method Action setUrlCode()
 * @method string getHint()
 * @method Action setHint()
 * @method string getIcon()
 * @method Action setIcon()
 * @method Facade getFacade()
 * @method Action setFacade()
 * @method array getProfiles()
 * @method Action addProfile()
 * @method Action delProfile()
 */
class Action extends ORMObject {
  protected $description;

  protected $name;

  /**
   * @var string $method el mtodo a llamar
   */
  protected $method;

  /**
   * @var string un cdigo textual del comando
   */
  protected $urlCode;

  /**
   * @var string un texto para mostrar en los componentes que realicen o ejecuten esta accin
   */
  protected $hint;

  /**
   * @var string el nombre del estilo que marca el cono de la accin
   */
  protected $icon;

  /**
   * @var Facade $facade Una representacin de la clase a ser invocada y su definicin
   */
  protected $facade;

  /**
   * @var array $profiles la lista de perfiles que utilizan la accin
   */
  protected $profiles;

  /**
   * Invoca a las funciones que realizan la accin y retorna un Renderable con el resultado.
   * No me dej ponerle "do()" porque "do" est reservado :S
   * @param iplan\security\Context $context el contexto sobre el que se ejecuta la accin.
   * @param boolean $ajax indica si se invoc va ajax.
   * @return Renderable el objeto que renderiza la salida.
   */
  public function execute(&$context, $ajax)
  {
    // Bouml preserved body begin 000A0B05
    $manager = $context->getManager($this->facade->getAlias());
    $method = $this->method;
    return $manager->$method($context, $ajax);
    // Bouml preserved body end 000A0B05
  }

  /**
   * Retorna un objeto de definicin predeterminado al cual hay que agregarle los mapeos pertinentes.
   * @param iplan\orm\ORM $orm el manejador de objetos para el cual se registra la definicin
   * @return ORMDefinition la definicin default
   */
  public static function define(&$orm)
  {
    // Bouml preserved body begin 000A6085
    return parent::define($orm)
            ->setClass('Action')
            ->setTable('UWS_ACTION')
            ->addField('id', 'ACTION_ID', ORMDefinition::INTEGER, 10)
            ->setKey('id')
            ->addField('name', 'ACTION_NAME', ORMDefinition::STRING, 25, 0, FALSE)
            ->addField('description', 'ACTION_DESCRIPTION', ORMDefinition::STRING, 2048)
            ->addField('method', 'ACTION_METHOD', ORMDefinition::STRING, 25)
            ->addField('urlCode', 'ACTION_URL_CODE', ORMDefinition::STRING, 8, 0, FALSE)
            ->addField('hint', 'ACTION_HINT', ORMDefinition::STRING, 40)
            ->addInstance('facade', 'FACADE_ID', 'Facade')
            ->addRelationNxM('profiles', 'UWS_PROFILE_ACTION', 'ACTION_ID', 'Profile');
    // Bouml preserved body end 000A6085
  }

}
?>