<?php
require_once 'iplan/security/Application.php';
require_once 'iplan/security/Renderable.php';



/**
* Author: Jorge Alexis Viqueira
* 
*/
abstract class AbstractManager {
  /**
   * @var Application la instancia de la aplicacin que maneja la clase
   */
  protected $application;

  /**
   * Crea una instancia del Manager y configura la aplicacin
   * 
   * @param iplan\security\Application la aplicacin que es la propietaria del manager
   * @return iplan\security\AbstractManager Una instancia del Manager en cuestin
   */
  public function __construct(&$application)
  {
    // Bouml preserved body begin 000AE505
    $this->application = $application;
    return $this;
    // Bouml preserved body end 000AE505
  }

  /**
   * Retorna una lista de mtodos que pueden ser invocados desde la aplicacin.
   * 
   * @return array Un arreglo (clave, valor) donde la clave es un string con el nombre ficticio de la operacin y el valor el nombre del mtodo que le corresponde.
   */
  public abstract function __listActions()
  ;
  /**
   * Agrupa una lista de elementos segn los valores de las claves indicadas.
   * 
   * @param array $by una lista de las claves por las cuales agrupar los datos.
   * @param array $items   la lista de items que deben ser agrupados.
   * 
   * @return array otra lista donde los valores de los campos agrupados no se repiten.
   */
  protected function group($by, &$items)
  {
    // Bouml preserved body begin 000CF685
    $tmpList = array();
    $list = array();

    $allkeys   = array_keys(current($items));
    $otherKeys = array_diff($allkeys, $by);

    //Agrupo
    foreach($items as $item) {
        $ref = &$tmpList;
        foreach($by as $key) {
            if (!is_null($item[$key]))
                $ref = &$ref[$item[$key]];
            else
                $ref = &$ref['NULL'];
        }
        foreach($otherKeys as $key) {
            $ref[$key][]=$item[$key];
        }
    }

    //Reconvierto
    $list = $this->combine_recursive($tmpList, $by, array());
    return $list;
    // Bouml preserved body end 000CF685
  }

  /**
   * Usado internamente por group(); esta funcin reconstruye los conjuntos agrupados en su representacin final.
   */
  protected function combine_recursive(&$collection, $groups, $head)
  {
    // Bouml preserved body begin 000CF785
    $list = array();

    if (count($groups)!=0) {
        $col = array_shift($groups);
        foreach($collection as $key=>$data) {
            if ($key == 'NULL')
                $head[$col]=null;
            else
                $head[$col]=$key;
            if (count($groups)==1)
                $list[]=$this->combine_recursive($collection[$key], $groups, $head);
            else
                $list = array_merge ($list, $this->combine_recursive($collection[$key], $groups, $head));
        }
        return $list;
    } else {
        if (!is_null($collection))
            return array_merge($head, $collection);
        else return $head;
    }
    // Bouml preserved body end 000CF785
  }

  /**
   * Une al primer arreglo los elementos del segundo siempre que las columnas especificadas de ambos coincidan.
   * 
   * @param array $first la lista sobre la que se adicionarn los elementos
   * @param array $by un arreglo donde cada clave y valor corresponden a las columnas de filtro del arreglo principal y el secundario respectivamente.
   * @param array $second la lista que se va a adicionar a la primera
   * @param array $rename otro arreglo donde las claves son los nombres de las columnas del $secondaryList que se desean renombrar al pasar a $mainList. (La clave es la key original y el valor es la key "nueva")
   * 
   * @return boolean true si la unin se hizo con xito en todos los elementos o false si hubo elementos que no combinaban.
   */
  protected function merge(&$first, $by, &$second, $rename = array())
  {
    // Bouml preserved body begin 000CF705
    $allkeys   = array_keys(current($second));
    $otherKeys = array_diff($allkeys, $by);
    reset($first);
    reset($second);
    for($i=0;$i < count($second); $i++) {
        for($j=0;$j < count($first); $j++) {
            $ok = true;
            foreach($by as $mainKey=>$secondaryKey)
                $ok = $ok && ($first[$j][$mainKey]==$second[$i][$secondaryKey]);
            if ($ok) {
                foreach($otherKeys as $key) {
                    if (isset($rename[$key])) {
                        $first[$j][$rename[$key]]=$second[$i][$key];
                    } else {
                        $first[$j][$key]=$second[$i][$key];
                    }
                }
                break;
            }
        }
        if ($j == count($first)+1) return false;
    }
    return true;
    // Bouml preserved body end 000CF705
  }

}
?>