<?php



/**
* Author: Jorge Alexis Viqueira
* 
*/
/**
 * La factoria de validaciones. Esta clase es la responsable de retornar las instancias correspondientes a cada validaci�n.
 */
abstract class Validation {
  /**
   * @var array una lista de las validaciones instanciadas, de tal forma que hacer una especie de Singleton. Nota: Singleton no se puede hacer porque no todas se crean una vez, solo la mayor�a.
   */
  private static $registeredValidations = array();

  /**
   * Devuelve una instancia de Validation que a trav�s de su m�todo validate() determina si un valor cumple o no la condici�n.
   * 
   * @param string $validation el nombre de la validaci�n
   * @param array $params los par�metros que se consideren necesarios para la validaci�n
   * 
   * @return Validation una instancia de la validaci�n requerida
   */
  public static function getValidation($validation, $params = null)
  {
    // Bouml preserved body begin 000E1805
        $class = strtoupper($validation[0]).substr($validation,1);
        switch ($validation) {
            //Estas son estándar y predefinidas
            case 'required':
            case 'alpha':
            case 'numeric':
            case 'alphanumeric':
            case 'mail':
            case 'text':
                if (!isset(self::$registeredValidations[$validation])) {
                    self::$registeredValidations[$validation]=new $class();
                }
                return self::$registeredValidations[$validation];
                break;
            //Estas son particulares de cada caso
            case 'regexp':
            case 'min':
            case 'max':
            case 'size':
                return new $class($params);
                break;
            default:
                throw new Exception("La validación [$validation] es desconocida");
        }
    // Bouml preserved body end 000E1805
  }

  /**
   * Verifica si un valor o un conjunto de valores cumplen la condici�n.
   * 
   * @param string|array $value el valor a verificar
   * @return boolean TRUE si cumple, FALSE sino.
   */
  public abstract function validate($value)
  ;
}
?>