<?php



/**
* Author: Jorge Alexis Viqueira
* 
*/
abstract class PrivateAccesor {
  /**
   * Retorna una referencia al atributo indicado.
   * 
   * @param Object $object un objeto cualquiera de los descendientes de PrivateAccesor
   * @param string $name el nombre del atributo
   * @return mixed el valor del atributo solicitado
   */
  protected function &getAttribute($object, $name)
  {
    // Bouml preserved body begin 00068205
    return $object->$name;
    // Bouml preserved body end 00068205
  }

  /**
   * Retorna una referencia al atributo indicado.
   * 
   * @param Object $object un objeto cualquiera de los descendientes de PrivateAccesor
   * @param string $name el nombre del atributo
   * @return mixed el valor del atributo solicitado
   */
  protected static function &stGetAttribute($object, $name)
  {
    // Bouml preserved body begin 000DCA05
    return $object->$name;
    // Bouml preserved body end 000DCA05
  }

  /**
   * Invoca un m�todo p�blico o protegido del objeto que se pasa por par�metro.
   * 
   * @param Object $object un objeto de la jerarqu�a de PrivateAccesor
   * @param string $method el nombre del m�todo a invocar
   * @param array $params un arreglo con los par�metros necesarios para invocar la funci�n en el orden y n�mero correcto
   * @return mixed retorna lo que devuelva la funci�n invocada
   */
  protected function invokeMethod(&$object, $method, $params)
  {
    // Bouml preserved body begin 00068285
    return call_user_func_array(array($object, $method), $params);
    // Bouml preserved body end 00068285
  }

  /**
   * @static
   * Versi�n est�tica de invokeMethod(); invoca un m�todo p�blico o protegido del objeto que se pasa por par�metro.
   * @see PrivateAccessor::invokeMethod()
   * @param Object $object un objeto de la jerarqu�a de PrivateAccesor
   * @param string $method el nombre del m�todo a invocar
   * @param array $params un arreglo con los par�metros necesarios para invocar la funci�n en el orden y n�mero correcto
   * @return mixed retorna lo que devuelva la funci�n invocada
   */
  protected static function stInvokeMethod(&$object, $method, $params)
  {
    // Bouml preserved body begin 0007DF05
    return call_user_func_array(array($object, $method), $params);
    // Bouml preserved body end 0007DF05
  }

  /**
   * Actualiza un atributo protegido o p�blico de un objeto.
   * 
   * @param Object $object un objeto cualquiera de los descendientes de PrivateAccesor
   * @param string $name el nombre del atributo
   * @param mixed $value el nuevo valor de la propiedad
   * @return void
   */
  protected function setAttribute($object, $name, $value)
  {
    // Bouml preserved body begin 00072505
    $object->$name = $value;
    // Bouml preserved body end 00072505
  }

  /**
   * Actualiza un atributo protegido o p�blico de un objeto.
   * 
   * @param Object $object un objeto cualquiera de los descendientes de PrivateAccesor
   * @param string $name el nombre del atributo
   * @param mixed $value el nuevo valor de la propiedad
   * @return void
   */
  protected static function stSetAttribute($object, $name, $value)
  {
    // Bouml preserved body begin 000DCA85
    $object->$name = $value;
    // Bouml preserved body end 000DCA85
  }

  /**
   * Invoca un m�todo p�blico o protegido de la clase que se pasa por par�metro.
   * 
   * @param string $class la clase de la jerarqu�a de PrivateAccesor
   * @param string $method el nombre del m�todo a invocar
   * @param array $params un arreglo con los par�metros necesarios para invocar la funci�n en el orden y n�mero correcto
   * @return mixed retorna lo que devuelva la funci�n invocada
   */
  protected function invokeStaticMethod($class, $method, &$params)
  {
    // Bouml preserved body begin 0007C485
    return call_user_func_array(array($class,$method), $params);
//    return forward_static_call_array(array($class, $method), $params); CAMBIADO PARA ADAPTARLO AL PHP DEL SERVER
    // Bouml preserved body end 0007C485
  }

  /**
   * Invoca un m�todo p�blico o protegido de la clase que se pasa por par�metro.
   * 
   * @param string $class la clase de la jerarqu�a de PrivateAccesor
   * @param string $method el nombre del m�todo a invocar
   * @param array $params un arreglo con los par�metros necesarios para invocar la funci�n en el orden y n�mero correcto
   * @return mixed retorna lo que devuelva la funci�n invocada
   */
  protected static function stInvokeStaticMethod($class, $method, &$params)
  {
    // Bouml preserved body begin 000DCB05
    return call_user_func_array(array($class,$method), $params);
      
//Comentado por PHP 5.2
//    return call_user_func_array("$class::$method", $params);
    // Bouml preserved body end 000DCB05
  }

}
?>