<?php
require_once 'iplan/orm/AbstractDataBase.php';
require_once 'iplan/database/OracleConnection.php';
require_once 'iplan/database/Connection.php';




/**
* Author: Jorge Alexis Viqueira
* 
*/
class OracleDatabase extends AbstractDataBase {
  /**
   * @var OracleConnection una conexi�n a la base de datos Oracle
   */
  private $connection;

  /**
   * Un array con todos los prepared statements para llamar a los procedures del package
   */
  private $statements;

  public function setConnection($value)
  {
    $this->connection = $value;
  }

  public function __construct()
  {
    // Bouml preserved body begin 0006EB05
//Maqueta
    $this->connection = new OracleConnection("172.16.213.28", 1521, "sswmc", "ADMIN_IUNI", "wholesale2010");
//Data Guard
//    $this->connection = new OracleConnection("172.16.57.25", 1521, "AUTOPROPDB_dguard", "ADMIN_IUNI", "wholesale2010");

    $this->connection->connect();
    $this->statements = array();
    return $this;
    // Bouml preserved body end 0006EB05
  }

  /**
   * Dada una tabla y el identificador de registros, devuelve los valores de los campos especificados.
   * @param $table string el nombre de la tabla
   * @param $id long el identificador de la fila en la que estamos interesados
   * @param $fields array un arreglo de strings con los nombres de las columnas a recuperar
   * @return array|false un arreglo asociativo (field=>value) con los valores recuperados de la base o false si hubo alg�n error.
   */
  public function getData($table, $id, $fields = "")
  {
    // Bouml preserved body begin 0006EB85
    $conn = $this->connection;//Declaro así para mayor comodidad

    $ps = $conn->prepareStatement("begin :cursor := PKG_WEB_ACCESSOR.GETDATA(:table, :id , PKG_WEB_ACCESSOR.STR_FIELDS('".implode("','", $fields)."')); end;");
    $cursor = $conn->createCursor();

    $conn->bind($ps, ":table", $table, strlen($table), Connection::T_VARCHAR);
    $conn->bind($ps, ":id", $id, strlen($table), Connection::T_VARCHAR);

    $conn->bind($ps, ":cursor", $cursor, -1, Connection::T_CURSOR);
    if ($conn->execute($ps)) {
        if ($conn->execute($cursor)) {
            $result = $conn->fetchAll($cursor, Connection::M_ASSOCIATIVE);
            $conn->free($cursor);
            return $result[0];
        } else {
            krumo($fields, $conn->lastError($ps));
            return false;
        }
    } else {
        krumo($conn->lastError($ps));
        return false;
    }
    // Bouml preserved body end 0006EB85
  }

  /**
   * Igual a getData() pero m�ltiples filas. La idea ser�a recibir "cuaternas" que armen el SQL a ejecutar en base a la iteraci�n sobre los par�metros (hasta que se acaben) y un gran switch sobre "operation".
   * @param string $table el nombre de la tabla desde la cual recuperar los datos
   * @param array $fields un arreglo de strings con los nombres de los campos a recuperar
   * @param array $conditions otro arreglo con los condicionales codificados, cada uno, de la siguiente forma:array(operation, leftValue, rightValue, connector). Usar AbstractDataBase::makeCondition().
   * @param array $order se pasa aqu� un arreglo de strings con formato "nombreColumna [ASC|DESC]", lo cual ordenar� el conjunto de resultados.
   * @param int $from indica a partir de qu� fila del resultset se desea acceder. Si se indica null trae desde la primer fila.
   * @param int $count indica cu�ntas filas a partir del $from se deben recuperar, si se indica null se recuperan todas.
   * @return array|false el conjunto de resultados o falso si hubo alg�n error
   */
  public function filter($table, $fields, $conditions = "", $order = "", $from = null, $count = null)
  {
    // Bouml preserved body begin 0006EC05
    $conn = $this->connection;//Declaro así para mayor comodidad
    if ($conditions != "") {
        foreach($conditions as $arrCondition) {
            $aOperators[]=$arrCondition['operation'];
            $aLeftValues[]=$arrCondition['leftValue'];
            $aRightValues[]=$arrCondition['rightValue'];
            $aConnectors[]=$arrCondition['connector'];
        }
        $sql = "begin :cursor := PKG_WEB_ACCESSOR.FILTER(:table,". $this->imp('STR_FIELDS', $fields) . ", " .
                                        $this->imp('STR_OPERATORS', $aOperators) . ", " .
                                        $this->imp('STR_VALUES', $aLeftValues) . ", " .
                                        $this->imp('STR_VALUES', $aRightValues) . ", " .
                                        $this->imp('STR_CONNECTOR', $aConnectors) . ", " .
                                        $this->imp('STR_ORDER', $order) . ", " .
                                        $this->php2db($from, ORM_TYPES::INTEGER).", ".$this->php2db($count, ORM_TYPES::INTEGER)."); end;";
    } else {
        $sql = "begin :cursor := PKG_WEB_ACCESSOR.FILTER(:table,". $this->imp('STR_FIELDS', $fields) . ", NULL, NULL, NULL, NULL,".
                $this->imp('STR_ORDER', $order) . ", " . $this->php2db($from, ORM_TYPES::INTEGER).", ".$this->php2db($count, ORM_TYPES::INTEGER)."); end;";
    }
    $ps = $conn->prepareStatement($sql);
    $cursor = $conn->createCursor();
    $conn->bind($ps, ":table", $table, strlen($table), Connection::T_VARCHAR);
    $conn->bind($ps, ":cursor", $cursor, -1, Connection::T_CURSOR);
    if ($conn->execute($ps)) {
        if ($conn->execute($cursor)) {
            $result = $conn->fetchAll($cursor, Connection::M_ASSOCIATIVE);
            $conn->free($cursor);
            return $result;
        } else {
            krumo($fields, $conn->lastError($ps));
            return false;
        }
    } else {
        krumo($conn->lastError($ps));
        return false;
    }
    // Bouml preserved body end 0006EC05
  }

  /**
   * Retorna el valor del campo especificado. El nombre de la columna debe ser el simil al campo definido en la base de datos. La intenci�n es usarlo para recuperar campos BLOB, CLOB y otros "pesados" sobre demanda.
   * 
   * @param string $table el nombre de la tabla
   * @param int $id el identificador del registro
   * @param string $field el nombre del campo a recuperar
   * 
   * @return mixed el valor del campo recuperado.
   */
  public function getField($table, $id, $field)
  {
    // Bouml preserved body begin 0006EC85
    $conn = $this->connection;//Declaro así para mayor comodidad
    if (!isset ($this->statements['getField'])) {
        $this->statements['getField'] = $this->connection->prepareStatement("begin :cursor := PKG_WEB_ACCESSOR.GETFIELD(:table,:id, :field); end;");
    }
    $ps = $this->statements['getField'];
    $cursor = $conn->createCursor();
    $conn->bind($ps, ":table", $table, strlen($table), Connection::T_VARCHAR);
    $conn->bind($ps, ":id", $id, -1, Connection::T_INT);
    $conn->bind($ps, ":field", $field, strlen($field), Connection::T_VARCHAR);
    $conn->bind($ps, ":cursor", $cursor, -1, Connection::T_CURSOR);
    if ($conn->execute($ps)) {
        if ($conn->execute($cursor)) {
            $result = $conn->fetchAll($cursor, Connection::M_ASSOCIATIVE);
            $conn->free($cursor);
            return $result[0][$field];
        } else {
            krumo($field, $conn->lastError($ps));
            return false;
        }
    } else {
        krumo($conn->lastError($ps));
        return false;
    }
    // Bouml preserved body end 0006EC85
  }

  /**
   * Inserta un registro en la tabla con los campos que se indiquen.
   * 
   * @param string $table el nombre de la tabla en la que se desea insertar
   * @param array $fields un arreglo con los campos a insertar. N�tese que las claves son los FieldNames y que all� se instar�n los valores de dichas claves.
   * @param boolean $useGenerator un booleano que indica si al hacer un insert se debe autodetectar la clave primaria y emplear el generador de dicha clave o si s�lo se emplean los valores pasados por par�metro.
   * 
   * @return int el identificador con el cual qued� el registro en la tabla.
   */
  public function insert($table, $fields, $useGenerator = true)
  {
    // Bouml preserved body begin 0006ED05
    $conn = $this->connection;//Declaro así para mayor comodidad
    $sql = "begin :cursor := PKG_WEB_ACCESSOR.INS(:table, ".
                                                 "PKG_WEB_ACCESSOR.STR_FIELDS('".implode("', '", array_keys($fields))."'),".
                                                 "PKG_WEB_ACCESSOR.STR_VALUES('".implode("', '", $fields)."'), ".(($useGenerator)?'1':'0')."); end;";
    $ps = $conn->prepareStatement($sql);
    $conn->bind($ps, ":table", $table, strlen($table), Connection::T_VARCHAR);
    $cursor = $conn->createCursor();
    $conn->bind($ps, ":cursor", $cursor, -1, Connection::T_CURSOR);
    if ($conn->execute($ps)) {
        if ($conn->execute($cursor)) {
            $result = $conn->fetchAll($cursor, Connection::M_ASSOCIATIVE);
            $conn->free($cursor);
            if (isset ($result[0]['ID']))
                return (int) $result[0]['ID'];
            else {
                krumo($sql, $conn->lastError($ps));
                return false;
            }
        } else {
            krumo($sql, $conn->lastError($ps));
            return false;
        }
    } else {
        krumo($sql, $conn->lastError($ps));
        return false;
    }
    // Bouml preserved body end 0006ED05
  }

  /**
   * Realiza un UPDATE sobre la tabla y los campos indicados, es parecido a filter.
   * 
   * @param string $table el nombre de la tabla a actualizar
   * @param array $fields un arreglo cuyas claves son los nombres de los campos a actualizar.
   * @param array $conditions otro arreglo donde cada elemento es un arreglo con el siguiente formato: array(field, operation, value1, value2, connector) el cual se puede generar con la funci�n makeCondition() de cualquier miembro de la jerarqu�a de AbstractDataBase.
   * 
   * @return int|false el n�mero de filas afectadas o false si hubo error
   */
  public function update($table, $fields, $conditions = "")
  {
    // Bouml preserved body begin 0006ED85
    $conn = $this->connection;//Declaro así para mayor comodidad
    if ($conditions == "") {
        $id = $fields['id'];
        unset($fields['id']);
        $sql = "BEGIN :cursor := PKG_WEB_ACCESSOR.UPD(:table, :id, PKG_WEB_ACCESSOR.STR_FIELDS('".implode("', '", array_keys($fields))."'),PKG_WEB_ACCESSOR.STR_VALUES('".implode("', '", $fields)."')); END;";
        $ps = $conn->prepareStatement($sql);
        $conn->bind($ps, ":table", $table, strlen($table), Connection::T_VARCHAR);
        $conn->bind($ps, ":id", $id, sizeof($id), Connection::T_INT);
        $cursor = $conn->createCursor();
        $conn->bind($ps, ":cursor", $cursor, -1, Connection::T_CURSOR);
        if ($conn->execute($ps)) {
            if($conn->execute($cursor)){
                $result = $conn->fetchAll($cursor);
                $conn->free($cursor);
                return $result[0]['COUNTER'];
            } else {
                krumo($sql, $table, $id, $conn->lastError($ps));
                return false;//Falló la ejecución del cursor
            }
        } else {
            krumo($sql, $table, $id, $conn->lastError($ps));
            return false;//Falló el Prepared Statement
        }
    } else { //Update múltiple
        foreach($conditions as $arrCondition) {
            $aOperators[]=$arrCondition['operation'];
            $aLeftValues[]=$arrCondition['leftValue'];
            $aRightValues[]=$arrCondition['rightValue'];
            $aConnectors[]=$arrCondition['connector'];
        }
        $sql = "BEGIN :cursor := PKG_WEB_ACCESSOR.UPD(:table, PKG_WEB_ACCESSOR.STR_FIELDS('".implode("', '", array_keys($fields))."'),PKG_WEB_ACCESSOR.STR_VALUES('".implode("', ", $fields)."'), PKG_WEB_ACCESSOR.STR_OPERATORS('".implode("', '", $aOperators)."'), PKG_WEB_ACCESSOR.STR_VALUES('".implode("', '", $aLeftValues)."'), PKG_WEB_ACCESSOR.STR_VALUES('".implode("', '", $aRightValues)."'), PKG_WEB_ACCESSOR.STR_CONNECTOR('".implode("', '", $aConnectors)."') ); END;";
        //\krumo($sql);
        $ps = $conn->prepareStatement($sql);
        $conn->bind($ps, ":table", $table, strlen($table), Connection::T_VARCHAR);
        $cursor = $conn->createCursor();
        $conn->bind($ps, ":cursor", $cursor, -1, Connection::T_CURSOR);
        if ($conn->execute($ps)) {
            if($conn->execute($cursor)){
                $result = $conn->fetchAll($cursor);
                $conn->free($cursor);
                return (int) $result[0]['COUNTER'];
            } else {
                krumo($conn->lastError($ps));
                return false;//Falló la ejecución del cursor
            }
        } else {
            krumo($conn->lastError($ps));
            return false;//Falló el Prepared Statement
        }
    }
    // Bouml preserved body end 0006ED85
  }

  /**
   * Borra un registro de la tabla seg�n su id o un conjunto de condiciones.
   * 
   * @param string $table el nombre de la tabla sobre la cual hacer el borrado.
   * @param int|array $what puede ser un entero (el id) o un arreglo de condiciones.
   * 
   * @return int|false la cantidad de filas afectadas o false si hubo error
   */
  public function delete($table, $what)
  {
    // Bouml preserved body begin 0006EE05
    $conn = $this->connection;//Declaro así para mayor comodidad
    switch(true) {
        case is_array($what):
            foreach($what as $arrCondition) {
                $aOperators[]=$arrCondition['operation'];
                $aLeftValues[]=$arrCondition['leftValue'];
                $aRightValues[]=$arrCondition['rightValue'];
                $aConnectors[]=$arrCondition['connector'];
            }
            $sql = "BEGIN :result := PKG_DEL(:table, PKG_WEB_ACCESSOR.STR_OPERATORS('".implode("', '", $aOperators)."'), PKG_WEB_ACCESSOR.STR_VALUES('".implode("', '", $aLeftValues)."'), PKG_WEB_ACCESSOR.STR_VALUES('".implode("', '", $aRightValues)."'), PKG_WEB_ACCESSOR.STR_CONNECTOR('".implode("', '", $aConnectors)."') ); END;";
            $ps = $conn->prepareStatement($sql);
            $conn->bind($ps, ":table", $table, strlen($table), Connection::T_VARCHAR);
            $conn->bind($ps, ":result", $result, -1, Connection::T_CURSOR);
            if ($conn->execute($ps)) {
                if($conn->execute($result)){
                    $result = $conn->fetchAll($result);
                    return (int) $result[0]['COUNTER'];
                } else {
                    krumo($conn->lastError($ps));
                    return false;//Falló la ejecución del cursor
                }
            } else {
                krumo($conn->lastError($ps));
                return false;//Falló el Prepared Statement
            }
            break;
        case is_numeric($what):
            if (!isset ($this->statements['delete'])) {
                $this->statements['delete'] = $this->connection->prepareStatement("begin :cursor := PKG_WEB_ACCESSOR.DEL(:table,:id); end;");
            }
            $ps = $this->statements['delete'];
            $cursor = $conn->createCursor();
            $conn->bind($ps, ":table", $table, strlen($table), Connection::T_VARCHAR);
            $conn->bind($ps, ":id", $what, -1, Connection::T_INT);
            $conn->bind($ps, ":cursor", $cursor, -1, Connection::T_CURSOR);
            if ($conn->execute($ps)) {
                if ($conn->execute($cursor)) {
                    $result = $conn->fetchAll($cursor, Connection::M_ASSOCIATIVE);
                    $conn->free($cursor);
                    return (int) $result[0]['COUNTER'];
                } else {
                    krumo($what, $conn->lastError($ps));
                    return false;
                }
            } else {
                krumo($conn->lastError($ps));
                return false;
            }
            break;
        default:
            return false;
    }
    // Bouml preserved body end 0006EE05
  }

  /**
   * Agrega un registro de relaci�n de una relaci�n M:N
   * 
   * @param string $table el nombre de la tabla relaci�n
   * @param array $fields un arreglo indexado por el nombre del campo de la base de datos
   * 
   * @return boolean Retorna TRUE si la operaci�n se realiz� con �xito, FALSE sino.
   */
  public function addRelation($table, $fields)
  {
    // Bouml preserved body begin 00091C85
    $conn = $this->connection;//Declaro así para mayor comodidad
    $sql = "begin :cursor := PKG_WEB_ACCESSOR.INS_REL(:table, ".
                                                 "PKG_WEB_ACCESSOR.STR_FIELDS('".implode("', '", array_keys($fields))."'),".
                                                 "PKG_WEB_ACCESSOR.STR_VALUES('".implode("', '", $fields)."')); end;";
    $ps = $conn->prepareStatement($sql);
    $conn->bind($ps, ":table", $table, strlen($table), Connection::T_VARCHAR);
    $cursor = $conn->createCursor();
    $conn->bind($ps, ":cursor", $cursor, -1, Connection::T_CURSOR);
    if ($conn->execute($ps)) {
        if ($conn->execute($cursor)) {
            $result = $conn->fetchAll($cursor, Connection::M_ASSOCIATIVE);
            $conn->free($cursor);
            if ($result[0]['SQL_STATUS']==1)
                return (int) $result[0]['COUNTER'];
            else {
                krumo($sql, $conn->lastError($ps));
                return false;
            }
        } else {
            krumo($sql, $conn->lastError($ps));
            return false;
        }
    } else {
        krumo($sql, $conn->lastError($ps));
        return false;
    }
    // Bouml preserved body end 00091C85
  }

  /**
   * Quita un registro de relaci�n de una relaci�n M:N
   * 
   * @param string $table el nombre de la tabla relaci�n
   * @param array $fields un arreglo indexado por el nombre del campo de la base de datos para filtrar
   * 
   * @return boolean Retorna TRUE si la operaci�n se realiz� con �xito, FALSE sino.
   */
  public function delRelation($table, $fields)
  {
    // Bouml preserved body begin 00093705
    $conn = $this->connection;//Declaro así para mayor comodidad
    $sql = "begin :cursor := PKG_WEB_ACCESSOR.DEL_REL(:table, ".
                                                 "PKG_WEB_ACCESSOR.STR_FIELDS('".implode("', '", array_keys($fields))."'),".
                                                 "PKG_WEB_ACCESSOR.STR_VALUES('".implode("', '", $fields)."')); end;";
    $ps = $conn->prepareStatement($sql);
    $conn->bind($ps, ":table", $table, strlen($table), Connection::T_VARCHAR);
    $cursor = $conn->createCursor();
    $conn->bind($ps, ":cursor", $cursor, -1, Connection::T_CURSOR);
    if ($conn->execute($ps)) {
        if ($conn->execute($cursor)) {
            $result = $conn->fetchAll($cursor, Connection::M_ASSOCIATIVE);
            $conn->free($cursor);
            return (int) $result[0]['COUNTER'];
        } else {
            krumo($fields, $conn->lastError($ps));
            return false;
        }
    } else {
        krumo($conn->lastError($ps));
        return false;
    }
    // Bouml preserved body end 00093705
  }

  /**
   * Similar a execute() pero s�lo contabiliza la cantidad de registros.
   */
  public function count(&$coded_sql)
  {
    // Bouml preserved body begin 0006EE85
    $conn = $this->connection;//Declaro así para mayor comodidad
    if ($replace) $replace=1;
    else $replace=0;

    $sql = "begin :sql_cursor := PKG_WEB_ACCESSOR.COUNT(:sql_coded); end;";
    $ps = $conn->prepareStatement($sql);
    $conn->bind($ps, ":sql_coded", $coded_sql, 15360, Connection::T_BINARY);
    $cursor = $conn->createCursor();
    $conn->bind($ps, ":res_cursor", $cursor, -1, Connection::T_CURSOR);
    if ($conn->execute($ps)) {
        if ($conn->execute($cursor)) {
            $result = $conn->fetchAll($cursor, Connection::M_ASSOCIATIVE);
            $conn->free($cursor);
            return (int)$result[0]['COUNTER'];
        } else {
            $ps = $conn->prepareStatement("SELECT PKG_WEB_ACCESSOR.DECRYPT(:salida) as salida FROM DUAL");
            $conn->bind($ps, ":salida", $coded_sql,-1, Connection::T_BINARY);
            $query = $conn->execute($ps);
            $data = $conn->fetchAll($ps);
            krumo($data[0]['SALIDA']);
            krumo($conn->lastError($ps), debug_backtrace());
            return false;
        }
    } else {
        krumo($sql, $conn->lastError($ps));
        return false;
    }
    // Bouml preserved body end 0006EE85
  }

  /**
   * Devuelve un string con el tipo de datos instanciado y los valores de los params unidos separados por coma (,). Si el arreglo es vac�o entonces devuelve el string NULL.
   * @param string $dataType el nombre del tipo de datos (ser� puesto en may�sculas y antecedido del nombre del package.
   * @param array $params un arreglo de strings que contiene los valores. Los mismos ser�n puestos entre comillas simples y concatenados separados por coma (,).
   * @return string un string que debe concatenarse directamente con la instrucci�n, consistente del package.dataType('value1', 'value2',...) o NULL
   */
  public function imp($dataType, $params)
  {
    // Bouml preserved body begin 00086205
    if (is_array($params) && (count($params)>0)) {
        return "PKG_WEB_ACCESSOR.".strtoupper($dataType)."('".implode("', '", $params)."')";
    } else {
        return "NULL";
    }
    // Bouml preserved body end 00086205
  }

  /**
   * Funci�n de utiler�a para crear una condici�n
   * 
   * @param string $operation la operaci�n de comparaci�n o verificaci�n: =, &lt;&gt;, LIKE, IN, NOT, BETWEEN. En el caso de IN la funci�n espera que el rightValue sea un array y separa sus componentes por "," y los encierra entre par�ntesis.
   * @param mixed $leftValue el primer operando
   * @param mixed $rightValue el segundo operando
   * @connector string $connector el conector con el que se debe unir esta condici�n con la siguiente (AND, OR)
   * @return array el arreglo de la condici�n formateado
   */
  public function makeCondition($operation, $leftValue, $rightValue, $connector = "AND")
  {
    // Bouml preserved body begin 00093605
    $operation = trim($operation);
    $connector = trim($connector);
    switch ($operation) {
        case "IN":
        case "NOT IN":
            $rightValue = '('.implode(",", $rightValue).')';
            break;
    }
    return array('operation'=>$operation, 'leftValue'=>$leftValue, 'rightValue'=>$rightValue, 'connector'=>$connector);
    // Bouml preserved body end 00093605
  }

  /**
   * Convierte valores PHP a la representaci�n necesaria para que la base de datos lo entienda. Debe ser utilizado para pasar los "values" en las funciones.
   * @param mixed $value el valor nativo de PHP que se desea convertir
   * @param int $type el tipo al que queremos castear, adopta las constates de ORM_TYPES
   * 
   * @return mixed El valor que requiere la base de datos
   */
  public function php2db($value, $type)
  {
    // Bouml preserved body begin 00090105
    //Se asume que el $value es un valor orientado al tipo destino
    if (is_null($value)) return "NULL";
    switch($type) {
        case ORM_TYPES::BOOLEAN:
            if ($value) return 1;
            else return 0;
            break;
        case ORM_TYPES::BIGINT:
        case ORM_TYPES::DECIMAL:
        case ORM_TYPES::INTEGER:
        case ORM_TYPES::SMALLINT:
            if ($value=="") return "NULL";
            else return $value;
            break;
        case ORM_TYPES::DATE:
            if (is_a($value, "\DateTime"))
                return "to_date('".date_format($value, 'Ymd')."','YYYYMMDD')";
            else if (strtoupper($value) == "NOW()") return "sysdate";
            else return "NULL";
            break;
        case ORM_TYPES::TIME:
            if (is_a($value, "\DateTime"))
                return "to_date('".date_format($value, 'His')."','HH24MISS')";
            else if (strtoupper($value) == "NOW()") return "sysdate";
            else return "NULL";
            break;
        case ORM_TYPES::DATETIME:
            if (is_a($value, "\DateTime"))
                return "to_date('".date_format($value, 'Ymd His')."','YYYYMMDD HH24MISS')";
            else if (strtoupper($value) == "NOW()") return "sysdate";
            else return "NULL";
            break;
        case ORM_TYPES::STRING:
        case ORM_TYPES::TEXT:
        default:
            if ($value=="") return "NULL";
            else return "''".addslashes($value)."''";
    }
    // Bouml preserved body end 00090105
  }

  /**
   * Convierte valores devueltos por la base de datos a la representaci�n PHP solicitada. Debe ser utilizado para pasar los "values" en las funciones.
   * @param mixed $value el valor nativo de PHP que se desea convertir
   * @param int $type el tipo al que queremos castear, adopta las constates de ORM_TYPES
   * 
   * @return mixed El valor convertido a su representaci�n PHP m�s pr�xima
   */
  public function db2php($value, $type)
  {
    // Bouml preserved body begin 00090185
    //Se asume que el $value es un valor orientado al tipo destino
    if (is_null($value)) return null;
    
    switch($type) {
        case ORM_TYPES::BIGINT:
        case ORM_TYPES::BOOLEAN:
        case ORM_TYPES::INTEGER:
        case ORM_TYPES::SMALLINT:
            return (int)$value;
            break;
        case ORM_TYPES::DECIMAL:
            return (float)$value;
            break;
        case ORM_TYPES::DATE: //En Oracle son la misma cosa
        case ORM_TYPES::TIME:
            $value=DateTime::createFromFormat("d-M-y H:i:s", $value);
            return $value;
            break;
        case ORM_TYPES::DATETIME: //NO VERIFICADO!! Se supone que es un timestamp
            $value=DateTime::createFromFormat("d-M-y H:i:s", $value);
            return $value;
            break;
        case ORM_TYPES::STRING:
        case ORM_TYPES::TEXT:
        default:
            return stripslashes("$value");
    }
    // Bouml preserved body end 00090185
  }

  /**
   * Retorna un valor de fecha y hora de la base.
   * 
   * @return datetime El momento en el cual se efect�a el llamado seg�n la base de datos.
   */
  public function getDateTime()
  {
    // Bouml preserved body begin 00091B85
    throw new Exception("Función getDateTime() NO IMPLEMENTADA!");
    // Bouml preserved body end 00091B85
  }

  /**
   * Es una implementaci�n especial que se utiliza para brindar soporte a ORMQuery.
   * Toma una tabla, el conjunto de campos de retorno y la lista de condiciones de filtrado retornando una representaci�n de la misma.
   * 
   * @param string $table el nombre de la tabla sobre la que se va a filtrar.
   * @param array $fields una lista de los nombres de los campos a retornar.
   * @param array $conditions las condiciones de filtrado. Para generar la lista use makeCondition().
   * 
   * @return Una representaci�n encapsulada de la consulta.
   * 
   * @see sql_add_condition()
   * @see sql_execute()
   */
  public function sql_filter($table, $fields, $alias = "", $conditions = "")
  {
    // Bouml preserved body begin 0009A405
    $conn = $this->connection;//Declaro así para mayor comodidad
    if ($conditions != "") {
        foreach($conditions as $arrCondition) {
            $aOperators[]=$arrCondition['operation'];
            $aLeftValues[]=$arrCondition['leftValue'];
            $aRightValues[]=$arrCondition['rightValue'];
            $aConnectors[]=$arrCondition['connector'];
        }
    }


    $sql = "begin :sql_coded := PKG_WEB_ACCESSOR.SQL_FILTER(:table, :alias, ". $this->imp("STR_FIELDS", $fields);
    if ($conditions != "") {
        $sql .=                                  ", ".$this->imp("STR_OPERATORS", $aOperators) .
                                                 ", ".$this->imp("STR_VALUES", $aLeftValues) .
                                                 ", ".$this->imp("STR_VALUES", $aRightValues) .
                                                 ", ".$this->imp("STR_CONNECTOR", $aConnectors) . "); end;";
    } else {
        $sql .= ", NULL, NULL, NULL, NULL); end;";
    }
//    echo $sql;
    $ps = $conn->prepareStatement($sql);
    $conn->bind($ps, ":table", $table, strlen($table), Connection::T_VARCHAR);
    $conn->bind($ps, ":alias", $alias, strlen($table), Connection::T_VARCHAR);
    $conn->bind($ps, ":sql_coded", $sql_coded, 15360, Connection::T_BINARY);
    if ($conn->execute($ps)) {
        return $sql_coded;
    } else {
        krumo(array('table'=>$table, 'fields'=>$fields, 'alias'=>$alias, 'conditions'=>$conditions), $conn->lastError($ps), debug_backtrace());
        return false;
    }
    // Bouml preserved body end 0009A405
  }

  /**
   * Agrega una condici�n de IN o NOT IN al sql indicado en base a otro select.
   * 
   * @param string $main_sql el sql codificado producto de un llamado previo a sql_filter() o sql_add_condition()
   * @param string $table el nombre de la tabla a la que pertenece el field que se va a filtrar
   * @param string field el campo que se validar�
   * @param string operator el tipo de filtrado ('IN' o 'NOT IN')
   * @param string sql_select el select codificado que recupera la lista de claves
   * @param string alias por ahora no se usa y debe pasarse como ""
   * 
   * @return string un sql codificado.
   * 
   * @see sql_filter()
   * @see sql_execute()
   */
  public function sql_add_condition(&$main_sql, $table, $field, $operator, &$sql_select, $alias = "")
  {
    // Bouml preserved body begin 0009BD85
    $conn = $this->connection;//Declaro así para mayor comodidad

    $sql = "begin :sql_coded := PKG_WEB_ACCESSOR.SQL_ADD_CONDITION(:main_sql, '$table', NULL, '$field', '$operator', :sql_select); end;";
    $ps = $conn->prepareStatement($sql);
    $conn->bind($ps, ":main_sql", $main_sql, 15360, Connection::T_BINARY);
    $conn->bind($ps, ":sql_select", $sql_select, 15360, Connection::T_BINARY);
    $conn->bind($ps, ":sql_coded", $sql_coded, 15360, Connection::T_BINARY);
//    $conn->bind($ps, ":table", $table, strlen($table), Connection::T_VARCHAR);
//    $conn->bind($ps, ":alias", $alias, strlen($alias), Connection::T_VARCHAR);
//    $conn->bind($ps, ":field", $field, strlen($field), Connection::T_VARCHAR);
//    $conn->bind($ps, ":operator", $operator, strlen($operator), Connection::T_VARCHAR);
    if ($conn->execute($ps)) {
        return $sql_coded;
    } else {
        krumo($conn->lastError($ps), debug_backtrace());
        return false;
    }
    // Bouml preserved body end 0009BD85
  }

  /**
   * Agrega una condici�n general (global) a la instrucci�n SQL codificada.
   * 
   * @param string $coded_sql el SQL Codificado
   * @param array $conditions las condiciones a agregar
   * @return string el SQL resultante encriptado
   */
  public function sql_add_where(&$coded_sql, $conditions)
  {
    // Bouml preserved body begin 000CA585
    $conn = $this->connection;//Declaro así para mayor comodidad
    if ($conditions != "") {
        foreach($conditions as $arrCondition) {
            $aOperators[]=$arrCondition['operation'];
            $aLeftValues[]=$arrCondition['leftValue'];
            $aRightValues[]=$arrCondition['rightValue'];
            $aConnectors[]=$arrCondition['connector'];
        }
    }


    $sql = "begin :sql_coded2 := PKG_WEB_ACCESSOR.SQL_JOIN_TABLE(sql_coded";
    if ($conditions != "") {
        $sql .=                                  ", ".$this->imp("STR_OPERATORS", $aOperators) .
                                                 ", ".$this->imp("STR_VALUES", $aLeftValues) .
                                                 ", ".$this->imp("STR_VALUES", $aRightValues) .
                                                 ", ".$this->imp("STR_CONNECTOR", $aConnectors) . "); end;";
    } else {
        $sql .= ", NULL, NULL, NULL, NULL); end;";
    }
//    echo $sql;
    $ps = $conn->prepareStatement($sql);
    $conn->bind($ps, ":sql_coded", $coded_sql, 15360, Connection::T_BINARY);
    $conn->bind($ps, ":sql_coded2", $coded_sql2, 15360, Connection::T_BINARY);
    if ($conn->execute($ps)) {
        return $sql_coded2;
    } else {
        krumo($conn->lastError($ps), debug_backtrace());
        return false;
    }
    // Bouml preserved body end 000CA585
  }

  /**
   * Une mediante un JOIN los valores de la consulta actual con los de otra clase, utilizando para el emparejamiento las condiciones dadas e incorporando al conjunto de resultados los atributos indicados.
   * @param string	$coded_sql el sql codificado a modificar
   * @param string $table la tabla contra la que se va a hacer el JOIN
   * @param string $alias el alias de la tabla
   * @param array $fields los nuevos fields a incorporar en el conjunto de resultados
   * @param array $conditions las condiciones de emparejamiento del conjunto de resultados
   */
  public function sql_join_table(&$coded_sql, $table, $alias, $fields, $conditions)
  {
    // Bouml preserved body begin 000C8B05
    $conn = $this->connection;//Declaro así para mayor comodidad
    if ($conditions != "") {
        foreach($conditions as $arrCondition) {
            $aOperators[]=$arrCondition['operation'];
            $aLeftValues[]=$arrCondition['leftValue'];
            $aRightValues[]=$arrCondition['rightValue'];
            $aConnectors[]=$arrCondition['connector'];
        }
    }


    $sql = "begin :sql_coded2 := PKG_WEB_ACCESSOR.SQL_JOIN_TABLE(:sql_coded,:table, :alias, ". $this->imp("STR_FIELDS", $fields);
    if ($conditions != "") {
        $sql .=                                  ", ".$this->imp("STR_OPERATORS", $aOperators) .
                                                 ", ".$this->imp("STR_VALUES", $aLeftValues) .
                                                 ", ".$this->imp("STR_VALUES", $aRightValues) .
                                                 ", ".$this->imp("STR_CONNECTOR", $aConnectors) . "); end;";
    } else {
        $sql .= ", NULL, NULL, NULL, NULL); end;";
    }
//    echo $sql;
    $ps = $conn->prepareStatement($sql);
    $conn->bind($ps, ":sql_coded", $coded_sql, 15360, Connection::T_BINARY);
    $conn->bind($ps, ":table", $table, strlen($table), Connection::T_VARCHAR);
    $conn->bind($ps, ":alias", $alias, strlen($table), Connection::T_VARCHAR);
    $conn->bind($ps, ":sql_coded2", $coded_sql2, 15360, Connection::T_BINARY);
    if ($conn->execute($ps)) {
        return $coded_sql2;
    } else {
        krumo($conn->lastError($ps), debug_backtrace());
        return false;
    }
    // Bouml preserved body end 000C8B05
  }

  /**
   * Une mediante un JOIN los valores de la consulta actual con los de otra clase, utilizando para el emparejamiento las condiciones dadas e incorporando al conjunto de resultados los atributos indicados.
   * @param string	$coded_sql el sql codificado a modificar
   * @param string $coded_sql2 la otra consulta contra la que se va a hacer el JOIN
   * @param string $alias el alias de la tabla
   * @param array $fields los nuevos fields a incorporar en el conjunto de resultados
   * @param array $conditions las condiciones de emparejamiento del conjunto de resultados
   */
  public function sql_join(&$coded_sql, &$coded_sql2, $alias, $fields, $conditions)
  {
    // Bouml preserved body begin 000C8C05
    $conn = $this->connection;//Declaro así para mayor comodidad
    if ($conditions != "") {
        foreach($conditions as $arrCondition) {
            $aOperators[]=$arrCondition['operation'];
            $aLeftValues[]=$arrCondition['leftValue'];
            $aRightValues[]=$arrCondition['rightValue'];
            $aConnectors[]=$arrCondition['connector'];
        }
    }


    $sql = "begin :sql_coded3 := PKG_WEB_ACCESSOR.SQL_JOIN_TABLE(:sql_coded,:sql_coded2, :alias, ". $this->imp("STR_FIELDS", $fields);
    if ($conditions != "") {
        $sql .=                                  ", ".$this->imp("STR_OPERATORS", $aOperators) .
                                                 ", ".$this->imp("STR_VALUES", $aLeftValues) .
                                                 ", ".$this->imp("STR_VALUES", $aRightValues) .
                                                 ", ".$this->imp("STR_CONNECTOR", $aConnectors) . "); end;";
    } else {
        $sql .= ", NULL, NULL, NULL, NULL); end;";
    }
//    echo $sql;
    $ps = $conn->prepareStatement($sql);
    $conn->bind($ps, ":sql_coded", $coded_sql, 15360, Connection::T_BINARY);
    $conn->bind($ps, ":sql_coded2", $coded_sql2, 15360, Connection::T_BINARY);
    $conn->bind($ps, ":alias", $alias, strlen($table), Connection::T_VARCHAR);
    $conn->bind($ps, ":sql_coded3", $sql_coded3, 15360, Connection::T_BINARY);
    if ($conn->execute($ps)) {
        return $sql_coded3;
    } else {
        krumo($conn->lastError($ps), debug_backtrace());
        return false;
    }
    // Bouml preserved body end 000C8C05
  }

  /**
   * Ejecuta una consulta codificada con sql_filter() o sql_add_condition().
   * 
   * @param string $coded_sql la consulta codificada a ejecutar
   * @param array $order un arreglo con los nombres de los campos para el ordenamiento... se puede poner un espacio y ASC o DESC seg�n se desee.
   * @param int $from el primer registro del conjunto de resultados
   * @param int $count la cantidad de registros que se espera leer
   * 
   * @return array un arreglo con los campos solicitados
   * 
   * @see sql_filter()
   * @see sql_add_condition()
   */
  public function sql_execute(&$coded_sql, $order = null, $from = null, $count = null)
  {
    // Bouml preserved body begin 0009BE05
    $conn = $this->connection;//Declaro así para mayor comodidad
    $sql = "begin :cursor := PKG_WEB_ACCESSOR.SQL_EXECUTE(:sql, ".$this->imp("STR_ORDER", $order).", :from, :count); end;";
    $ps = $conn->prepareStatement($sql);
    $conn->bind($ps, ":sql", $coded_sql, -1, Connection::T_BINARY);
    $conn->bind($ps, ":from", $from);
    $conn->bind($ps, ":count", $count);
    $cursor = $conn->createCursor();
    $conn->bind($ps, ":cursor", $cursor, -1, Connection::T_CURSOR);
    if ($conn->execute($ps)) {
        if ($conn->execute($cursor)) {
            $result = $conn->fetchAll($cursor, Connection::M_ASSOCIATIVE);
            $conn->free($cursor);
            return $result;
        } else {
            $ps = $conn->prepareStatement("SELECT PKG_WEB_ACCESSOR.DECRYPT(:salida) as salida FROM DUAL");
            $conn->bind($ps, ":salida", $coded_sql,-1, Connection::T_BINARY);
            $query = $conn->execute($ps);
            $data = $conn->fetchAll($ps);
            krumo($data[0]['SALIDA']);
            krumo($conn->lastError($ps), debug_backtrace());
            return false;
        }
    } else {
//        $ps = $conn->prepareStatement("SELECT PKG_WEB_ACCESSOR.DECRYPT(:salida) as salida FROM DUAL");
//        $conn->bind($ps, ":salida", $coded_sql,-1, Connection::T_BINARY);
//        $query = $conn->execute($ps);
//        $data = $conn->fetchAll($ps);
//        \krumo($data[0]['SALIDA']);
        krumo($sql, $conn->lastError($ps));
        return false;
    }
    // Bouml preserved body end 0009BE05
  }

  /**
   * Devuelve la conexi�n usada por la instancia.
   * 
   * @return Connection La conexi�n que utiliza la instancia de base de datos
   */
  public function getConnection()
  {
    // Bouml preserved body begin 000A9605
    return $this->connection;
    // Bouml preserved body end 000A9605
  }

  /**
   * Ejecuta una consulta codificada con sql_filter() o sql_add_condition().
   * 
   * @param string $coded_sql la consulta codificada a ejecutar
   * @param array $groups un arreglo con los campos que se agrupar�n de la consulta
   * @param array $order un arreglo con los nombres de los campos para el ordenamiento... se puede poner un espacio y ASC o DESC seg�n se desee.
   * @param int $from el primer registro del conjunto de resultados
   * @param int $count la cantidad de registros que se espera leer
   * 
   * @return array un arreglo con los campos solicitados
   * 
   * @see sql_filter()
   * @see sql_add_condition()
   */
  public function sql_execute2(&$coded_sql, $groups = null, $order = null, $from = null, $count = null)
  {
    // Bouml preserved body begin 000CC205
    $conn = $this->connection;//Declaro así para mayor comodidad
    if (is_null($from))  $from  = 'NULL';
    if (is_null($count)) $count = 'NULL';
    $sql = "begin :res_cursor := PKG_WEB_ACCESSOR.SQL_EXECUTE2(:coded_sql, ".$this->imp("STR_FIELDS", $groups).",".$this->imp("STR_ORDER", $order).", $from, $count); end;";
    $ps = $conn->prepareStatement($sql);
    $conn->bind($ps, ":coded_sql", $coded_sql, -1, Connection::T_BINARY);
    $cursor = $conn->createCursor();
    $conn->bind($ps, ":res_cursor", $cursor, -1, Connection::T_CURSOR);
    if ($conn->execute($ps)) {
        if ($conn->execute($cursor)) {
            $result = $conn->fetchAll($cursor, Connection::M_ASSOCIATIVE);
            $conn->free($cursor);
            return $result;
        } else {
            $ps = $conn->prepareStatement("SELECT PKG_WEB_ACCESSOR.DECRYPT(:salida) as salida FROM DUAL");
            $conn->bind($ps, ":salida", $coded_sql,-1, Connection::T_BINARY);
            $query = $conn->execute($ps);
            $data = $conn->fetchAll($ps);
            krumo($data[0]['SALIDA']);
            krumo($conn->lastError($ps), debug_backtrace());
            return false;
        }
    } else {
//        $ps = $conn->prepareStatement("SELECT PKG_WEB_ACCESSOR.DECRYPT(:salida) as salida FROM DUAL");
//        $conn->bind($ps, ":salida", $coded_sql,-1, Connection::T_BINARY);
//        $query = $conn->execute($ps);
//        $data = $conn->fetchAll($ps);
//        \krumo($data[0]['SALIDA']);
        krumo($sql, $conn->lastError($ps));
        return false;
    }
    // Bouml preserved body end 000CC205
  }

  /**
   * Agrega o reemplaza el from de una sentencia SQL.
   * 
   * @param string $coded_sql el SQL Codificado
   * @param array $from las columnas a agregar
   * @param boolean $replace especifica si el from existente debe preservarse o no.
   * @param boolean $distinct especifica si se agrega la palabra DISTINCT luego del SELECT. Este cambio es NO REVERSIBLE!!
   * @return string el SQL resultante encriptado
   */
  public function sql_set_columns(&$coded_sql, $from, $replace = true, $distinct = false)
  {
    // Bouml preserved body begin 000CC385
    $conn = $this->connection;//Declaro así para mayor comodidad
    if ($replace) $replace=1;
    else $replace=0;

    if ($distinct) $distinct=1;
    else $distinct=0;

    $sql = "begin :sql_result := PKG_WEB_ACCESSOR.SQL_SET_COLUMNS(:sql_coded, ".$this->imp('STR_FIELDS', $from).", $replace, $distinct); end;";
    $ps = $conn->prepareStatement($sql);
    $conn->bind($ps, ":sql_coded", $coded_sql, 15360, Connection::T_BINARY);
    $conn->bind($ps, ":sql_result", $result, 15360, Connection::T_BINARY);
    
    if ($conn->execute($ps)) {
        return $result;
    } else {
        krumo($conn->lastError($ps), debug_backtrace());
        return false;
    }
    // Bouml preserved body end 000CC385
  }

}
?>