/**
 *   Esta función "bloquea" un div anteponiendo una capa por sobre sus elementos
 * y devolviendo un identificador que puede utilizarse para desbloquearlo o
 * colocar contenido por sobre el div.
 */
var max_z = 1000;
var blockers = new Array();
var enabled = false;

function InitBlockerSystem() {
    $(window).resize(blockerResizeEvent);
}

function Blocker(div) {
    var instance = $('#'+div);
    this.parent = div;
    this.blocker = div+"_blocker";
    this.box = div+"_blocker_box";
    this.unblock = unblock;
    this.content = content;
    this.enableClose = enableClose;
    this.enableClose = disableClose;
    instance.append('<div id="'+this.blocker+'" class="screenBlocker" style="z-index: '+(instance.css('z-index')+max_z)+';left:'+instance.offset().left+'px;top:'+instance.offset().top+'px;height:'+instance.height()+'px;width:'+instance.width()+'px;"><div id="'+
                  this.box+'" class="screenBlockerBox" style="z-index: '+(instance.css('z-index')+max_z+1)+'"></div></div>');
    blockers[div]=this;
    return this;
}

/**
 *  Bloquea una capa por su id.
 */
function block(div_id, html) {
    blocker = new Blocker(div_id);
    if (html !== null) {
        blocker.content(html);
    } else {
        blockerResize(blocker.parent);
    }
    return blocker;
}

/**
 *  Quita el handler de la capa y de las capas hijas de la lista de handlers
 * y elimina la capa y las capas hijas.
 */
function unblock() {
    $('#'+this.blocker)
        .find("screenBlocker")
        .each( function() {
                var parent_id = $(this).parent().attr('id');
                blockers[parent_id]=null;
               });
    $('#'+this.blocker).remove();
    blockers.splice(this.parent, 1);
}

/**
 *  Establece el contenido de la capa de bloqueo
 */
function content(html, width, height) {
    var blocker = $('#'+this.box);
    blocker.html(html);
    if (width !== null) {
        blocker.width(width);
    }
    if (height !== null) {
        blocker.height(height);
    }
    blockerResize(this.parent);
}

/**
 *  Recalcula el tamaño de todas las layers de bloqueo
 */
function blockerResizeEvent() {
    for(blocker in blockers) {
        blockerResize(blocker);
    }
}

/**
 *  Cambia el tamaño del bloqueador y centra el contenido del mensaje
 */
function blockerResize(blocker) {
    if (blockers[blocker] !== null) {
        var id_blocker='#'+blockers[blocker].blocker;
        var parent = $('#'+blockers[blocker].parent);
        if ($(id_blocker).css('display')=='block') {
            $(id_blocker).css({'left':parent.offset().left, 'top':parent.offset().top, 'width':parent.width(),'height':parent.height()});
            var box = $('#'+blockers[blocker].box);
            var centroH = parent.width()/2;
            var desvioH = box.width()/2;
            box.css('left', centroH-desvioH);
            var centroV = parent.height()/2;
            var desvioV = box.height()/2;
            box.css('top', centroV-desvioV);
        }
    }
}

function enableClose() {
    $(this.box).append('<a id="screenBlocker_unblock" href="javascript:blockers["'+this.parent+'"].unblock();return false;">Cerrar</a>')
}

function disableClose() {
    $(this.box).remove("#screenBlocker_unblock");
}

/**
 * Carga el resultado de invocar a la url especificada con los parámetros indicados en el
 * div que se llama como el parámentro div. También si ya existe un bloqueo vigente se
 * cambia el contenido del mensaje al de "Cargando..."
 */
function uws_load(url, params, div, block_id) {
/*    var debug = "URL: "+url+"\nParametros:\n";
    for(param in params) {
        debug += param + "\t" + params[param] +"\n";
    }
    debug += +"\nTarget: "+div+"\nBloquear: "+block_id;
    alert(debug);*/
    var blocker;
	url = url.replace('index.php', 'request.php');
    if (block_id == undefined) blocker = block(div);
    else blocker = block(block_id);
    blocker.content('<img src="images/wait.gif" alt=""/> Cargando...');

    $("#"+div).load(url, params, function(responseText, textStatus, xhr) {
                                        if (status == "error") {
                                            blocker.content(xhr.status + " " + xhr.statusText);
                                            blocker.enableClose();
                                        } else {
                                            blocker.unblock();
                                        }
                                 });
    return false;
}

var uws_extra_params = {};
function uws_setExtraParams(params) {
	uws_extra_params = $.extend(uws_extra_params, params);
	return true;
}

/**
 * Esta función recibe un formulario (obligatorio), lo envía en background y vuelca el resultado en el div que se indique.
 * @param object _form el objeto formulario. Generalmente se pasa a través del puntero this.
 * @param string div el identificador (id) del div que recibirá el contenido que resulte del llamado AJAH.
 * @param int block_id el identificador de bloqueo en el caso que esta operación deba "rehabilitar" un bloqueo previo.
 * 
 * @return false La función retorna siempre false para que al emplearla en el onsubmit="" de un formulario pueda cancelarse el envío del mismo.
 * TODO: contempras enctype, accept y accept-charset
 */
function uws_submit (_form, validations, div, block_id, extra) {
    var form = $(_form);
    var url = form.attr('action');
    url = url.replace('index.php', 'request.php');
    var method = form.attr('method');
    var blocker;
	
    //Busco el primer div con ID asignado
    if (div == undefined) {
        //Idealmente (si JQuery anduviera bien, sería algo como form.parent('div[id]').attr('id') pero la posta es que JQuery tiene BUG.
        div = form.parent('div');
        while (div != undefined) {
            if (div.attr('id')!=undefined) break;
            else div = div.parent('div');
        }
        div = div.attr('id');
    }
    
    if (validations != undefined) {
        var validations_ok = uws_validate(_form, validations);
		if (validations_ok != true) return false;
    }
    
    if (block_id == undefined) blocker = block(div);
    else blocker = block(block_id);
    blocker.content('<img src="images/wait.gif" alt=""/> Cargando...');
    var params = form.serialize();
	for(property in uws_extra_params) {
		params +='&'+property+'='+uws_extra_params[property];
	}
	uws_extra_params = {};
    var extra_params = {'async':false,
                        'data':params, 
                        'dataType':'html', 
                        'type':method, 
                        'success':function(responseText, status, xhr) {
                                    $('#'+div).html(responseText);
                                    blocker.unblock();
                                 },
                        'error':function(responseText, status, xhr) {
                                    blocker.content(xhr.status + " " + xhr.statusText);
                                    blocker.enableClose();
                                },
                        'timeout':3000
                       };
    $.ajax(url,extra_params);
    return false;
}

var filters = {"alpha" : uws_alpha, 
			   "numeric" : uws_numeric, 
			   "alphanumeric" : uws_alphanumeric, 
			   "mail" : uws_mail, 
			   "required" : uws_required, 
			   "regexp" : uws_regexp, 
			   "min" : uws_min, 
			   "max" : uws_max, 
			   "float" : uws_float, 
			   "minvalue" : uws_minvalue, 
			   "maxvalue" : uws_maxvalue};

function uws_validate(frm, adds) {
    var ret = true;
	$(frm).find('.form_dynamic_error').remove();
    $(frm).find(".validate").each(function () {
										var comp = $(this);
										var result = uws_validate_this(this, adds);
                                        if (result != true) {
												var off = comp.offset();
												var poff = comp.parent().parent().offset();
												comp.parent().append('<div class="form_dynamic_error"><span style="margin-left:'+(off.left-poff.left)+'px">'+result+'</span></div>');
                                                ret = false;
                                        }
                            });

    return ret;
}

function uws_validate_this(obj, adds) {
    var me = $(obj);
    var ok = true;
    var message = "";
    for(filter in filters) {
        if (me.hasClass(filter)) {
			var fld = me.attr('name').toString().replace('[]', '');
//			var msg = "Invocando: "+filter+" en "+fld+"\n";
//			alert(msg);
            ok = filters[filter](obj, adds[fld]);
            if (ok != true) {
				message += ok+'<br/>';
            }
        }
    }
    if (message=="") return true;
    else return message;
}

/*
 * Validaciones:
 *      Cada función es una validación. Toman el objeto a validar, el cual es un HTMLObject de un formulario y opciones adicionales que
 *      pueden o no serle útiles.
 */
function uws_alpha(obj, options){
        var patt1 = new RegExp("^[(a-z|A-Z|\\s)]*$");
        if (patt1.test(obj.value)) {
			return true;
		} else {
			return '"'+obj.value+'" no es un valor alfabético, verifique que no tenga símbolos ni números';
		}
}
function uws_alphanumeric(obj, options){
        var patt1 = new RegExp("^[(0-9|a-z|A-Z|\\s)]*$");
        if (patt1.test(obj.value)) {
			return true;
		} else {
			return '"'+obj.value+'" no es un valor alfanumérico, verifique que no tenga símbolos';
		}
}
function uws_mail(obj, options){
        var patt1 = new RegExp("^[a-zA-Z0-9]+(.[a-zA-Z0-9_-]+|[a-zA-Z0-9_-]+)*@[a-z0-9][\\w\\.-]*[a-z0-9]\\.[a-z][a-z\\.]*[a-z]$");
        if (patt1.test(obj.value)) {
			return true;
		} else {
			return '"'+obj.value+'" no es una dirección de mail válida';
		}
}
function uws_numeric(obj, options){
        var patt1 = new RegExp("^\\d*$");
        if (patt1.test(obj.value)) {
			return true;
		} else {
			return '"'+obj.value+'" no es un valor numérico, verifique que no tenga símbolos ni letras';
		}
}
function uws_float(obj, options){
        var patt1 = new RegExp("^([+-]?((([0-9]+\\,?)|([0-9]*\\,[0-9]+))))$");
        if (patt1.test(obj.value)) {
			return true;
		} else {
			return '"'+obj.value+'" no es un valor decimal, verifique que no tenga símbolos, ni letras';
		}
}
function uws_required(obj, options){
        switch(obj.type) {
                case "text":
                case "textarea":
                case "password":
                        if (obj.value.length > 0) {
							return true;
						} else {
							return "Se requiere que ingrese un valor";
						}
                        break;
                case 'select-multiple':
                case 'select-one':
                        var cant_sel = uws_cant_opts_selected(obj);
                        if (cant_sel > 0) {
							return true;
						} else {
							return "Debe seleccionar al menos una opción";
						}
                        break;
                default:
                        return false;
        }
}
function uws_regexp(obj, options) {
        for (expi in options) {
                if (expi == "regexp") {
                        for (expes in options["regexp"]) {
//								alert("regexp: "+options["regexp"][expes]);
                                var patt1 = new RegExp(options["regexp"][expes]);
                                if (!(patt1.test(obj.value))) return '"'+obj.value+'" no es un valor válido';//return false;
                        }
                }
        }
        return true;
}

function uws_max(obj, options) {
        switch(obj.type) {
                case "text":
                case "textarea":
                case "password":
                        if (obj.value.length <= options['max']) {
							return true;
						} else {
							return "El valor no puede tener más de "+options['max']+" caracteres";
						}
                        break;
                case 'select-multiple':
                case 'select-one':
//						alert('max: '+options['max']);
                        var cant_sel = uws_cant_opts_selected(obj);
                        if (cant_sel <= options['max']) {
							return true;
						} else {
							return "No puede elegir más de "+options['max']+" opciones";
						}
                        break;
                default:
                        return false;
        }
}


//TODO: cambiar esto con jquery
function uws_cant_opts_selected(selecs) {
        opts = selecs.getElementsByTagName('option');
        var cant = 0;
        for (i = 0; i < opts.length; i++) {
                if (opts[i].selected) {
                        cant++;
                }
        }
        return cant;
}

function uws_min(obj, add) {
        switch(obj.type) {
                case "text":
                case "textarea":
                case "password":
//						alert('min: '+add['min']);
                        if (obj.value.length >= add['min']) {
							return true;
						} else {
							return "El valor debe tener al menos "+add['min']+" caracteres";
						}
                        break;
                case 'select-multiple':
                case 'select':
//						alert('min: '+add['min']);
                        var cant_sel = uws_cant_opts_selected(obj);
                        if (cant_sel >= add['min']) {
							return true;
						} else {
							return "Debe elegir al menos "+add['min']+" opcion(es)";
						}
                        break;
                default:
                        return false;
        }
}

function uws_minvalue(obj, add) {
        switch(obj.type) {
                case "text":
//						alert('minvalue: '+add['min']);
                        if (obj.value >= add['min']) {
							return true;
						} else {
							return "El valor mínimo admitido es "+add['min'];
						}
                        break;
                default:
//						alert('minvalue: FALSE');
                        return false;
        }
}

function uws_maxvalue(obj, add) {
        switch(obj.type) {
                case "text":
//						alert('maxvalue: '+add['max']);
                        if (obj.value <= add['max']) {
							return true;
						} else {
							return "El valor máximo admitido es "+add['max'];
						}
                        break;
                default:
//						alert('maxvalue: FALSE');
                        return false;
        }
}
