/**
 *   Esta función "bloquea" un div anteponiendo una capa por sobre sus elementos
 * y devolviendo un identificador que puede utilizarse para desbloquearlo o
 * colocar contenido por sobre el div.
 */
var max_z = 1000;
var blockers = new Array();
var enabled = false;
var uws_back_timer;
var uws_countdown_timer;

/* Agrego un simil a sprintf de PHP pero para javascript.
 * Uso:
 *      "Hola {0}, hoy es un {1} día.".format("Jorge", "lindo")
 *   =  "Hola Jorge, hoy es un lindo día."
 */
String.prototype.format = function() {
  var args = arguments;
  return this.replace(/\%(\d+)/g, function(match, number) { 
    return typeof args[number] != 'undefined'
      ? args[number]
      : match
    ;
  });
};



function InitBlockerSystem() {
    $(window).resize(blockerResizeEvent);
}

function Blocker(div) {
    var instance = $('#'+div);
    this.parent = div;
    this.blocker = div+"_blocker";
    this.box = div+"_blocker_box";
    this.unblock = unblock;
    this.content = content;
    this.enableClose = enableClose;
    this.enableClose = disableClose;
    instance.append('<div id="'+this.blocker+'" class="screenBlocker" style="z-index: '+(instance.css('z-index')+max_z)+';left:'+instance.offset().left+'px;top:'+instance.offset().top+'px;height:'+instance.height()+'px;width:'+instance.width()+'px;"><div id="'+
                  this.box+'" class="screenBlockerBox" style="z-index: '+(instance.css('z-index')+max_z+1)+'"></div></div>');
    blockers[div]=this;
    return this;
}

/**
 *  Bloquea una capa por su id.
 */
function block(div_id, html) {
	console.log(div_id);
    blocker = new Blocker(div_id);
    if (html !== null) {
        blocker.content(html);
    } else {
        blockerResize(blocker.parent);
    }
    return blocker;
}

/**
 *  Quita el handler de la capa y de las capas hijas de la lista de handlers
 * y elimina la capa y las capas hijas.
 */
function unblock() {
    $('#'+this.blocker)
        .find("screenBlocker")
        .each( function() {
                var parent_id = $(this).parent().attr('id');
                blockers[parent_id]=null;
               });
    $('#'+this.blocker).remove();
    blockers.splice(this.parent, 1);
}

/**
 *  Establece el contenido de la capa de bloqueo
 */
function content(html, width, height) {
    var blocker = $('#'+this.box);
    blocker.html(html);
    if (width !== null) {
        blocker.width(width);
    }
    if (height !== null) {
        blocker.height(height);
    }
    blockerResize(this.parent);
}

/**
 *  Recalcula el tamaño de todas las layers de bloqueo
 */
function blockerResizeEvent() {
    for(blocker in blockers) {
        blockerResize(blocker);
    }
}

/**
 *  Cambia el tamaño del bloqueador y centra el contenido del mensaje
 */
function blockerResize(blocker) {
    if (blockers[blocker] !== null) {
        var id_blocker='#'+blockers[blocker].blocker;
        var parent = $('#'+blockers[blocker].parent);
        if ($(id_blocker).css('display')=='block') {
            $(id_blocker).css({'left':parent.offset().left, 'top':parent.offset().top, 'width':parent.width(),'height':parent.height()});
            var box = $('#'+blockers[blocker].box);
            var centroH = parent.width()/2;
            var desvioH = box.width()/2;
            box.css('left', centroH-desvioH);
            var centroV = parent.height()/2;
            var desvioV = box.height()/2;
            box.css('top', centroV-desvioV);
        }
    }
}

function enableClose() {
    $(this.box).append('<a id="screenBlocker_unblock" href="javascript:blockers["'+this.parent+'"].unblock();return false;">Cerrar</a>');
}

function disableClose() {
    $(this.box).remove("#screenBlocker_unblock");
}

var currentHash = '';

function uws_verify_status(formulario) {
	$.ajax({url: 'request.php',
				type: 'POST',
				data: 'action=login&username='+document.getElementById('username').value+'&password='+document.getElementById('password').value,
				processData : false,
				async: false,
				success: function(data) {
					if (uws_update_session_status()) {
						blockers['desktop_middle_box'].unblock();
					} else {
						$('#uws_div_relogin').html(data);
					}
				}
			});
	return false;
}


function uws_check_logged(url, params) {
	uws_update_session_status();
	if (!session_status) {
		var axd = document.createElement('a');
		axd.href = url;
		if (axd.pathname == basePath) {
			var url_reemplazada = "";
			url_reemplazada += axd.protocol ? axd.protocol + "//" : "";
			url_reemplazada += axd.hostname ? axd.hostname + basePath + "request.php" : "";
			url_reemplazada += axd.search + axd.hash;
			url = url_reemplazada;
		}
		var param_search = new String(axd.search);
		var param_hash = new String(axd.hash);
		var action_qry = '';
		if (typeof(params) == 'string') {
			action_qry = getParamFromString('action', params);
		} else {
			action_qry = params['action'];
		}
		if (!action_qry) action_qry = getParamFromString('action', param_search);
		if (!action_qry) action_qry = getParamFromString('action', param_hash);

		if ((action_qry == 'login') || (action_qry == 'passRecovery') || 
			(action_qry == 'passRecoverySend') || (action_qry == 'passRecoveryValidate')) {
			return true;
		} else {
			if (blockers['desktop_middle_box'] == null) {
				blocker = block('desktop_middle_box');
				blocker.content('<div id="uws_div_relogin" style="opacity: 1;"></div>');
				$("#uws_div_relogin").load("request.php", "action=login&onlineverify=1", function (responseText, textStatus, xhr) {
																if (xhr.status == "error") {
																	blocker.content(xhr.status + " " + xhr.statusText);
																	blocker.enableClose();
																}
															});
			}
			return false;
		}
	}else return true;
}

/**
 * Carga el resultado de invocar a la url especificada con los parámetros indicados en el
 * div que se llama como el parámentro div. También si ya existe un bloqueo vigente se
 * cambia el contenido del mensaje al de "Cargando..."
 */
function uws_load(url, params, div, block_id) {
	if (!(uws_back_timer == undefined))
		clearTimeout(uws_back_timer);
	if (!(uws_countdown_timer == undefined))
		clearTimeout(uws_countdown_timer); 
	
    var blocker;
	url = url.replace('index.php', 'request.php');
	url = url.replace('/?', '/request.php?');
	if (url.substr(-1,1) == '/') url += 'request.php';
	
	if (uws_check_logged(url, params)) {
		if (block_id == undefined) blocker = block(div);
		else blocker = block(block_id);
		blocker.content('<img src="images/wait.gif" alt=""/> Cargando...');	
		$("#"+div).load(url, params, function(responseText, textStatus, xhr) {
											if (xhr.status == "error") {
												blocker.content(xhr.status + " " + xhr.statusText);
												blocker.enableClose();
											} else {
												blocker.unblock();
											}
											$(".form_datepicker").each(function(){
												$(this).datepicker({dateFormat:$(this).attr('format')});
											});
									});
/*		$.ajax(url, {data: params, 
					type: 'POST', 
					success: function(responseText, textStatus, xhr) {
											if (xhr.status == "error") {
												blocker.content(xhr.status + " " + xhr.statusText);
												blocker.enableClose();
												return;
											} else {
												blocker.unblock();
											}
											var doc = document.getElementById(div);
											var frag = document.createDocumentFragment();
											$(doc).html();
											doc.appendChild(frag);
											$(".form_datepicker").each(function(){
												$(this).datepicker({dateFormat:$(this).attr('format')});
											});
									}});*/
		currentHash = '';
		if (typeof(params) != 'string') {
			for (var x in params) {
				currentHash += x + '=' + params[x] + '&';
			}
		} else {
			currentHash = params;
		}
		if (currentHash != "") {
			var newVal = "";
			while (newVal != currentHash) {
				newVal = currentHash;
				currentHash = currentHash.replace(/\&\&/, '&');
			}
			while (currentHash.lastIndexOf('&') == (currentHash.length - 1))
				currentHash = currentHash.substr(0, currentHash.length - 1);
			window.open('#' + currentHash, '_self');
		}
	}
	return false;
}

var basePath = '';

function uws_initializePage() {
	//Se inicializa path base de la aplicación
	var a = document.createElement('a');
	a.href='#';
	basePath = a.pathname.substr(0,a.pathname.lastIndexOf('/')+1);
		
	
	var urlCompleto = new String(document.location);
	var urlSeparado = urlCompleto.split("#");
	if (urlSeparado.length > 1) {
		currentHash = urlSeparado[1];
		uws_load(urlSeparado[0], currentHash, 'desktop_center_content');
	} else {
		currentHash = "";
	}
	uws_checkHash();
}

function uws_checkHash() {
	var urlCompleto = document.location.toString();
	var urlSeparado = urlCompleto.split("#");
	if (urlSeparado.length > 1) {
		if (!(urlSeparado[1] == currentHash)) {
			if (urlSeparado[0].substr(-1,1)=='/') {
				urlSeparado[0]+='request.php';
			}
			uws_load(urlSeparado[0], urlSeparado[1], 'desktop_center_content');
		}
	} else {
		if (currentHash != "") {
			uws_load('request.php', '', 'desktop_center_content');
		}
	}
	setTimeout(uws_checkHash, 300);
}

function uws_reload_content () {
	var urlCompleto = new String(document.location);
	var urlSeparado = urlCompleto.split("#");
	if (urlSeparado.length > 1) {
		uws_load(urlSeparado[0], urlSeparado[1], 'desktop_center_content');
	} else {
		if (currentHash != "") {
			window.open(document.location, "_self");
			return false;
		}
	}
	uws_checkHash();
}

var uws_extra_params = {};
function uws_setExtraParams(params) {
	uws_extra_params = $.extend(uws_extra_params, params);
	return true;
}


function getSelectionStart(o) {
	if (o.createTextRange) {
		var r = document.selection.createRange().duplicate()
		r.moveEnd('character', o.value.length)
		if (r.text == '') return o.value.length
		return o.value.lastIndexOf(r.text)
	} else 
		return o.selectionStart
}

function getSelectionEnd(o) {
	if (o.createTextRange) {
		var r = document.selection.createRange().duplicate()
		r.moveStart('character', -o.value.length)
		return r.text.length
	} else 
		return o.selectionEnd
} 

/**
 * Función auxiliar utilizada por el framework de eventos.
 */
function eventTrue() {
	return {ajax : true, ret : true};
}

/**
 * Esta función se ideó para articular el refresco por ajax de los componentes de un formulario.
 * Puede no ser la más linda, pero para los tiempos que manejamos es un lujo.
 */
function uws_ajax_replace(_realEvent, _realObject, _id, _event, _target, _verificationFunctions) {
	var component = $('#'+_id);
	var approved = new Array();
	var retValue = true;
	for(var v=0; v < _verificationFunctions.length; v++) {
		var resp = window[_verificationFunctions[v]](_realEvent, _realObject);
		if (resp['ajax']) {
			approved.push(v);
		}
		retValue = retValue && resp['ret'];
	}
	if (approved.length <= 0) return retValue;
	var form = component.parents('form');
    var url = form.attr('action');
    url = url.replace('index.php', 'request.php');
	url = url.replace('/?', '/request.php?');
	
	var axd = document.createElement('a');
    axd.href = url;
	if (axd.pathname == basePath) {
		var url_reemplazada = "";
		url_reemplazada += axd.protocol ? axd.protocol + "//" : "";
		url_reemplazada += axd.hostname ? axd.hostname + basePath + "request.php" : "";
		url_reemplazada += axd.search + axd.hash;
		url = url_reemplazada;
	}
    var method = form.attr('method');
	var params = form.serialize();
	for(property in uws_extra_params) {
		params +='&'+property+'='+uws_extra_params[property];
	}
	params += '&UWS_EVENT='+_event+'&UWS_EVENT_TARGET='+component.attr('name')+'&UWS_EVENT_VERIFIED=';
	for(key in approved) {
		params += key+',';
	}
	params = params.substr(0, params.length-1);
    var blocker;
	var extra_params = {'async':false,
                        'data':params, 
                        'dataType':'html', 
                        'type':method, 
                        'success':function(responseText, status, xhr) {
									var globalhtml = $(responseText);

									var fieldsets = globalhtml.find('fieldset');
									for (var f=0;f<fieldsets.length;f++) {
										var fieldset = $(fieldsets[f]);
										if ((fieldset.attr('id') != undefined)&&(fieldset.attr('id') != '')) {
											$('#'+fieldset.attr('id')).replaceWith(fieldset);
										}
									}
									var inputs = globalhtml.find('input[type!="radio"][type!="checkbox"]');
									for (var i=0;i<inputs.length;i++) {
										var input = $(inputs[i]);
										if ((input.attr('id') != undefined)&&(input.attr('id') != '')) {
											$('#'+input.attr('id')).replaceWith(input);
										}
									}
									var textareas = globalhtml.find('textarea');
									for (var t=0;t<textareas.length;t++) {
										var textarea = $(textareas[t]);
										if ((textarea.attr('id') != undefined)&&(textarea.attr('id') != '')) {
											$('#'+textarea.attr('id')).replaceWith(textarea);
										}
									}
									var selects = globalhtml.find('select');
									for (var s=0;s<selects.length;s++) {
										var select = $(selects[s]);
										if ((select.attr('id') != undefined)&&(select.attr('id') != '')) {
											$('#'+select.attr('id')).replaceWith(select);
										}
									}
                                    blocker.unblock();
                                 },
                        'error':function(responseText, status, xhr) {
                                    blocker.content(xhr.status + " " + xhr.statusText);
                                    blocker.enableClose();
                                },
                        'timeout':3000
                       };
	//Busco el primer div con ID asignado
    var div = form.parents('div');
	while (div != undefined) {
		if (div.attr('id')!=undefined) break;
		else div = div.parents('div');
	}
	div = div.attr('id');
	
    blocker = block(div);
    blocker.content('<img src="images/wait.gif" alt=""/> Cargando...');
	
	$.ajax(url,extra_params);
	return retValue;
}

function getParamFromString(param, str) {
	if (str[0] == '?')
		str = str.slice(1);
	
	var aStr = str.split('&');
	for (var fullvalue in aStr) {
		if (aStr[fullvalue].split('=')[0] == param) {
			return aStr[fullvalue].split('=')[1];
		}
	}
	return false;
}

/**
 * Esta función recibe un formulario (obligatorio), lo envía en background y vuelca el resultado en el div que se indique.
 * @param object _form el objeto formulario. Generalmente se pasa a través del puntero this.
 * @param string div el identificador (id) del div que recibirá el contenido que resulte del llamado AJAH.
 * @param int block_id el identificador de bloqueo en el caso que esta operación deba "rehabilitar" un bloqueo previo.
 * 
 * @return false La función retorna siempre false para que al emplearla en el onsubmit="" de un formulario pueda cancelarse el envío del mismo.
 * TODO: contempras enctype, accept y accept-charset
 */
function uws_submit (_form, validations, div, block_id, extra) {
	if (!(uws_back_timer == undefined))
		clearTimeout(uws_back_timer);
	if (!(uws_countdown_timer == undefined))
		clearTimeout(uws_countdown_timer); 
	
    var form = $(_form);
    var url = form.attr('action');
    url = url.replace('index.php', 'request.php');

	var axd = document.createElement('a');
	//action_del_url = "";
    axd.href = url;
	if (axd.pathname == basePath) {
		var url_reemplazada = "";
		url_reemplazada += axd.protocol ? axd.protocol + "//" : "";
		url_reemplazada += axd.hostname ? axd.hostname + basePath + "request.php" : "";
		url_reemplazada += axd.search + axd.hash;
		url = url_reemplazada;
		
	}
	var param_search = new String(axd.search);
	var param_hash = new String(axd.hash);
    var method = form.attr('method');
    var blocker;

    //Busco el primer div con ID asignado
    if (div == undefined) {
        //Idealmente (si JQuery anduviera bien, sería algo como form.parent('div[id]').attr('id') pero la posta es que JQuery tiene BUG.
        div = form.parent('div');
        while (div != undefined) {
            if (div.attr('id')!=undefined) break;
            else div = div.parent('div');
        }
        div = div.attr('id');
    }
    
    if (validations != undefined) {
        var validations_ok = uws_validate(_form, validations);
		if (validations_ok != true) return false;
    }
	
	var files = form.find("input").is("[type='file']");
	if (files) {
		form.attr('target', 'multipropouseIFrame');
		form.attr('action', url);
		form.append('<input type="hidden" name="UWS_IFRAME" value="'+div+'">');
		return true;
	}
	var params = form.serialize();
	for(property in uws_extra_params) {
		params +='&'+property+'='+uws_extra_params[property];
	}
	uws_extra_params = {};
	var extra_params = {'async':false,
						'data':params, 
						'dataType':'html', 
						'type':method, 
						'success':function(responseText, status, xhr) {
									$('#'+div).html(responseText);
									blocker.unblock();
								},
						'error':function(responseText, status, xhr) {
									blocker.content(xhr.status + " " + xhr.statusText);
									blocker.enableClose();
								},
						'timeout':3000
					};
	action_qry = getParamFromString('action', params);
	if (!action_qry) action_qry = getParamFromString('action', param_search);
	if (!action_qry) action_qry = getParamFromString('action', param_hash);
	uws_update_session_status();
	if ((!session_status) && (action_qry != 'login') && (action_qry != 'passRecovery') && (action_qry != 'passRecoverySend') && (action_qry != 'passRecoveryValidate')) {
		if (blockers['desktop_middle_box'] == null) {
			blocker = block('desktop_middle_box');
			blocker.content('<div id="uws_div_relogin" style="opacity: 1;"></div>');
			$("#uws_div_relogin").load("request.php", "action=login&onlineverify=1", function (responseText, textStatus, xhr) {
															if (xhr.status == "error") {
																blocker.content(xhr.status + " " + xhr.statusText);
																blocker.enableClose();
															}/* else {
																blocker.unblock();
															}*/
														});
		}
	} else {
    
		if (block_id == undefined) blocker = block(div);
		else blocker = block(block_id);
		blocker.content('<img src="images/wait.gif" alt=""/> Cargando...');
		//Verifico si hay archivos involucrados no puedo llamar por AJAX tradicional
		//sino que lo emulo con un iFrame
		
		$.ajax(url,extra_params);
	}
    return false;
}

function uws_change_rows_per_page(element, cant_rows) {
	uws_setExtraParams({'uws_page': 1}); 
	uws_setExtraParams({'uws_current_page': 1}); 
	var form_weblist = document.getElementById('form_weblist');
	
	var uws_page_rows = document.getElementById('uws_page_rows');
	if (uws_page_rows) {
		uws_page_rows.value = cant_rows;
	}
	form_weblist.onsubmit(); 
	$('#list_uws_page_per_row > .uws_page_per_row').each(function (index) {$(this).removeClass("uws_page_per_row_selected").addClass("uws_page_per_row_unselected");});
	$('#'+element.id).addClass("uws_page_per_row_selected").removeClass("uws_page_per_row_unselected");
	return false;
}

function uws_submit_with_location (_form, validations, div, block_id, extra) {
	var form = $(_form);
    var url = form.attr('action');
    url = url.replace('index.php', 'request.php');

	var axd = document.createElement('a');
    axd.href = url;
	if (axd.pathname == basePath) {
		var url_reemplazada = "";
		url_reemplazada += axd.protocol ? axd.protocol + "//" : "";
		url_reemplazada += axd.hostname ? axd.hostname + basePath + "request.php" : "";
		url_reemplazada += axd.search + axd.hash;
		url = url_reemplazada;
	}
	var params = form.serialize();
	for(property in uws_extra_params) {
		//if ((property != "uws_list_action") && (uws_extra_params[property] != ''))
		params +='&'+property+'='+uws_extra_params[property];
	}
	var paramstringcin = '';
	var paramcitos = params.split("&");
	for (i = 0; i < paramcitos.length; i++) {
		paramcin = paramcitos[i];
		var splitcin = paramcin.split("=");
		if (splitcin.length > 1) {
			if ((splitcin[0] != 'uws_list_action') && (splitcin[1] != '')) {
				paramstringcin += '&' + paramcin;
			}
		}
	}
	
	var urlSeparado = url.split("?");
	if (urlSeparado.length > 1) {
		var accioncina = urlSeparado[1]
		var urlSeparado2 = accioncina.split("=");
		if ((urlSeparado2.length > 1) && (urlSeparado2[0] == "action")) {
			paramstringcin = accioncina + '&' + paramstringcin;
			currentHash = paramstringcin;
			var newVal = "";
			while (newVal != currentHash) {
				newVal = currentHash;
				currentHash = currentHash.replace(/\&\&/, '&');
			}
			while (currentHash.lastIndexOf('&') == (currentHash.length - 1))
				currentHash = currentHash.substr(0, currentHash.length - 1);
			window.open('#' + currentHash, '_self');
		}
	}
	
	
	//windown
	return uws_submit (_form, validations, div, block_id, extra);
}

function uws_moveContent(div) {
	var body = $('#multipropouseIFrame').contents().find('body');
	body.find("#UWS_RETURN_SCRIPT").remove();
	$('#'+div).html(body.html());
	var blocker = blockers[div];
	blocker.unblock();
}

var filters = {"alpha" : uws_alpha, 
				"numeric" : uws_numeric, 
				"alphanumeric" : uws_alphanumeric, 
				"mail" : uws_mail, 
				"required" : uws_required, 
				"regexp" : uws_regexp, 
				"min" : uws_min, 
				"max" : uws_max, 
				"float" : uws_float, 
				"minvalue" : uws_minvalue, 
				"maxvalue" : uws_maxvalue,
				"mac" : uws_mac,
				"ip" : uws_ip,
				"url" : uws_url,
				"precision" : uws_precision,
				"scale" : uws_scale
				};

function uws_validate(frm, adds) {
    var ret = true;
	$(frm).find('.form_dynamic_error').remove();
    $(frm).find('.validate').each(function () {
										var comp = $(this);
										var result = uws_validate_this(this, adds);
                                        if (result != true) {
												var off = comp.offset();
												var poff = comp.parent().parent().offset();
												comp.parent().append('<div class="form_dynamic_error"><span style="margin-left:'+(off.left-poff.left)+'px">'+result+'</span></div>');
                                                ret = false;
                                        }
                            });

    return ret;
}

function uws_validate_this(obj, adds) {
    var me = $(obj);
    var ok = true;
    var message = "";
    for(filter in filters) {
        if (me.hasClass(filter)) {
			var fld = '';
			if (obj.type == 'fieldset') {
				fld = me.find('input').first().attr('name').toString().replace('[]', '');
			} else {
				fld = me.attr('name').toString().replace('[]', '');
			}
			
            ok = filters[filter](obj, adds[fld]);
            if (ok != true) {
				message += ok+'<br/>';
            }
        }
    }
    if (message=="") return true;
    else return message;
}

/*
 * Validaciones:
 *      Cada función es una validación. Toman el objeto a validar, el cual es un HTMLObject de un formulario y opciones adicionales que
 *      pueden o no serle útiles.
 */
function uws_alpha(obj, options){
        var patt1 = new RegExp("^[(a-z|A-Z|\\s)]*$");
        if (patt1.test(obj.value)) {
			return true;
		} else {
			return '"'+obj.value+'" no es un valor alfabético, verifique que no tenga símbolos ni números';
		}
}
function uws_alphanumeric(obj, options){
        var patt1 = new RegExp("^[(0-9|a-z|A-Z|\\s)]*$");
        if (patt1.test(obj.value)) {
			return true;
		} else {
			return '"'+obj.value+'" no es un valor alfanumérico, verifique que no tenga símbolos';
		}
}
function uws_mail(obj, options){
        var patt1 = new RegExp("^[a-zA-Z0-9]+(.[a-zA-Z0-9_-]+|[a-zA-Z0-9_-]+)*@[a-z0-9][\\w\\.-]*[a-z0-9]\\.[a-z][a-z\\.]*[a-z]$|^$");
        if (patt1.test(obj.value)) {
			return true;
		} else {
			return '"'+obj.value+'" no es una dirección de mail válida';
		}
}
function uws_numeric(obj, options){
        var patt1 = new RegExp("^[+-]?\\d*$");
        if (patt1.test(obj.value)) {
			return true;
		} else {
			return '"'+obj.value+'" no es un valor entero';
		}
}
function uws_float(obj, options){
        var patt1 = new RegExp("^([+-]?((([0-9]+[\\,\\.]?)|([0-9]*[\\,\\.][0-9]+))))$|^$");
        if (patt1.test(obj.value)) {
			return true;
		} else {
			return '"'+obj.value+'" no es un valor decimal, verifique que no tenga símbolos, ni letras';
		}
}
function uws_precision(obj, options) {//precision
	if (obj.type != 'fieldset') {
		var patt1 = new RegExp("^([+-]?(((\\d{0," + options['precision'] + "}[\\,\\.]?)|(\\d{0," + options['precision'] + "}[\\,\\.][0-9]+))))$|^$");
		if (patt1.test(obj.value)) {
			return true;
		} else {
			return '"'+obj.value+'" no cumple tener a lo sumo "'+ options['precision'] +'" dígitos en su parte entera';
		}
	} else return true;
}
function uws_scale(obj, options) {
	if (obj.type != 'fieldset') {
		if (options['scale'] != 0) {
			var patt1 = new RegExp("^([+-]?(((\\d+[\\,\\.]?)|(\\d*[\\,\\.](\\d{0," + options['scale'] + "})))))$|^$");
			if (patt1.test(obj.value)) {
				return true;
			} else {
				return '"'+obj.value+'" no cumple tener a lo sumo "'+ options['scale'] +'" dígitos en su parte decimal';
			}
		} else {
			return uws_numeric(obj, options);
		}		
	} else return true;
}
function uws_required(obj, options){
        switch(obj.type) {
                case "text":
                case "textarea":
                case "password":
                        if (obj.value.length > 0) {
							return true;
						} else {
							return "Se requiere que ingrese un valor";
						}
                        break;
                case 'select-multiple':
                case 'select-one':
                        var cant_sel = uws_cant_opts_selected(obj);
                        if (cant_sel > 0) {
							return true;
						} else {
							return "Debe seleccionar al menos una opción";
						}
                        break;
				case 'fieldset'://Agregador soporte de grupos de checkbox's'
						if (($(obj).hasClass('uws_is_radio')) || ($(obj).hasClass('uws_is_checkbox'))) {
							var selecteds = $(obj).find('input:checked').length;
							if (selecteds >= 1) {
								return true;
							} else {
								return "Debe seleccionar al menos una opción";
							}
						} else {
							return false;
						}
                        break;
                default:
                        return false;
        }
}
function uws_regexp(obj, options) {
        for (expi in options) {
                if (expi == "regexp") {
                        //for (expes in options["regexp"]) {
								//var expression = options["regexp"][expes];
								var expression = options["regexp"];
								var pattern, message;
								var opentag = expression.substr(0, 1);
								var lasttag = expression.indexOf(opentag,1);
								while (expression.substr(lasttag-1,1) == "\\") {
									lasttag = expression.indexOf(opentag,lasttag+1);
								}
								pattern = expression.substr(1, lasttag-1);
								message = expression.substr(lasttag+1);
                                var patt1 = new RegExp(pattern);
                                if (!(patt1.test(obj.value))) return message.format('', obj.value, pattern);//return false;
                        //}
                }
        }
        return true;
}

function uws_max(obj, options) {
        switch(obj.type) {
                case "text":
                case "textarea":
                case "password":
                        if (obj.value.length <= options['max']) {
							return true;
						} else {
							return "El valor no puede tener más de "+options['max']+" caracteres";
						}
                        break;
                case 'select-multiple':
                case 'select-one':
                        var cant_sel = uws_cant_opts_selected(obj);
                        if (cant_sel <= options['max']) {
							return true;
						} else {
							return "No puede elegir más de "+options['max']+" opciones";
						}
                        break;
				case 'fieldset'://Agregador soporte de grupos de checkbox's'
						if ($(obj).hasClass('uws_is_checkbox')) {
							var selecteds = $(obj).find('input:checked').length;
							if (selecteds <= add['max']) {
								return true;
							} else {
								return "No puede seleccionar más de "+add['max']+" opcion(es)";
							}
						} else {
							return false;
						}
                        break;
                default:
                        return false;
        }
}


//TODO: cambiar esto con jquery
function uws_cant_opts_selected(selecs) {
	opts = selecs.getElementsByTagName('option');
	var cant = 0;
	for (i = 0; i < opts.length; i++) {
		if ((opts[i].selected) && (opts[i].value != "")){
			cant++;
		}
	}
	return cant;
}

function uws_min(obj, add) {
        switch(obj.type) {
                case "text":
                case "textarea":
                case "password":
                        if ((obj.value.length >= add['min']) || (obj.value.length == 0)) {
							return true;
						} else {
							return "El valor debe tener al menos "+add['min']+" caracteres";
						}
                        break;
                case 'select-multiple':
                case 'select':
                        var cant_sel = uws_cant_opts_selected(obj);
                        if (cant_sel >= add['min']) {
							return true;
						} else {
							return "Debe elegir al menos "+add['min']+" opcion(es)";
						}
                        break;
				case 'fieldset'://Agregador soporte de grupos de checkbox's'
						if ($(obj).hasClass('uws_is_checkbox')) {
							var selecteds = $(obj).find('input:checked').length;
							if (selecteds >= add['min']) {
								return true;
							} else {
								return "Debe seleccionar al menos "+add['min']+" opcion(es)";
							}
						} else {
							return false;
						}
                        break;
                default:
                        return false;
        }
}

function uws_minvalue(obj, add) {
        switch(obj.type) {
                case "text":
                        if (obj.value >= add['min']) {
							return true;
						} else {
							return "El valor mínimo admitido es "+add['min'];
						}
                        break;
                default:
                        return false;
        }
}

function uws_maxvalue(obj, add) {
        switch(obj.type) {
                case "text":
                        if (obj.value <= add['max']) {
							return true;
						} else {
							return "El valor máximo admitido es "+add['max'];
						}
                        break;
                default:
                        return false;
        }
}

function uws_mac(obj) {
	var mac_validas = /^[0-9a-fA-F]{12}$|^([0-9a-fA-F]{2}(([:-]|$))){6}$|([0-9a-fA-F]{4}([.]|$)){3}$|^$/;
	if (mac_validas.test(obj.value)) {
		return true;
	} else {
		return 'La MAC-ADDRESS "'+obj.value+'" es inválida, ej: 5475d02aa80b o IEEE 802 std.';
	}
}

function uws_ip(obj) {
	var ip_valida = /^((25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\.){3}(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)$|^$/;
	if (ip_valida.test(obj.value)) {
		return true;
	} else {
		return 'La IP "'+obj.value+'" es inválida, ej: 192.168.0.1';
	}
}

function uws_url(obj) {
	var url_valida = /^(?:(?:ht|f)tp(?:s?)\:\/\/|~\/|\/)?(?:\w+:\w+@)?(?:(?:[-\w]+\.)+(?:com|org|net|gov|mil|biz|info|mobi|name|aero|jobs|museum|travel|[a-z]{2}))(?::[\d]{1,5})?(?:(?:(?:\/(?:[-\w~!$+|.,=]|%[a-f\d]{2})+)+|\/)+|\?|#)?(?:(?:\?(?:[-\w~!$+|.,*:]|%[a-f\d{2}])+=?(?:[-\w~!$+|.,*:=]|%[a-f\d]{2})*)(?:&(?:[-\w~!$+|.,*:]|%[a-f\d{2}])+=?(?:[-\w~!$+|.,*:=]|%[a-f\d]{2})*)*)*(?:#(?:[-\w~!$+|.,*:=]|%[a-f\d]{2})*)?$|^$/;
	if (url_valida.test(obj.value)) {
		return true;
	} else {
		return 'La URL "'+obj.value+'" es inválida.';
	}
}

var session_status;
function uws_update_session_status() {
	$.ajax({url: 'session_status.php',
				async: false,
				processData : false,
				success: function(data) {if (data == "true") {session_status = true;} else {session_status = false;}}
			});
	return session_status;
}

/* Funciones genéricas */
function toggle(_elem, _class) {
	/* en un par de años: _elem.classList.toggle(_class); */
	var reg = new RegExp('(?:^|\\s)'+_class+'(?!\\S)');
	if ( _elem.className.match(reg) != null ) {
		_elem.className =  _elem.className.replace( reg , '' );
	} else {
		_elem.className += ' '+_class;
	}
}

function hasStyle(_elem, _class) {
	var reg = new RegExp('(?:^|\\s)'+_class+'(?!\\S)');
	return _elem.className.match(reg) != null;
}

function setStyle(_elem, _class) {
	var reg = new RegExp('(?:^|\\s)'+_class+'(?!\\S)');
	if ( _elem.className.match(reg) == null ) {
		_elem.className += ' '+_class;
	}
}

function unsetStyle(_elem, _class) {
	var reg = new RegExp('(?:^|\\s)'+_class+'(?!\\S)');
	if ( _elem.className.match(reg) != null ) {
		_elem.className = _elem.className.replace( reg , '' );
	}
}

function viewport() {
	var e = window, a = 'inner';
	if ( !( 'innerWidth' in window ) ) {
		a = 'client';
		e = document.documentElement || document.body;
	}
	return {width : e[ a+'Width' ] , height : e[ a+'Height' ]}
}

function AddEvent(element, type, handler) {
	if (element.addEventListener) element.addEventListener(type, handler, false);
	else element.attachEvent("on"+type, handler);
}

function RemoveEvent(element, type, handler) {
	if (element.addEventListener) element.removeEventListener(type, handler, false);
	else element.detachEvent("on"+type, handler);
}

function fireEvent(element,event){
    if (document.createEventObject){
        // dispatch for IE
        var evt = document.createEventObject();
        return element.fireEvent('on'+event,evt)
    }
    else{
        // dispatch for firefox + others
        var evt = document.createEvent("HTMLEvents");
        evt.initEvent(event, true, true ); // event type,bubbling,cancelable
        return !element.dispatchEvent(evt);
    }
}

function redraw(element){
    var n = document.createTextNode(' ');
    element.appendChild(n);
    (function(){n.parentNode.removeChild(n)}).defer();
    return element;
  }
