<?

/*
 * @author Federico Bernoldi
 * 
 * Procesador de requests de reseteo de password a través del gadget
 * 
 */

ini_set("session.use_cookies", "0");
session_start();
require_once 'retro_functions.php';
require_once 'lib/Twig/Autoloader.php';
require_once 'lib/krumo/class.krumo.php';
Twig_Autoloader::register();
require_once "iplan/security/Application.php";
require_once 'iplan/models/provisioning/ProvisioningIUNI.php';
require_once 'iplan/models/provisioning/ProvisioningPlataformas.php';
require_once "iplan/models/provisioning/passwords/PasswordsFunctions.php";

$_SESSION['uws_provider_id']= 1;//1=IPlan; 2=Localhostero
$_SESSION['uws_domain_id']  = 1;//1=iuniwholesale.iplantech.com.ar ; 2=localhost/wholesale/
//$_SESSION['uws_user_id']    = 1;//141=Admin Wholesale ; 101=Admin Localhostero

chdir("iplan/models/provisioning/");
require_once 'LogMessages.php';
chdir("../../../");

$application = Application::getInstance();
$context = $application->getContext();
$orm = $application->getORM();
	
//Traigo la Conexion
$dbconn = $orm->getDatabase()->getConnection();
//Traigo el usuario q ejecuta los packages
$userEjecutaPackages = Application::getInstance()->getContext()->getUser()->getId();
//Traigo la instancia de LOG
$log = LogMessages::GetInstance($dbconn, $userEjecutaPackages, LogMessages::SYS_WSP);
//Seteo los mensajes que hay en la databse
LogMessages::getMensajes();

$proceso_id = null;
$params = array("p_user_id" => (int)$userEjecutaPackages, "p_estado" => 3);
$result = null;
$lala = $dbconn->executeFunction("PKG_CAP_PROCESOTASKS.FU_PROCESOTASKS_INS", $params, $result, Connection::T_CURSOR);
$asd = $dbconn->fetch($lala);
$dbconn->free($lala);
if ( (!is_array($asd)) || (( isset($asd["SQLCODE_ERROR"])) && ($asd["SQLCODE_ERROR"] != "200")) ) {
	$desc = LogMessages::erroresArray($asd) . " P: " . LogMessages::erroresArray($params);
	$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CAF, 5, "PKG_CAP_PROCESOTASKS.FU_PROCESOTASKS_INS [$desc]");
	return new SoapFault("Server", "Hubo un error al procesar el pedido", "Server", "El servicio no puede generar un registro de proceso para la operación");
} else {
	$proceso_id = $asd["LASTID"];
}

$_SESSION["WS_PROCESO_ID"] = $proceso_id;
$_SESSION["WS_USER_EJECUTA_PACKAGES"] = $userEjecutaPackages;

//$rsc = fopen("tmp/AvamarService.log", "a+");

$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CAF, 0, "Remote Address: " . $_SERVER['REMOTE_ADDR']);

$headers = apache_request_headers();
if ($headers) {
	foreach($headers as $key => $header) {
		$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CAF, 0, "Header - $key: $header");
	}
}

/* Capturo el request */
$request = file_get_contents("php://input");

/* Creo el objeto de plataformas */
$servicePlataformas = new ProvisioningPlataformas($dbconn, $log, $userEjecutaPackages, $proceso_id, null, null);

/* Guardo el mensaje de request */
$servicePlataformas->saveLastXMLMessages(array("33" => $request));

/* Capturo la salida */
ob_start();

$mail = $context->getParam("mail", null);
$tipo = $context->getParam("SIP", "WEB");
$tipo = ($tipo == "WEB") ? $tipo : "SIP";

$aParams = array();

$aParams["tipo_text"] = $tipo;
$aParams["isIplan"] = true;

if ($mail) {
	//Mail no enviado
	try {
		$resultado_Reset = resetPassword_SIP_WEB_Confirm_iplan($mail, $tipo);
		if (!$resultado_Reset) {
			$aParams["mail_invalido"] = true;
		}
	} catch (Exception $e) {
		$aParams["error_ejecucion"] = true;
		$aParams["error_descripcion"] = $e->getMessage();
	}

	if ($resultado_Reset) {
		$aParams["usuarios"] = implode(", ", $resultado_Reset);
	}
}

echo $application->parse("lib/password_result_confirm_iplan.xhtml", $aParams);

/* Guardo la salida */
$servicePlataformas->saveLastXMLMessages(array("34" => ob_get_contents()));

/* Sigo como si nada hubiera sido capturado */
ob_end_flush();

?>
