<?php

require_once 'retro_functions.php';
require_once 'lib/Twig/Autoloader.php';
Twig_Autoloader::register();

require_once 'iplan/database/OracleConnection.php';
require_once 'iplan/orm/MigrationToolkit.php';
require_once 'iplan/security/Facade.php';

$from = new ORM();
$from->setDatabase( new OracleDatabase( new OracleConnection('ADMIN_IUNI', 'wholesale2010', 'SSWMC') ) );
$to = new ORM();
$to->setDatabase( new OracleDatabase( new OracleConnection('ADMIN_IUNI', 'wholesale2010', 'AUTOPROPDBT') ) );


$facadeAlias = "AutoProvisioning";
$providerAlias = "IPlan S.A.";

$mt = new MigrationToolkit();
$mt->setOrigin($from);
$mt->setDestination($to);
$mt->addClass('Facade', 'alias',array( array('alias', '=', $facadeAlias) ), 'providers, actions, module');
$mt->addClass('Action', 'urlCode',array( array('facade.alias', '=', $facadeAlias) ), 'profiles');
$mt->defineClass('Provider', 'name');
$mt->addClass('Profile', 'name, provider.name',array(	array('actions.facade.alias', '=', $facadeAlias), 
														array('provider.name', '=', $providerAlias)
													), 'menus, users');
$mt->addClass2('Menu', 'name, parent.name, provider.name', function (ORMQuery &$q) use ($facadeAlias, $providerAlias) {
												  $q->filterBy('provider.name', '=', $providerAlias)
													->startGroup()
														->filterBy('action.facade.alias', '=', $facadeAlias, null, 'OR')
														->filterBy('submenus.action.facade.alias', '=', $facadeAlias, null, 'OR')
													->endGroup()
													->dontWorryAbout('action', 'action.facade')
													->dontWorryAbout('submenus', 'submenus.action', 'submenus.action.facade')
													->orderBy('parent DESC', 'order ASC')
													;
											},'links, submenus');
		
$mt->execute('tmp/log10.xml');
?>
