<?php

date_default_timezone_set('America/Buenos_Aires');
ini_set("soap.wsdl_cache_enabled", "0");


session_start();
require_once 'retro_functions.php';
require_once 'lib/Twig/Autoloader.php';
require_once 'lib/krumo/class.krumo.php';
Twig_Autoloader::register();
require_once "iplan/security/Application.php";


require_once 'iplan/security/AbstractManager.php';
require_once 'iplan/security/Renderable.php';
require_once 'iplan/security/ApplicationContext.php';
require_once 'iplan/models/provisioning/Log.php';
require_once 'iplan/models/provisioning/Process.php';
require_once 'iplan/models/provisioning/ProvisioningPlataformas.php';

// Bouml preserved body begin 00149F85
date_default_timezone_set('America/Buenos_Aires');
//Aca hay cosas de Log
require_once 'iplan/models/provisioning/LogMessages.php';
//Traigo la instancia de ORM
$orm = ORM::getInstance();
//Seteo la database a ORACLE

//Maqueta
$connLog = new OracleConnection("172.16.213.28", 1521, "sswmc", "ADMIN_IUNI", "wholesale2010", "ADMIN_IUNI", OCI_DEFAULT);
$connLog->connect();
//Produccion
$connRead = new OracleConnection("172.20.91.29", 1521, "IUNIWS", "southward", "southward123.!");
$connRead->connect();
//Dataguard
$connWrite = new OracleConnection("172.16.57.25", 1521, "AUTOPROPDB_dguard", "southward", "southward123.!");
$connWrite->connect();
/*$connWrite = $connWrite;
$connRead = $connProduccion;
$connLog*/

$orm->setDatabase(new OracleDatabase($connLog));

//Traigo el usuario q ejecuta los packages
$userEjecutaPackages = Application::getInstance()->getContext()->getUser()->getId();

//Traigo la instancia de LOG, logueo en la maqueta
$log = LogMessages::GetInstance($connLog, $userEjecutaPackages);
//Seteo los mensajes que hay en la databse
LogMessages::getMensajes();
//Logueo el Inicio de las pruebasPKG_WEB_LINEAS.FU_LINEAS_SEL
$log->addLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_WB, 0, 'Inicio las Pruebas de Migracion MAIL/DNS');

set_error_handler("miGestorErrores");






//Tabla SUBSCRIPTION_ATTRIBUTES
$log->addLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_WB, 0, "TABLA SUBSCRIPTION_ATTRIBUTES");

$result = null;
$params = array();
$rst_subsattr = $connRead->executeFunction("PKG_MIGRADOR.SUBSCRIPTION_ATTRIBUTES_SEL", $params, $result, Connection::T_CURSOR);

while ($aSubsAttr = $connRead->fetch($rst_subsattr)) {
	//$log->addLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_WB, 0, "Leido: ID [" . $aCliente["CLIENTE_ID"] . "] Rz [" . $aCliente["RAZON_SOCIAL"] . "]" );
	//Inserto
	$result = null;
	$params = array("p_subscriptionid" => $aSubsAttr["SUBSCRIPTIONID"], 
					"p_domain" => $aSubsAttr["DOMAIN"], 
					"p_accountqty" => $aSubsAttr["ACCOUNTQTY"], 
					"p_accountsize" => $aSubsAttr["ACCOUNTSIZE"], 
					"p_tasktype" => $aSubsAttr["TASKTYPE"]
					);
	
	$rst_subsattr_alta = $connWrite->executeFunction("PKG_MIGRADOR.SUBSCRIPTION_ATTRIBUTES_INS", $params, $result, Connection::T_CURSOR);
	$aResSubsAttr = $connWrite->fetch($rst_subsattr_alta);
	if ((!is_array($aResSubsAttr)) || (!isset($aResSubsAttr["SQLCODE_ERROR"])) || ($aResSubsAttr["SQLCODE_ERROR"] != "200")) {
		$log->addLog(LogMessages::LOG_ERROR, LogMessages::SYS_WB, 0, "ID [" . $aSubsAttr["SUBSCRIPTIONID"] . "] DOMAIN [" . $aSubsAttr["DOMAIN"] . "]" . LogMessages::erroresArray($aResSubsAttr));
	}
}

$connRead->free($rst_subsattr);

//Tabla SUBSCRIPTION_NUMBER
$log->addLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_WB, 0, "TABLA SUBSCRIPTION_NUMBER");

$result = null;
$params = array();
$rst_subsnumb = $connRead->executeFunction("PKG_MIGRADOR.SUBSCRIPTION_NUMBER_SEL", $params, $result, Connection::T_CURSOR);

while ($aSubsNumb = $connRead->fetch($rst_subsnumb)) {
	//$log->addLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_WB, 0, "Leido: ID [" . $aCliente["CLIENTE_ID"] . "] Rz [" . $aCliente["RAZON_SOCIAL"] . "]" );
	//Inserto
	$result = null;
	$params = array("p_subscriptionid" => $aSubsNumb["SUBSCRIPTIONID"], 
					"p_subscriptionnumber" => $aSubsNumb["SUBSCRIPTIONNUMBER"]
					);
	
	$rst_subsnumb_alta = $connWrite->executeFunction("PKG_MIGRADOR.SUBSCRIPTION_NUMBER_INS", $params, $result, Connection::T_CURSOR);
	$aResSubsNumb = $connWrite->fetch($rst_subsnumb_alta);
	if ((!is_array($aResSubsNumb)) || (!isset($aResSubsNumb["SQLCODE_ERROR"])) || ($aResSubsNumb["SQLCODE_ERROR"] != "200")) {
		$log->addLog(LogMessages::LOG_ERROR, LogMessages::SYS_WB, 0, "ID [" . $aSubsNumb["SUBSCRIPTIONID"] . "] " . LogMessages::erroresArray($aResSubsNumb));
	}
}

$connRead->free($rst_subsnumb);


//Tabla TASK
$log->addLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_WB, 0, "TABLA TASK");

$result = null;
$params = array();
$rst_task = $connRead->executeFunction("PKG_MIGRADOR.TASK_SEL", $params, $result, Connection::T_CURSOR);

while ($aTask = $connRead->fetch($rst_task)) {
	//$log->addLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_WB, 0, "Leido: ID [" . $aCliente["CLIENTE_ID"] . "] Rz [" . $aCliente["RAZON_SOCIAL"] . "]" );
	//Inserto
	$result = null;
	$params = array("p_taskid" => $aTask["TASKID"], 
					"p_taskcode" => $aTask["TASKCODE"], 
					"p_cgp" => $aTask["CGP"], 
					"p_ov" => $aTask["OV"], 
					"p_customer" => $aTask["CUSTOMER"], 
					"p_subscription" => $aTask["SUBSCRIPTION"], 
					"p_domain" => $aTask["DOMAIN"], 
					"p_accountqty" => $aTask["ACCOUNTQTY"], 
					"p_accountsize" => $aTask["ACCOUNTSIZE"]
					);
	
	$rst_task_alta = $connWrite->executeFunction("PKG_MIGRADOR.TASK_INS", $params, $result, Connection::T_CURSOR);
	$aResTask = $connWrite->fetch($rst_task_alta);
	if ((!is_array($aResTask)) || (!isset($aResTask["SQLCODE_ERROR"])) || ($aResTask["SQLCODE_ERROR"] != "200")) {
		$log->addLog(LogMessages::LOG_ERROR, LogMessages::SYS_WB, 0, "TASKID [" . $aTask["TASKID"] . "] " . LogMessages::erroresArray($aResTask));
	}
}

$connRead->free($rst_task);




//Tabla TRANSACTION:
$log->addLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_WB, 0, "TABLA TRANSACTION");

//Sacar proximo item de secuencia
$cSql = "SELECT TRANSACTION_SEQ.NEXTVAL FROM DUAL";
$stmt = $connRead->prepareStatement($cSql);
$res = $connRead->execute($stmt);
if ($res == true) {
	$aRes = $connRead->fetch($stmt);
} else {
	echo "error :S";
}
$trans_nextval = $aRes["NEXTVAL"];

//Recrear Secuencia
$sqlDropTransSeq = 'DROP SEQUENCE "SOUTHWARD"."TRANSACTION_SEQ";';
$log->addLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_WB, 0, "Destino: " . $sqlDropTransSeq);
$sqlCreateTransSeq = "CREATE SEQUENCE \"SOUTHWARD\".\"TRANSACTION_SEQ\" MINVALUE 1 MAXVALUE 999999999999999999999999999 INCREMENT BY 1 START WITH $trans_nextval CACHE 20 NOORDER NOCYCLE;";
$log->addLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_WB, 0, "Destino: " . $sqlCreateTransSeq);

$result = null;
$params = array();
$rst_trans= $connRead->executeFunction("PKG_MIGRADOR.TRANSACTION_SEL", $params, $result, Connection::T_CURSOR);

while ($aTrans = $connRead->fetch($rst_trans)) {
	//$log->addLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_WB, 0, "Leido: ID [" . $aCliente["CLIENTE_ID"] . "] Rz [" . $aCliente["RAZON_SOCIAL"] . "]" );
	//Inserto
	$rqst = $aTrans["REQUEST"]->load();
	$rsp = $aTrans["RESPONSE"]->load();
	//CLOBSSSS
	$result = null;
	$params = array("p_id" => $aTrans["ID"], 
					"p_taskid" => $aTrans["TASKID"], 
					"p_opetariontype" => $aTrans["OPERATIONTYPE"], 
					"p_status" => $aTrans["STATUS"], 
					"p_transactiondate" => $aTrans["TRANSACTIONDATE"], 
					"p_platform" => $aTrans["PLATFORM"], 
					"p_request" => $rqst, 
					"p_response" => $rsp, 
					"p_statusdetail" => $aTrans["STATUSDETAIL"]
					);
	
	$rst_trans_alta = $connWrite->executeMultiClobPackage("PKG_MIGRADOR.TRANSACTION_INS", $params, array("p_request", "p_response"), $result, Connection::T_CURSOR);
	$aResTrans = $connWrite->fetch($rst_trans_alta);
	if ((!is_array($aResTrans)) || (!isset($aResTrans["SQLCODE_ERROR"])) || ($aResTrans["SQLCODE_ERROR"] != "200")) {
		$log->addLog(LogMessages::LOG_ERROR, LogMessages::SYS_WB, 0, "ID [" . $aTrans["ID"] . "]" . LogMessages::erroresArray($aResTrans));
	}
}

$connRead->free($rst_trans);



//Tabla USERS:
/*$log->addLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_WB, 0, "TABLA USERS");

//Sacar proximo item de secuencia
$cSql = "SELECT USERS_SEQ.NEXTVAL FROM DUAL";
$stmt = $connRead->prepareStatement($cSql);
$res = $connRead->execute($stmt);
if ($res == true) {
	$aRes = $connRead->fetch($stmt);
} else {
	echo "error :S";
}
$users_nextval = $aRes["NEXTVAL"];

//Recrear Secuencia
$sqlDropUsersSeq = 'DROP SEQUENCE "SOUTHWARD"."USERS_SEQ";';
$log->addLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_WB, 0, "Destino: " . $sqlDropUsersSeq);
$sqlCreateUsersSeq = "CREATE SEQUENCE \"SOUTHWARD\".\"USERS_SEQ\" MINVALUE 1 MAXVALUE 1000000000000000000000000000 INCREMENT BY 1 START WITH $users_nextval NOCACHE  ORDER  NOCYCLE;";
$log->addLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_WB, 0, "Destino: " . $sqlCreateUsersSeq);

$result = null;
$params = array();
$rst_users= $connRead->executeFunction("PKG_MIGRADOR.USERS_SEL", $params, $result, Connection::T_CURSOR);

while ($aUsers = $connRead->fetch($rst_users)) {
	//$log->addLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_WB, 0, "Leido: ID [" . $aCliente["CLIENTE_ID"] . "] Rz [" . $aCliente["RAZON_SOCIAL"] . "]" );
	//Inserto
	$result = null;
	$params = array("p_id" => $aUsers["ID"], 
					"p_username" => $aUsers["USERNAME"], 
					"p_password" => $aUsers["PASSWORD"], 
					"p_profile" => $aUsers["PROFILE"], 
					"p_completename" => $aUsers["COMPLETENAME"]
					);
	
	$rst_users_alta = $connWrite->executeFunction("PKG_MIGRADOR.USERS_INS", $params, $result, Connection::T_CURSOR);
	$aResUsers = $connWrite->fetch($rst_users_alta);
	if ((!is_array($aResUsers)) || (!isset($aResUsers["SQLCODE_ERROR"])) || ($aResUsers["SQLCODE_ERROR"] != "200")) {
		$log->addLog(LogMessages::LOG_ERROR, LogMessages::SYS_WB, 0, "ID [" . $aUsers["ID"] . "]" . LogMessages::erroresArray($aResUsers));
	}
}

$connRead->free($rst_users);
*/

?>