<?php

date_default_timezone_set('America/Buenos_Aires');
ini_set("soap.wsdl_cache_enabled", "0");


session_start();
require_once 'retro_functions.php';
require_once 'lib/Twig/Autoloader.php';
require_once 'lib/krumo/class.krumo.php';
Twig_Autoloader::register();
require_once "iplan/security/Application.php";


require_once 'iplan/security/AbstractManager.php';
require_once 'iplan/security/Renderable.php';
require_once 'iplan/security/ApplicationContext.php';
require_once 'iplan/models/provisioning/Log.php';
require_once 'iplan/models/provisioning/Process.php';
require_once 'iplan/models/provisioning/ProvisioningPlataformas.php';

// Bouml preserved body begin 00149F85
date_default_timezone_set('America/Buenos_Aires');
//Aca hay cosas de Log
require_once 'iplan/models/provisioning/LogMessages.php';
//Traigo la instancia de ORM
$orm = ORM::getInstance();
//Seteo la database a ORACLE

//Maqueta
$connLog = new OracleConnection("172.16.213.28", 1521, "sswmc", "ADMIN_IUNI", "wholesale2010", "ADMIN_IUNI", OCI_DEFAULT);
$connLog->connect();
//Produccion
$connRead = new OracleConnection("172.20.91.29", 1521, "IUNIWS", "ADMIN_IUNI", "wholesale2010", "ADMIN_IUNI", OCI_DEFAULT);
$connRead->connect();
//Dataguard
$connWrite = new OracleConnection("172.16.57.25", 1521, "AUTOPROPDB_dguard", "ADMIN_IUNI", "wholesale2010");
$connWrite->connect();
/*$connWrite = $connWrite;
$connRead = $connProduccion;
$connLog*/

$orm->setDatabase(new OracleDatabase($connWrite));

//Traigo el usuario q ejecuta los packages
$userEjecutaPackages = Application::getInstance()->getContext()->getUser()->getId();

//Traigo la instancia de LOG, logueo en la maqueta
$log = LogMessages::GetInstance($connLog, $userEjecutaPackages);
//Seteo los mensajes que hay en la databse
LogMessages::getMensajes();
//Logueo el Inicio de las pruebasPKG_WEB_LINEAS.FU_LINEAS_SEL
$log->addLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_WB, 0, 'Inicio las Pruebas de Migracion');

$sistemaLeer = 10; //IUNI
$sistemaLeerProximo = 11; //Proximo

set_error_handler("miGestorErrores");


//Tabla CLIENTE:
$log->addLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_WB, 0, "TABLA CLIENTE");

//Sacar proximo item de secuencia
$cSql = "SELECT SEQ_CLIENTE.NEXTVAL FROM DUAL";
$stmt = $connRead->prepareStatement($cSql);
$res = $connRead->execute($stmt);
if ($res == true) {
	$aRes = $connRead->fetch($stmt);
} else {
	echo "error :S";
}
$cliente_nextval = $aRes["NEXTVAL"];

//Recrear Secuencia
$sqlDropClienteSeq = 'DROP SEQUENCE "ADMIN_IUNI"."SEQ_CLIENTE";';
$log->addLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_WB, 0, "Destino: " . $sqlDropClienteSeq);
$sqlCreateClienteSeq = "CREATE SEQUENCE \"ADMIN_IUNI\".\"SEQ_CLIENTE\" MINVALUE 1 MAXVALUE 1000000000000000000000000000 INCREMENT BY 1 START WITH $cliente_nextval NOCACHE  ORDER  NOCYCLE;";
$log->addLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_WB, 0, "Destino: " . $sqlCreateClienteSeq);

$result = null;
$params = array();
$rst_clientes = $connRead->executeFunction("PKG_WEB_CLIENTE.FU_CLIENTE_SEL_ALL", $params, $result, Connection::T_CURSOR);

while ($aCliente = $connRead->fetch($rst_clientes)) {
	//$log->addLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_WB, 0, "Leido: ID [" . $aCliente["CLIENTE_ID"] . "] Rz [" . $aCliente["RAZON_SOCIAL"] . "]" );
	//Inserto
	$result = null;
	$params = array("p_cliente_id" => $aCliente["CLIENTE_ID"], 
					"p_razon_social" => $aCliente["RAZON_SOCIAL"], 
					"p_fe_alta" => $aCliente["FE_ALTA"], 
					"p_fe_baja" => $aCliente["FE_BAJA"], 
					"p_fe_modificacion" => $aCliente["FE_MODIFICACION"], 
					"p_licenciatario_id" => $aCliente["LICENCIATARIO_ID"], 
					"p_estado" => $aCliente["ESTADO"], 
					"p_nro_cliente" => $aCliente["NRO_CLIENTE"], 
					"p_t_pago_id" => $aCliente["T_PAGO_ID"], 
					"p_nombre_contacto" => $aCliente["NOMBRE_CONTACTO"], 
					"p_apellido_contacto" => $aCliente["APELLIDO_CONTACTO"], 
					"p_mail_contacto" => $aCliente["MAIL_CONTACTO"], 
					"p_telefono1_contacto" => $aCliente["TELEFONO1_CONTACTO"], 
					"p_telefono2_contacto" => $aCliente["TELEFONO2_CONTACTO"], 
					"p_usuario_web" => $aCliente["USUARIO_WEB"], 
					"p_password_web" => $aCliente["PASSWORD_WEB"], 
					"p_user_id" => null /*$aCliente["USER_ID"] */
					);
	
	$rst_clientes_alta = $connWrite->executeFunction("PKG_WEB_CLIENTE.FU_CLIENTE_FULL_INS", $params, $result, Connection::T_CURSOR);
	$aResCliente = $connWrite->fetch($rst_clientes_alta);
	if ((!is_array($aResCliente)) || (!isset($aResCliente["SQLCODE_ERROR"])) || ($aResCliente["SQLCODE_ERROR"] != "200")) {
		$log->addLog(LogMessages::LOG_ERROR, LogMessages::SYS_WB, 0, "ID [" . $aCliente["CLIENTE_ID"] . "] Rz [" . $aCliente["RAZON_SOCIAL"] . "]" . LogMessages::erroresArray($aResCliente));
	}
}

$connRead->free($rst_clientes);

//Tabla CAP_PROCESOTASKS:
$log->addLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_WB, 0, "TABLA CAP_PROCESOTASKS");

//Sacar proximo item de secuencia
$cSql = "SELECT SEQ_CAP_PROCESOTASK.NEXTVAL FROM DUAL";
$stmt = $connRead->prepareStatement($cSql);
$res = $connRead->execute($stmt);
if ($res == true) {
	$aRes = $connRead->fetch($stmt);
} else {
	echo "error :S";
}
$cap_procesotask_nextval = $aRes["NEXTVAL"];

//Recrear Secuencia
$sqlDropProcesoTaskSeq = 'DROP SEQUENCE "ADMIN_IUNI"."SEQ_CAP_PROCESOTASK";';
$log->addLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_WB, 0, "Destino: " . $sqlDropProcesoTaskSeq);
$sqlCreateProcesoTaskSeq = "CREATE SEQUENCE \"ADMIN_IUNI\".\"SEQ_CAP_PROCESOTASK\" MINVALUE 1 MAXVALUE 1000000000000000000000000000 INCREMENT BY 1 START WITH $cap_procesotask_nextval NOCACHE  ORDER  NOCYCLE;";
$log->addLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_WB, 0, "Destino: " . $sqlCreateProcesoTaskSeq);

$result = null;
$params = array("user_id" => 1);
$rst_procesotasks = $connRead->executeFunction("PKG_CAP_PROCESOTASKS.FU_PROCESOTASKS_SEL", $params, $result, Connection::T_CURSOR);

while ($aProcesoTask = $connRead->fetch($rst_procesotasks)) {
	//$log->addLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_WB, 0, "Leido: PROCESO_ID [" . $aProcesoTask["PROCESO_ID"] . "] ESTADO_ID [" . $aProcesoTask["ESTADO_ID"] . "]" );
	//Inserto
	$result = null;
	$params = array("p_proceso_id" => $aProcesoTask["PROCESO_ID"], 
					"p_estado_id" => $aProcesoTask["ESTADO_ID"], 
					);
	$rst_procesotask_alta = $connWrite->executeFunction("PKG_CAP_PROCESOTASKS.FU_PROCESOTASKS_FULL_INS", $params, $result, Connection::T_CURSOR);
	$aResProcesoTask = $connWrite->fetch($rst_procesotask_alta);
	if ((!is_array($aResProcesoTask)) || (!isset($aResProcesoTask["SQLCODE_ERROR"])) || ($aResProcesoTask["SQLCODE_ERROR"] != "200")) {
		$log->addLog(LogMessages::LOG_ERROR, LogMessages::SYS_WB, 0, "PROCESO_ID [" . $aProcesoTask["PROCESO_ID"] . "] ESTADO_ID [" . $aProcesoTask["ESTADO_ID"] . "]" .  LogMessages::erroresArray($aResProcesoTask));
	}
}

$connRead->free($rst_procesotasks);


//Tabla CAP_LOG:
$log->addLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_WB, 0, "TABLA CAP_LOG");

//Sacar proximo item de secuencia
$cSql = "SELECT SEQ_CAP_LOG.NEXTVAL FROM DUAL";
$stmt = $connRead->prepareStatement($cSql);
$res = $connRead->execute($stmt);
if ($res == true) {
	$aRes = $connRead->fetch($stmt);
} else {
	echo "error :S";
}
$cap_log_nextval = $aRes["NEXTVAL"];

//Recrear Secuencia
$sqlDropCapLogSeq = 'DROP SEQUENCE "ADMIN_IUNI"."SEQ_CAP_LOG";';
$log->addLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_WB, 0, "Destino: " . $sqlDropCapLogSeq);
$sqlCreateCapLogSeq = "CREATE SEQUENCE \"ADMIN_IUNI\".\"SEQ_CAP_LOG\" MINVALUE 1 MAXVALUE 1000000000000000000000000000 INCREMENT BY 1 START WITH $cap_log_nextval NOCACHE  ORDER  NOCYCLE;";
$log->addLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_WB, 0, "Destino: " . $sqlCreateCapLogSeq);

$result = null;
$params = array("user_id" => 1);
$rst_cap_log = $connRead->executeFunction("PKG_CAP_LOG.FU_LOG_SEL", $params, $result, Connection::T_CURSOR);

while ($aCapLog = $connRead->fetch($rst_cap_log)) {
	//$log->addLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_WB, 0, "Leido: LOG_ID [" . $aCapLog["LOG_ID"] . "]");
	//Inserto
	$result = null;
	$params = array("p_log_id" => $aCapLog["LOG_ID"], 
					"p_sistema_id" => $aCapLog["SISTEMA_ID"], 
					"p_mensaje_id" => $aCapLog["MENSAJE_ID"], 
					"p_fecha" => $aCapLog["FECHA"], 
					"p_detalle" => $aCapLog["DETALLE"], 
					);
	$rst_cap_log_alta = $connWrite->executeFunction("PKG_CAP_LOG.FU_LOG_FULL_INS", $params, $result, Connection::T_CURSOR);
	$aResCapLog = $connWrite->fetch($rst_cap_log_alta);
	if ((!is_array($aResCapLog)) || (!isset($aResCapLog["SQLCODE_ERROR"])) || ($aResCapLog["SQLCODE_ERROR"] != "200")) {
		$log->addLog(LogMessages::LOG_ERROR, LogMessages::SYS_WB, 0, "LOG_ID [" . $aCapLog["LOG_ID"] . "]" .  LogMessages::erroresArray($aResCapLog));
	}
}

$connRead->free($rst_cap_log);


//Tabla CAP_MENSAJEXML:
$log->addLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_WB, 0, "TABLA CAP_MENSAJEXML");

//VER CLOBS!!!

//Sacar proximo item de secuencia
$cSql = "SELECT SEQ_CAP_MENSAJEXML.NEXTVAL FROM DUAL";
$stmt = $connRead->prepareStatement($cSql);
$res = $connRead->execute($stmt);
if ($res == true) {
	$aRes = $connRead->fetch($stmt);
} else {
	echo "error :S";
}
$cap_mensajexml_nextval = $aRes["NEXTVAL"];

//Recrear Secuencia

$sqlDropMensajeXmlSeq = 'DROP SEQUENCE "ADMIN_IUNI"."SEQ_CAP_MENSAJEXML";';
$log->addLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_WB, 0, "Destino: " . $sqlDropMensajeXmlSeq);
$sqlCreateMensajeXmlSeq = "CREATE SEQUENCE \"ADMIN_IUNI\".\"SEQ_CAP_MENSAJEXML\" MINVALUE 1 MAXVALUE 1000000000000000000000000000 INCREMENT BY 1 START WITH $cap_mensajexml_nextval NOCACHE  ORDER  NOCYCLE;";
$log->addLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_WB, 0, "Destino: " . $sqlCreateMensajeXmlSeq);

$result = null;
$params = array("user_id" => 1);
$rst_cap_mensajexml = $connRead->executeFunction("PKG_CAP_MENSAJEXML.FU_MENSAJEXML_SEL", $params, $result, Connection::T_CURSOR);

while ($aCapMensajexml = $connRead->fetch($rst_cap_mensajexml)) {
	//$log->addLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_WB, 0, "Leido: XML_ID [" . $aCapMensajexml["XML_ID"] . "]");
	//Inserto
	$result = null;
	$xml = $aCapMensajexml["XML"]->load();
	/*
	 * Ver aca lo de CLOBS
	 */
	$params = array("p_xml_id" => $aCapMensajexml["XML_ID"], 
					"p_xml" => $xml, 
					"p_t_xml_id" => $aCapMensajexml["T_XML_ID"], 
					"p_fecha" => $aCapMensajexml["FECHA"], 
					);
	$rst_cap_mensajexml_alta = $connWrite->executeClobPackage("PKG_CAP_MENSAJEXML.FU_MENSAJEXML_FULL_INS", $params, "p_xml", $result, Connection::T_CURSOR);
	$aResCapMensajexml = $connWrite->fetch($rst_cap_mensajexml_alta);
	if ((!is_array($aResCapMensajexml)) || (!isset($aResCapMensajexml["SQLCODE_ERROR"])) || ($aResCapMensajexml["SQLCODE_ERROR"] != "200")) {
		$log->addLog(LogMessages::LOG_ERROR, LogMessages::SYS_WB, 0, "XML_ID [" . $aCapMensajexml["XML_ID"] . "]" .  LogMessages::erroresArray($aResCapMensajexml));
	}
}

$connRead->free($rst_cap_mensajexml);


//Tabla CAP_SERVICEORDERTASKS:
$log->addLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_WB, 0, "TABLA CAP_SERVICEORDERTASKS");

//VER CLOBS!!!

$result = null;
$params = array("user_id" => 1);
$rst_cap_serviceordertasks = $connRead->executeFunction("PKG_CAP_SERVICEORDERTASKS.FU_SERVICEORDERTASKS_SEL", $params, $result, Connection::T_CURSOR);

while ($aCapServiceOrderTasks = $connRead->fetch($rst_cap_serviceordertasks)) {
	//$log->addLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_WB, 0, "Leido: SERVICEORDERTASKID [" . $aCapServiceOrderTasks["SERVICEORDERTASKID"] . "]" );
	//Inserto
	$result = null;
	$metadata = $aCapServiceOrderTasks["METADATA"]->load();
	/*
	 * Ver aca lo de CLOBS
	 */
	$params = array("p_proceso_id" => $aCapServiceOrderTasks["PROCESO_ID"], 
					"p_serviceordertaskid" => $aCapServiceOrderTasks["SERVICEORDERTASKID"], 
					"p_taskcode" => $aCapServiceOrderTasks["TASKCODE"], 
					"p_serviceordernumber" => $aCapServiceOrderTasks["SERVICEORDERNUMBER"], 
					"p_subscriptionid" => $aCapServiceOrderTasks["SUBSCRIPTIONID"], 
					"p_servicetypespsid" => $aCapServiceOrderTasks["SERVICETYPESPSID"], 
					"p_servicetypecode" => $aCapServiceOrderTasks["SERVICETYPECODE"], 
					"p_featuretypecode" => $aCapServiceOrderTasks["FEATURETYPECODE"], 
					"p_unitofmeasurecode" => $aCapServiceOrderTasks["UNITOFMEASURECODE"], 
					"p_valueofmeasurecode" => $aCapServiceOrderTasks["VALUEOFMEASURECODE"], 
					"p_statuscode" => $aCapServiceOrderTasks["STATUSCODE"], 
					"p_description" => $aCapServiceOrderTasks["DESCRIPTION"], 
					"p_metadata" => $metadata,  //VERRRRRRR
					"p_ordendeventa" => $aCapServiceOrderTasks["ORDENDEVENTA"], 
					"p_subscriptionserviceid" => $aCapServiceOrderTasks["SUBSCRIPTIONSERVICEID"], 
					"p_estado_id" => $aCapServiceOrderTasks["ESTADO_ID"], 
					"p_cgp" => $aCapServiceOrderTasks["CGP"], 
					"p_razonsocial" => $aCapServiceOrderTasks["RAZONSOCIAL"], 
					"p_fecha" => $aCapServiceOrderTasks["FECHA"], 
					"p_sistema_id" => $aCapServiceOrderTasks["SISTEMA_ID"] 
					);
	/*$params = array("p_user_id" => $this->getUser(), "p_clob" => $request, "p_t_xml_id" => "3");
	$result = null;
	$lala = $this->dbase->executeClobPackage("PKG_CAP_MENSAJEXML.FU_MENSAJEXML_INS", $params, "p_clob", $result, Connection::T_CURSOR);
	$asd = $this->dbase->fetch($lala);
	$this->dbase->free($lala);*/
	$rst_cap_serviceordertasks_alta = $connWrite->executeClobPackage("PKG_CAP_SERVICEORDERTASKS.FU_SERVICEORDERTASKS_FULL_INS", $params, "p_metadata", $result, Connection::T_CURSOR);
	$aResCapServiceOrderTasks = $connWrite->fetch($rst_cap_serviceordertasks_alta);
	if ((!is_array($aResCapServiceOrderTasks)) || (!isset($aResCapServiceOrderTasks["SQLCODE_ERROR"])) || ($aResCapServiceOrderTasks["SQLCODE_ERROR"] != "200")) {
		$log->addLog(LogMessages::LOG_ERROR, LogMessages::SYS_WB, 0, "SERVICEORDERTASKID [" . $aCapServiceOrderTasks["SERVICEORDERTASKID"] . "]" .  LogMessages::erroresArray($aResCapServiceOrderTasks));
	}
}

$connRead->free($rst_cap_serviceordertasks);

//die();

//Tabla SITIO:
$log->addLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_WB, 0, "TABLA SITIO");

//Sacar proximo item de secuencia
$cSql = "SELECT SEQ_SITIO.NEXTVAL FROM DUAL";
$stmt = $connRead->prepareStatement($cSql);
$res = $connRead->execute($stmt);
if ($res == true) {
	$aRes = $connRead->fetch($stmt);
} else {
	echo "error :S";
}
$sitio_nextval = $aRes["NEXTVAL"];

//Recrear Secuencia
$sqlDropSitioSeq = 'DROP SEQUENCE "ADMIN_IUNI"."SEQ_SITIO";';
$log->addLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_WB, 0, "Destino: " . $sqlDropSitioSeq);
$sqlCreateSitioSeq = "CREATE SEQUENCE \"ADMIN_IUNI\".\"SEQ_SITIO\" MINVALUE 1 MAXVALUE 1000000000000000000000000000 INCREMENT BY 1 START WITH $sitio_nextval NOCACHE  ORDER  NOCYCLE;";
$log->addLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_WB, 0, "Destino: " . $sqlCreateSitioSeq);

$result = null;
$params = array();
$rst_sitio = $connRead->executeFunction("PKG_WEB_SITIO.FU_SITIO_SEL_ALL", $params, $result, Connection::T_CURSOR);

while ($aSitio = $connRead->fetch($rst_sitio)) {
	//$log->addLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_WB, 0, "Leido: SITIO_ID [" . $aSitio["SITIO_ID"] . "]" );
	//Inserto
	$result = null;
	$params = array("p_sitio_id" => $aSitio["SITIO_ID"], 
					"p_cliente_id" => $aSitio["CLIENTE_ID"], 
					"p_descripcion" => $aSitio["DESCRIPCION"], 
					"p_estado" => $aSitio["ESTADO"], 
					"p_fe_alta" => $aSitio["FE_ALTA"], 
					"p_fe_baja" => $aSitio["FE_BAJA"], 
					"p_fe_modificacion" => $aSitio["FE_MODIFICACION"], 
					"p_t_pago_id" => $aSitio["T_PAGO_ID"], 
					"p_locacion" => $aSitio["LOCACION"], 
					"p_subscription" => $aSitio["SUBSCRIPTION"], 
					"p_bs_group" => $aSitio["BS_GROUP"], 
					"p_bs_usuario" => $aSitio["BS_USUARIO"], 
					"p_bs_password" => $aSitio["BS_PASSWORD"], 
					"p_sistema_id" => 10/*$aSitio["SISTEMA_ID"]*/
					);
	$rst_sitio_alta = $connWrite->executeFunction("PKG_WEB_SITIO.FU_SITIO_FULL_INS", $params, $result, Connection::T_CURSOR);
	$aResSitio = $connWrite->fetch($rst_sitio_alta);
	if ((!is_array($aResSitio)) || (!isset($aResSitio["SQLCODE_ERROR"])) || ($aResSitio["SQLCODE_ERROR"] != "200")) {
		$log->addLog(LogMessages::LOG_ERROR, LogMessages::SYS_WB, 0, "SITIO_ID [" . $aSitio["SITIO_ID"] . "]" .  LogMessages::erroresArray($aResSitio));
	}
}

$connRead->free($rst_sitio);



//Tabla LINEAS:
$log->addLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_WB, 0, "TABLA LINEAS");

$result = null;
$params = array();
$rst_lineas = $connRead->executeFunction("PKG_WEB_LINEAS.FU_LINEAS_SEL_ALL", $params, $result, Connection::T_CURSOR);

while ($aLineas = $connRead->fetch($rst_lineas)) {
	//$log->addLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_WB, 0, "Leido: LINEA [" . $aLineas["LINEA"] . "]");
	//Inserto
	$result = null;
	$params = array("p_linea" => $aLineas["LINEA"], 
					"p_descripcion" => $aLineas["DESCRIPCION"], 
					"p_sitio_id" => $aLineas["SITIO_ID"], 
					"p_fe_alta" => $aLineas["FE_ALTA"], 
					"p_fe_baja" => $aLineas["FE_BAJA"], 
					"p_fe_modificacion" => $aLineas["FE_MODIFICACION"], 
					"p_t_licencia_id" => $aLineas["T_LICENCIA_ID"], 
					"p_estado" => $aLineas["ESTADO"], 
					"p_registrado" => $aLineas["REGISTRADO"], 
					"p_user_agent" => $aLineas["USER_AGENT"], 
					"p_ip" => $aLineas["IP"], 
					"p_puerto" => $aLineas["PUERTO"], 
					"p_t_linea_id" => $aLineas["T_LINEA_ID"], 
					"p_nro_interno" => $aLineas["NRO_INTERNO"], 
					"p_password_sip" => $aLineas["PASSWORD_SIP"], 
					"p_vpn_voice" => $aLineas["VPN_VOICE"], 
					"p_integracion_outlook" => $aLineas["INTEGRACION_OUTLOOK"], 
					"p_t_recepcionista_id" => $aLineas["T_RECEPCIONISTA_ID"], 
					"p_servicio_cfrm" => $aLineas["SERVICIO_CFRM"], 
					"p_licencia_callcenter" => $aLineas["LICENCIA_CALLCENTER"], 
					"p_enrutamiento_ssi" => $aLineas["ENRUTAMIENTO_SSI"], 
					"p_subscription" => $aLineas["SUBSCRIPTION"], 
					"p_detalle_web" => $aLineas["DETALLE_WEB"], 
					"p_voice_mail" => 0 /*$aLineas["VOICE_MAIL"]*/, 
					"p_mac_address" => $aLineas["MAC_ADDRESS"], 
					"p_estado_hw" => $aLineas["ESTADO_HW"], 
					"p_fe_hw" => $aLineas["FE_HW"], 
					"p_file_hw" => $aLineas["FILE_HW"], 
					"p_mod_hw_id" => $aLineas["MOD_HW_ID"]
					);
	$rst_linea_alta = $connWrite->executeFunction("PKG_WEB_LINEAS.FU_LINEAS_FULL_INS", $params, $result, Connection::T_CURSOR);
	$aResLinea = $connWrite->fetch($rst_linea_alta);
	if ((!is_array($aResLinea)) || (!isset($aResLinea["SQLCODE_ERROR"])) || ($aResLinea["SQLCODE_ERROR"] != "200")) {
		$log->addLog(LogMessages::LOG_ERROR, LogMessages::SYS_WB, 0, "LINEA [" . $aLineas["LINEA"] . "]" .  LogMessages::erroresArray($aResLinea));
	}
}

$connRead->free($rst_lineas);



//Tabla USUARIO:
$log->addLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_WB, 0, "TABLA USUARIO");

//Sacar proximo item de secuencia
$cSql = "SELECT SEQ_USUARIO.NEXTVAL FROM DUAL";
$stmt = $connRead->prepareStatement($cSql);
$res = $connRead->execute($stmt);
if ($res == true) {
	$aRes = $connRead->fetch($stmt);
} else {
	echo "error :S";
}
$usuario_nextval = $aRes["NEXTVAL"];

//Recrear Secuencia
$sqlDropUsuarioSeq = 'DROP SEQUENCE "ADMIN_IUNI"."SEQ_USUARIO";';
$log->addLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_WB, 0, "Destino: " . $sqlDropUsuarioSeq);
$sqlCreateUsuarioSeq = "CREATE SEQUENCE \"ADMIN_IUNI\".\"SEQ_USUARIO\" MINVALUE 1 MAXVALUE 1000000000000000000000000000 INCREMENT BY 1 START WITH $usuario_nextval NOCACHE  ORDER  NOCYCLE;";
$log->addLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_WB, 0, "Destino: " . $sqlCreateUsuarioSeq);

$result = null;
$params = array();
$rst_usuarios = $connRead->executeFunction("PKG_WEB_USUARIO.FU_USUARIO_SEL_ALL", $params, $result, Connection::T_CURSOR);

while ($aUsuario = $connRead->fetch($rst_usuarios)) {
	//$log->addLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_WB, 0, "Leido: USUARIO_ID [" . $aUsuario["USUARIO_ID"] . "]");
	//Inserto
	$result = null;
	$params = array("p_usuario_id" => $aUsuario["USUARIO_ID"], 
					"p_perfil_id" => $aUsuario["PERFIL_ID"], 
					"p_nombre" => $aUsuario["NOMBRE"], 
					"p_mail" => $aUsuario["MAIL"], 
					"p_usuario" => $aUsuario["USUARIO"], 
					"p_password" => $aUsuario["PASSWORD"], 
					"p_fe_alta" => $aUsuario["FE_ALTA"], 
					"p_fe_baja" => $aUsuario["FE_BAJA"], 
					"p_fe_modificacion" => $aUsuario["FE_MODIFICACION"], 
					"p_estado" => $aUsuario["ESTADO"]
					);
	$rst_usuario_alta = $connWrite->executeFunction("PKG_WEB_USUARIO.FU_USUARIO_FULL_INS", $params, $result, Connection::T_CURSOR);
	$aResUsuario = $connWrite->fetch($rst_usuario_alta);
	if ((!is_array($aResUsuario)) || (!isset($aResUsuario["SQLCODE_ERROR"])) || ($aResUsuario["SQLCODE_ERROR"] != "200")) {
		$log->addLog(LogMessages::LOG_ERROR, LogMessages::SYS_WB, 0, "USUARIO_ID [" . $aUsuario["USUARIO_ID"] . "]" .  LogMessages::erroresArray($aResUsuario));
	}
}

$connRead->free($rst_usuarios);



//Tabla CAP_PROVIS_ORDENES:
$log->addLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_WB, 0, "TABLA CAP_PROVIS_ORDENES");

$result = null;
$params = array();
$rst_cap_provis_ordenes = $connRead->executeFunction("PKG_CAP_PROVIS_ORDENES.FU_PROVIS_ORDENES_SEL_ALL", $params, $result, Connection::T_CURSOR);

while ($aCapProvisOrdenes = $connRead->fetch($rst_cap_provis_ordenes)) {
	//$log->addLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_WB, 0, "Leido: ORDENDEVENTA [" . $aCapProvisOrdenes["ORDENDEVENTA"] . "]");
	//Inserto
	$result = null;
	$params = array("p_ordendeventa" => $aCapProvisOrdenes["ORDENDEVENTA"],
					"p_detalleiuni" => $aCapProvisOrdenes["DETALLEIUNI"],
					"p_broadsoft" => $aCapProvisOrdenes["BROADSOFT"],
					"p_critical_path" => $aCapProvisOrdenes["CRITICAL_PATH"],
					"p_ssi" => $aCapProvisOrdenes["SSI"],
					"p_core" => $aCapProvisOrdenes["CORE"],
					"p_mal_aprovisionado" => $aCapProvisOrdenes["MAL_APROVISIONADO"],
					"p_sac" => $aCapProvisOrdenes["SAC"],
					"p_sistema_id" => 10 /*$aCapProvisOrdenes["SISTEMA_ID"]*/,
					"p_serviceordertaskid" => 0 /*$aCapProvisOrdenes["SERVICEORDERTASKID"]*/,
					"p_reprocesar" => $aCapProvisOrdenes["REPROCESAR"]
					);
	$rst_cap_provis_ordenes_alta = $connWrite->executeFunction("PKG_CAP_PROVIS_ORDENES.FU_PROVIS_ORDENES_FULL_INS", $params, $result, Connection::T_CURSOR);
	$aResCapProvisOrdenes = $connWrite->fetch($rst_cap_provis_ordenes_alta);
	if ((!is_array($aResCapProvisOrdenes)) || (!isset($aResCapProvisOrdenes["SQLCODE_ERROR"])) || ($aResCapProvisOrdenes["SQLCODE_ERROR"] != "200")) {
		$log->addLog(LogMessages::LOG_ERROR, LogMessages::SYS_WB, 0, "ORDENDEVENTA [" . $aCapProvisOrdenes["ORDENDEVENTA"] . "]" .  LogMessages::erroresArray($aResCapProvisOrdenes));
	}
}

$connRead->free($rst_cap_provis_ordenes);



//Tabla CAP_ORDENESLOG:
$log->addLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_WB, 0, "TABLA CAP_ORDENESLOG");

$result = null;
$params = array("p_user_id" => 1);
$rst_cap_ordeneslog = $connRead->executeFunction("PKG_CAP_ORDENESLOG.FU_ORDENESLOG_SEL", $params, $result, Connection::T_CURSOR);

while ($aCapOrdenesLog = $connRead->fetch($rst_cap_ordeneslog)) {
	//$log->addLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_WB, 0, "Leido: ORDENDEVENTA [" . $aCapOrdenesLog["ORDENDEVENTA"] . "]");
	//Inserto
	$result = null;
	$params = array("p_ordendeventa" => $aCapOrdenesLog["ORDENDEVENTA"],
					"p_log_id" => $aCapOrdenesLog["LOG_ID"],
					"p_fe_alta" => $aCapOrdenesLog["FE_ALTA"]
					);
	$rst_cap_ordenes_log_alta = $connWrite->executeFunction("PKG_CAP_ORDENESLOG.FU_ORDENESLOG_FULL_INS", $params, $result, Connection::T_CURSOR);
	$aResCapOrdenesLog = $connWrite->fetch($rst_cap_ordenes_log_alta);
	if ((!is_array($aResCapOrdenesLog)) || (!isset($aResCapOrdenesLog["SQLCODE_ERROR"])) || ($aResCapOrdenesLog["SQLCODE_ERROR"] != "200")) {
		$log->addLog(LogMessages::LOG_ERROR, LogMessages::SYS_WB, 0, "ORDENDEVENTA [" . $aCapOrdenesLog["ORDENDEVENTA"] . "]" .  LogMessages::erroresArray($aResCapOrdenesLog));
	}
}

$connRead->free($rst_cap_ordeneslog);


//Tabla CAP_ORDENESXML:
$log->addLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_WB, 0, "TABLA CAP_ORDENESXML");

$result = null;
$params = array("p_user_id" => 1);
$rst_cap_ordenesxml = $connRead->executeFunction("PKG_CAP_ORDENESXML.FU_ORDENESXML_SEL", $params, $result, Connection::T_CURSOR);

while ($aCapOrdenesXml = $connRead->fetch($rst_cap_ordenesxml)) {
	//$log->addLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_WB, 0, "Leido: ORDENDEVENTA [" . $aCapOrdenesXml["ORDENDEVENTA"] . "]");
	//Inserto
	$result = null;
	$params = array("p_ordendeventa" => $aCapOrdenesXml["ORDENDEVENTA"],
					"p_xml_id" => $aCapOrdenesXml["XML_ID"],
					"p_fe_alta" => $aCapOrdenesXml["FE_ALTA"],
					"p_sistema_id" => 10 /*$aCapOrdenesXml["SISTEMA_ID"]*/
					);
	$rst_cap_ordenesxml_alta = $connWrite->executeFunction("PKG_CAP_ORDENESXML.FU_ORDENESXML_FULL_INS", $params, $result, Connection::T_CURSOR);
	$aResCapOrdenesXml = $connWrite->fetch($rst_cap_ordenesxml_alta);
	if ((!is_array($aResCapOrdenesXml)) || (!isset($aResCapOrdenesXml["SQLCODE_ERROR"])) || ($aResCapOrdenesXml["SQLCODE_ERROR"] != "200")) {
		$log->addLog(LogMessages::LOG_ERROR, LogMessages::SYS_WB, 0, "ORDENDEVENTA [" . $aCapOrdenesXml["ORDENDEVENTA"] . "]" .  LogMessages::erroresArray($aResCapOrdenesXml));
	}
}

$connRead->free($rst_cap_ordenesxml);



//Tabla CAP_PROCESOLOG:
$log->addLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_WB, 0, "TABLA CAP_PROCESOLOG");

$result = null;
$params = array("p_user_id" => 1);
$rst_cap_procesolog = $connRead->executeFunction("PKG_CAP_PROCESOLOG.FU_PROCESOLOG_SEL", $params, $result, Connection::T_CURSOR);

while ($aCapProcesoLog = $connRead->fetch($rst_cap_procesolog)) {
	//$log->addLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_WB, 0, "Leido: PROCESO_ID [" . $aCapProcesoLog["PROCESO_ID"] . "]");
	//Inserto
	$result = null;
	$params = array("p_proceso_id" => $aCapProcesoLog["PROCESO_ID"],
					"p_log_id" => $aCapProcesoLog["LOG_ID"],
					"p_fe_alta" => $aCapProcesoLog["FE_ALTA"]
					);
	$rst_cap_procesolog_alta = $connWrite->executeFunction("PKG_CAP_PROCESOLOG.FU_PROCESOLOG_FULL_INS", $params, $result, Connection::T_CURSOR);
	$aResCapProcesoLog = $connWrite->fetch($rst_cap_procesolog_alta);
	if ((!is_array($aResCapProcesoLog)) || (!isset($aResCapProcesoLog["SQLCODE_ERROR"])) || ($aResCapProcesoLog["SQLCODE_ERROR"] != "200")) {
		$log->addLog(LogMessages::LOG_ERROR, LogMessages::SYS_WB, 0, "PROCESO_ID [" . $aCapProcesoLog["PROCESO_ID"] . "]" .  LogMessages::erroresArray($aResCapProcesoLog));
	}
}

$connRead->free($rst_cap_procesolog);



?>