<?php

//putenv("ORACLE_HOME=/u01/oracle/product/10.2.0/db_2");

date_default_timezone_set('America/Buenos_Aires');
ini_set("soap.wsdl_cache_enabled", "0");


define("DIAS_LIMPIEZA", 90);


session_start();
require_once 'retro_functions.php';
require_once 'lib/Twig/Autoloader.php';
require_once 'lib/krumo/class.krumo.php';
Twig_Autoloader::register();
require_once "iplan/security/Application.php";
require_once 'iplan/security/AbstractManager.php';
require_once 'iplan/security/Renderable.php';
require_once 'iplan/security/ApplicationContext.php';
require_once 'iplan/models/provisioning/ProvisioningPlataformas.php';
require_once 'iplan/models/provisioning/LogMessages.php';
//Traigo la instancia de ORM
$orm = ORM::getInstance();
//Seteo la database a ORACLE

//Maqueta
$conn = new OracleConnection("ADMIN_IUNI", "wholesale2010", "SSWMC");
//Dataguard
//$conn = new OracleConnection("ADMIN_IUNI", "wholesale2010", "AUTOPROPDB");
$conn->connect();

$orm->setDatabase(new OracleDatabase($conn));

$userEjecutaPackages = Application::getInstance()->getContext()->getUser()->getId();
$log = LogMessages::GetInstance($conn, $userEjecutaPackages, LogMessages::SYS_CA);
//Seteo los mensajes que hay en la databse
LogMessages::getMensajes();

set_error_handler("miGestorErrores");


$log->addLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CA, 0, "LIMPIAR LOGS [PKG_CAP_LOG.FU_CLEAN_LOG]");

$result = null;
$params = array("p_user_id" => $userEjecutaPackages, "p_dias" => DIAS_LIMPIEZA);
$rst_logs = $conn->executeFunction("PKG_CAP_LOG.FU_CLEAN_LOG", $params, $result, Connection::T_CURSOR);

$res = $conn->fetch($rst_logs);
if ((!is_array($res)) || (!isset($res["SQLCODE_ERROR"])) || ($res["SQLCODE_ERROR"] != "200")) {
	$log->addLog(LogMessages::LOG_ERROR, LogMessages::SYS_CA, 0, "Fallo al limpiar los Logs: " . LogMessages::erroresArray($res));
} else {
	$log->addLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CA, 0, "Log eliminados correctamente.");
}

$conn->free($rst_logs);

$log->closeLog();


?>