//#////////////////////////////////////////////////////////////////////////////
//# Copyright (c) 2004 Interstar technologies inc. Permission to use
//# this work for any purpose must be obtained in writing from INTERSTAR
//# TECHNOLOGIES, 455 Fenelon, Suite 112, Montreal (Dorval), Quebec, H9S 5T8
//# Canada
//#////////////////////////////////////////////////////////////////////////////

/**
\file XmSite.java
    
\since 2004/02/18

\author Silvain Laplante

*/

import com.interstarinc.xmedius.*;

/**
 *  Test program
 */

public class XmSite extends XmBase
{
    static private final String G3 = "G3";
    static private final String G4 = "G4";


    /// PUBLIC INTERFACE /////////////////////////////////////////////////////

    /// Constructor
    public XmSite()
    {}

    public void execute(String workDescription)
    {
        // Transform workDescription into args
        // TODO
        String[] args = null;

        doWork(args);
    }

    /// main
    public static void main(String[] args)
    {
        XmSite worker = new XmSite();
        worker.doWork(args);
    }


    /// PRIVATE INTERFACE ////////////////////////////////////////////////////

    private void doWork(String[] args)
    {
        System.out.println("\nXmSite - Change site tiff encoding");
        System.out.println("------------------------------------------------------------\n");

        processArgs(args);

        System.out.println("---------------------------------------------------------END\n");
    }

    private void processArgs(String[] args)
    {
        XmBase.ParsedCommandLine commandLine = null;
        try
        {
            commandLine = XmBase.getParsedCommandLine(args);
        }
        catch (XmediusException ex)
        {
            outputError(ex.toString());
            return;
        }

        boolean changeToG3 = true;
        if (commandLine.remainingArgs.length == 0) {
            outputUsage();
            return;
        }
        else if (commandLine.remainingArgs[0].equalsIgnoreCase(G3)) {
            changeToG3 = true;
        }
        else if (commandLine.remainingArgs[0].equalsIgnoreCase(G4)) {
            changeToG3 = false;
        }
        else {
            outputUsage();
            return;
        }

        if (!validateLoginInfo(commandLine, true)) {
            return;
        }

        Session session = openSession(commandLine);
        if (session == null) {
            return;
        }

        try
        {
            commandLine.targetSite = getSiteGuidFromSiteName(session, commandLine.targetSite);

            ConfigNodeId generalNodeId = SiteConfigNodeId.create(SiteConfigNodeId.Name.GENERAL, commandLine.targetSite);

            ConfigNode general = ConfigNode.getNode(session, generalNodeId);

            // Query present value
            PropertyDef[] props = new PropertyDef[1];
            props[0] = PropertyDef.GENERAL_SMTPGTWYPOSTMASTER;

            PropertyValue[] values = general.getValues(props);

            String from = values[0].stringValue();

            /*if (from.equals(PropertyDefHelper.GENERAL_TIFFENCODING_G3) && changeToG3) {
                outputInformation("Tiff encoding value is already set to " + G3);
            }
            else if (from.equals(PropertyDefHelper.GENERAL_TIFFENCODING_G4) && !changeToG3) {
                outputInformation("Tiff encoding value is already set to " + G4);
            }
            else
            {
                String to = (changeToG3 ? PropertyDefHelper.GENERAL_TIFFENCODING_G3:PropertyDefHelper.GENERAL_TIFFENCODING_G4);
                values[0].stringValue(to);
                general.setValues(values);
                
                outputInformation("Tiff encoding value changed from " + outputValue(from) +
                                  " to " + outputValue(to));
            }*/
            outputInformation("Current Value: " + from);
        }
        catch (XmediusException ex)
        {
            outputError(ex.getMessage());
        }
    }

    private String outputValue(String value)
    {
        if (value.equalsIgnoreCase(G3)) {
            return G3;
        }
        if (value.equalsIgnoreCase(G4)) {
            return G4;
        }
        return value;
    }

    private void outputUsage()
    {
        outputInformation("Usages:");
        outputInformation("");

        outputInformation("Change tiff encoding to G3: XmSite {LoginInfo} " + G3);
        outputInformation("Change tiff encoding to G4: XmSite {LoginInfo} " + G4);
        outputInformation("");

        String[] usages = GetLoginUsageSite();
        String prefix = "Where {LoginInfo} is: ";
        for (int i=0;i<usages.length;i++)
        {
            outputInformation(prefix + usages[i]);
            prefix = "                  or: ";
        }
    }

}
//#///////////////////////////////////////////////////////////////END OF FILE//
