//#////////////////////////////////////////////////////////////////////////////
//# Copyright (c) 2004 Interstar technologies inc. Permission to use
//# this work for any purpose must be obtained in writing from INTERSTAR
//# TECHNOLOGIES, 455 Fenelon, Suite 112, Montreal (Dorval), Quebec, H9S 5T8
//# Canada
//#////////////////////////////////////////////////////////////////////////////

/**
\file XmNewSite.java
    
\since 2004/02/19

\author Silvain Laplante

*/

import com.interstarinc.xmedius.*;

/**
 *  Test program
 */

public class XmNewSite extends XmBase
{
    /// PUBLIC INTERFACE /////////////////////////////////////////////////////

    /// Constructor
    public XmNewSite()
    {}

    public void execute(String workDescription)
    {
        // Transform workDescription into args
        // TODO
        String[] args = null;

        doWork(args);
    }

    /// main
    public static void main(String[] args)
    {
        XmNewSite worker = new XmNewSite();
        worker.doWork(args);
    }


    /// PRIVATE INTERFACE ////////////////////////////////////////////////////

    private void doWork(String[] args)
    {
        System.out.println("\nXmNewSite - Create a new site");
        System.out.println("------------------------------------------------------------\n");

        processArgs(args);

        System.out.println("---------------------------------------------------------END\n");
    }

    private void processArgs(String[] args)
    {
        XmBase.ParsedCommandLine commandLine = null;
        try
        {
            commandLine = XmBase.getParsedCommandLine(args);
        }
        catch (XmediusException ex)
        {
            outputError(ex.toString());
            return;
        }

        if (commandLine.remainingArgs.length == 0) {
            outputUsage();
            return;
        }
        else if (commandLine.remainingArgs[0].equalsIgnoreCase("-h")) {
            outputUsage();
            return;
        }
        String name = commandLine.remainingArgs[0];
        String reference = commandLine.remainingArgs[1];
        String contact = commandLine.remainingArgs[2];
        if (!validateLoginInfo(commandLine, false)) {
            outputUsage();
            return;
        }

        Session session = openSession(commandLine);
        if (session == null) {
            return;
        }

        try
        {
            String guid = CreateSite(session, name, reference, contact);
            outputInformation("Created new site: " + name);
            outputInformation("            GUID: " + guid);
            //CreateSiteAdmin(session, guid);
            //outputInformation("Added an admin in site: " + name);
        }
        catch (XmediusException ex)
        {
            outputError(ex.getMessage());
        }
    }

    private String CreateSite(Session session, String name, String reference, String contact)
        throws XmediusException
    {
        SystemListNodeId siteId = SystemListNodeId.create(SystemListNodeId.Name.SITES);
        ListNode sites = ListNode.getNode(session, siteId);

        // Create a new site
        PropertyValue[] values = new PropertyValue[20];
        values[0] = new PropertyValue(PropertyDef.SITES_NAME);
        values[0].stringValue(name);
        values[1] = new PropertyValue(PropertyDef.SITES_WEBALIAS);
        values[1].stringValue(name + ".sp.com");
        values[2] = new PropertyValue(PropertyDef.SITES_REFERENCE);
        values[2].stringValue("");
        values[3] = new PropertyValue(PropertyDef.SITES_CONTACT);
        values[3].stringValue(contact);
        values[4] = new PropertyValue(PropertyDef.SITES_ENABLED);
        values[4].booleanValue(true);

        values[5] = new PropertyValue(PropertyDef.SITES_QOSMAXOUTBOUND);
        values[5].intValue(0);
        values[6] = new PropertyValue(PropertyDef.SITES_QOSMAXINBOUND);
        values[6].intValue(0);
        values[7] = new PropertyValue(PropertyDef.SITES_QOSMAXINBOUNDANDOUTBOUND);
        values[7].intValue(240);
        values[8] = new PropertyValue(PropertyDef.SITES_QOSWEIGHT);
        values[8].intValue(100);
        
        
        values[9] = new PropertyValue(PropertyDef.SITES_INCOMINGAUTODELETEENTRY);
        values[9].booleanValue(false);
        values[10] = new PropertyValue(PropertyDef.SITES_INCOMINGENTRYOLDERTHAN);
        values[10].intValue(0);
        values[11] = new PropertyValue(PropertyDef.SITES_INCOMINGAUTODELETEFAX);
        values[11].booleanValue(false);
        values[12] = new PropertyValue(PropertyDef.SITES_INCOMINGFAXOLDERTHAN);
        values[12].intValue(0);
        values[13] = new PropertyValue(PropertyDef.SITES_INCOMINGBACKUPFAX);
        values[13].booleanValue(false);
        
        values[14] = new PropertyValue(PropertyDef.SITES_OUTGOINGAUTODELETEENTRY);
        values[14].booleanValue(false);
        values[15] = new PropertyValue(PropertyDef.SITES_OUTGOINGENTRYOLDERTHAN);
        values[15].intValue(0);
        values[16] = new PropertyValue(PropertyDef.SITES_OUTGOINGAUTODELETEFAX);
        values[16].booleanValue(true);
        values[17] = new PropertyValue(PropertyDef.SITES_OUTGOINGFAXOLDERTHAN);
        values[17].intValue(60);
        values[18] = new PropertyValue(PropertyDef.SITES_OUTGOINGBACKUPFAX);
        values[18].booleanValue(false);
        
        values[19] = new PropertyValue(PropertyDef.SITES_REFERENCE);
        values[19].stringValue(reference);

        long newId = sites.addRecord(values);

        // Get the new site's guid
        PropertyDef[] props = new PropertyDef[1];
        props[0] = PropertyDef.SITES_GUID;

        View view = sites.getView(props);

        String siteGuid = view.values(newId)[0].stringValue();

        ConfigNodeId generalNodeId = SiteConfigNodeId.create(SiteConfigNodeId.Name.GENERAL, siteGuid);

        ConfigNode general = ConfigNode.getNode(session, generalNodeId);

        PropertyValue[] propsxd = new PropertyValue[1];
        propsxd[0] = new PropertyValue(PropertyDef.GENERAL_SMTPGTWYPOSTMASTER);
        propsxd[0].stringValue("FaxIPLAN@iplan.com.ar");

        general.setValues(propsxd);
        return siteGuid;
    }

    private void CreateSiteAdmin(Session session, String guid)
        throws XmediusException
    {
        SiteListNodeId adminId = SiteListNodeId.create(SiteListNodeId.Name.SITEADMINISTRATORS, guid);

        ListNode admins = null;
        boolean isAdminNodeReached = false;
        
        while(!isAdminNodeReached)
        {
            try
            {
                admins = ListNode.getNode(session, adminId);
                isAdminNodeReached = true;
            }
            catch(XmediusException e)
            {
                if( e.cause() != XmediusExceptionCause.UNREACHABLE_NODE )
                {
                    throw e;
                }

                try{
                    outputWarning("Administrators node is unreachable, waiting one second for it to be created");
                    Thread.sleep(1000);
                }
                catch(InterruptedException unused) {
                    throw e;
                }
            }
        }

        /**
        Admin creation is done in 2 steps:
          1) create a new admin specifying the name and password
          2) then set its other properties
        */

        // Create a new admin

        PropertyValue[] values = new PropertyValue[2];
        values[0] = new PropertyValue(PropertyDef.SITEADMINISTRATORS_NAME);
        values[0].stringValue("Administrator");

        values[1] = new PropertyValue(PropertyDef.SITEADMINISTRATORS_PASSWORD);
        values[1].stringValue("");

        long newId = admins.addRecord(values);

        // Set its other values

        // Build rights
        RightsBuilder rights = new RightsBuilder();
        rights.add(RightsBuilder.AccessRight.GENERAL);
        rights.add(RightsBuilder.AccessRight.SITEADMINISTRATORS);
        rights.add(RightsBuilder.AccessRight.USERS);
        rights.add(RightsBuilder.AccessRight.PROFILES);
        rights.add(RightsBuilder.AccessRight.COVERSHEETS);
        rights.add(RightsBuilder.AccessRight.ROUTING);
        rights.add(RightsBuilder.AccessRight.BILLINGCODEGROUPS);
        rights.add(RightsBuilder.AccessRight.NUMBERRESTRICTIONGROUPS);
        rights.add(RightsBuilder.AccessRight.MAILDESTINATIONS);
        rights.add(RightsBuilder.AccessRight.PRINTERDESTINATIONS);
        rights.add(RightsBuilder.AccessRight.FOLDERDESTINATIONS);
        rights.add(RightsBuilder.AccessRight.EXTERNALAPPLICATIONDESTINATIONS);
        rights.add(RightsBuilder.AccessRight.NOTIFICATIONPROFILES);
        rights.add(RightsBuilder.AccessRight.MONITORING);
        rights.add(RightsBuilder.AccessRight.PROFILELOOKUPRULES);

        values = new PropertyValue[2];
        values[0] = new PropertyValue(PropertyDef.SITEADMINISTRATORS_RIGHTS);
        values[0].stringValue(rights.toString());

        values[1] = new PropertyValue(PropertyDef.SITEADMINISTRATORS_MUSTCHANGEPASSWORD);
        values[1].booleanValue(true);

        admins.setValues(newId, values);
    }

    private void outputUsage()
    {
        outputInformation("Usages:");
        outputInformation("");

        outputInformation("Create a new site: XmNewSite {LoginInfo} \"new_site_name\"");
        outputInformation("");

        String[] usages = GetLoginUsageSystem();
        String prefix = "Where {LoginInfo} is: ";
        for (int i=0;i<usages.length;i++)
        {
            outputInformation(prefix + usages[i]);
            prefix = "                  or: ";
        }
    }

}
//#///////////////////////////////////////////////////////////////END OF FILE//
