//#////////////////////////////////////////////////////////////////////////////
//# Copyright (c) 2004 Interstar technologies inc. Permission to use
//# this work for any purpose must be obtained in writing from INTERSTAR
//# TECHNOLOGIES, 455 Fenelon, Suite 112, Montreal (Dorval), Quebec, H9S 5T8
//# Canada
//#////////////////////////////////////////////////////////////////////////////

/**
\file XmNewSite.java
    
\since 2004/02/19

\author Silvain Laplante

*/

import com.interstarinc.xmedius.*;

/**
 *  Test program
 */

public class XmEnableSite extends XmBase
{
    /// PUBLIC INTERFACE /////////////////////////////////////////////////////

    /// Constructor
    public XmEnableSite()
    {}

    public void execute(String workDescription)
    {
        // Transform workDescription into args
        // TODO
        String[] args = null;

        this.doWork(args);
    }

    /// main
    public static void main(String[] args)
    {
        XmEnableSite worker = new XmEnableSite();
        worker.doWork(args);
    }


    /// PRIVATE INTERFACE ////////////////////////////////////////////////////

    private void doWork(String[] args)
    {
        System.out.println("\nXmEnableSite - Enable or disable a site");
        System.out.println("------------------------------------------------------------\n");

        processArgs(args);

        System.out.println("---------------------------------------------------------END\n");
    }

    private void processArgs(String[] args)
    {
        XmBase.ParsedCommandLine commandLine = null;
        try
        {
            commandLine = XmBase.getParsedCommandLine(args);
        }
        catch (XmediusException ex)
        {
            outputError(ex.toString());
            return;
        }

        if (commandLine.remainingArgs.length == 0) {
            outputUsage();
            return;
        }
        else if (commandLine.remainingArgs[0].equalsIgnoreCase("-h")) {
            outputUsage();
            return;
        }
        String name = commandLine.remainingArgs[0];
        String enabled = commandLine.remainingArgs[1];
        if (!validateLoginInfo(commandLine, false)) {
            outputUsage();
            return;
        }

        Session session = openSession(commandLine);
        if (session == null) {
            return;
        }

        try
        {
            String guid = EnableDisableSite(session, name, enabled);
            outputInformation("Enabled/Disabled site: " + name);
            outputInformation("                 GUID: " + guid);
            //CreateSiteAdmin(session, guid);
            //outputInformation("Added an admin in site: " + name);
        }
        catch (XmediusException ex)
        {
            outputError(ex.getMessage());
        }
    }

    private String EnableDisableSite(Session session, String name, String enabled)
        throws XmediusException
    {
        
        String siteId = getSiteGuidFromSiteName(session, name);
        SystemListNodeId siteNodeId = SystemListNodeId.create(SystemListNodeId.Name.SITES);
        //ListNodeId siteNodeId = SiteListNodeId.create(SiteListNodeId.Name, siteId);
        ListNode sites = ListNode.getNode(session, siteNodeId);
        //sites.load(siteId);

        PropertyDef[] props = new PropertyDef[1];
        props[0] = PropertyDef.SITES_GUID;
        View view = sites.getView(props);

        long ids[] = view.recordIds();
        
        // Create a new site
        PropertyValue[] values = new PropertyValue[1];
        values[0] = new PropertyValue(PropertyDef.SITES_ENABLED);
        if (enabled == "false")
            values[0].booleanValue(false);
        else 
            values[0].booleanValue(true);

        for (int i = 0; i < ids.length; i++)
            if (view.values(ids[i])[0].stringValue().equals(siteId))
                sites.setValues(ids[i], values);

        // Get the new site's guid
        /*PropertyDef[] props = new PropertyDef[1];
        props[0] = PropertyDef.SITES_GUID;
        View view = sites.getView(props);
        String siteGuid = view.values(newId)[0].stringValue();*/

        return siteId;
    }
    
    private void outputUsage()
    {
        outputInformation("Usages:");
        outputInformation("");

        outputInformation("Enable/Disable a site: XmEnableSite {LoginInfo} \"site_name\" [\"true\",\"false\"] ");
        outputInformation("");

        String[] usages = GetLoginUsageSystem();
        String prefix = "Where {LoginInfo} is: ";
        for (int i=0;i<usages.length;i++)
        {
            outputInformation(prefix + usages[i]);
            prefix = "                  or: ";
        }
    }

}
//#///////////////////////////////////////////////////////////////END OF FILE//
