<?php
require_once 'iplan/web/TemplateInterface.php';
require_once 'iplan/web/Column.php';
require_once 'iplan/web/ActionButton.php';
require_once 'iplan/web/Form.php';
require_once 'iplan/security/ApplicationContext.php';
require_once 'iplan/orm/ORM.php';
require_once 'iplan/security/AbstractManager.php';
require_once 'iplan/security/Renderable.php';
require_once 'iplan/orm/ORMQuery.php';



/**
* Author: Jorge Alexis Viqueira
* 
*/
/**
 * Inicialimente se iba a llamar List, pero debido a que PHP posee un comando navito "list()" es imposible usar el nombre. S�lo se podr�a con el uso de namespaces, pero en PHP 5.2.16 no est� disponible tal caracter�stica.
 */
class WebList implements TemplateInterface {
  /**
   * @var array la lista de columnas que conforman el listado
   */
  private $columns;

  /**
   * @var array las acciones globales del listado
   */
  private $actions;

  /**
   * @var Form un objeto que representa el formulario para b�squedas
   */
  private $filter;

  /**
   * @var ApplicationContext el contexto pasado a deploy()
   */
  protected $context;

  /**
   * @var Closure la funci�n que retorna las filas del listado. VER setListFunction() para una mejor descripci�n.
   */
  private $listFunction;

  /**
   * @var string el template de listado a utilizar
   */
  protected $listTemplate;

  /**
   * @var string el nombre del template de renderizado de fila predeterminado
   */
  protected $rowTemplate;

  /**
   * @var int el n�mero de filas del listado
   */
  protected $rowCount;

  /**
   * @var int la cantidad de filas que se muestran por p�gina. En forma predeterminada se muestran las configuradas por el provider.
   */
  protected $pageRows;

  /**
   * @var int la p�gina actual que se est� listando.
   */
  protected $currentPage;

  /**
   * @var ORM la instancia del ORM pasada al deploy()
   */
  protected $orm;

  /**
   * @var array De uso interno, almacena los par�metros de ordenamiento del post.
   */
  protected $sort;

  /**
   * @var AbstractManager El Manager en el cual fue creado el listado.
   */
  protected $manager;

  /**
   * @var string un texto que se mostrará en caso que el listado no tenga filas para mostrar.
   */
  protected $emptyMessage = 'NO SE ENCONTRARON DATOS';

  /**
   * Crea una instancia de WebList.
   * @param AbstractManager $manager El manager en el cual se est� creando el listado.
   * 
   * @return WebList una instancia nueva de la clase.
   */
  public function __construct(&$manager = null)
  {
    // Bouml preserved body begin 0010A285
    $this->listTemplate='list_items.xhtml';
	$this->rowTemplate='list_row.xhtml';
	$this->manager=$manager;
    return $this;
    // Bouml preserved body end 0010A285
  }

  /**
   * Estable el uso de un formulario como herramienta de listado.
   * 
   * @param Form $value una instancia de la clase Form.
   * @return List El listado con el formulario configurado.
   */
  public function setFilter($value)
  {
    $this->filter = $value;
    return $this;
  }

  /**
   * @return Form recupera el formulario configurado como filtro o null si es que el listado no dispone de dicha opci�n.
   */
  final public function getFilter()
  {
    return $this->filter;
  }

  /**
   * Agrega una columna al listado.
   * 
   * @param Column $column la columna a agregar al listado
   * 
   * @return List el listado al que se le ha agregado la columna indicada.
   */
  public function addColumn($column)
  {
    // Bouml preserved body begin 000EA885
    $this->columns[]=$column;
    return $this;
    // Bouml preserved body end 000EA885
  }

  /**
   * @return array Recupera un arreglo con las columnas definidas para el listado.
   */
  public function getColumns()
  {
    // Bouml preserved body begin 000F7905
    return $this->columns;
    // Bouml preserved body end 000F7905
  }

  /**
   * Agrega un bot�n general al listado.
   * 
   * @param ActionButton $action Una acci�n que se desea ejecutar independientemente de las filas del listado.
   * 
   * @return WebList El listado con la acci�n agregada
   */
  public function addAction($action)
  {
    // Bouml preserved body begin 000F7985
    $this->actions[]=$action;
    return $this;
    // Bouml preserved body end 000F7985
  }

  /**
   * @return Recupera un arreglo con todas las acciones configuradas globalmente al listado
   */
  public function getActions()
  {
    // Bouml preserved body begin 000F7A05
    return $this->actions;
    // Bouml preserved body end 000F7A05
  }

  /**
   * Establece cu�l es la funci�n que se invoca para obtener los datos del listado.
   * 
   * @param Closure $function Una funci�n que toma por par�metros el objeto de Listado, el contexto (Context) y una instancia del ORM. Adicionalmente recibe como par�metros la fila DESDE la cual se debe listar (para el paginado) y la fila HASTA la que se debe listar. El programador deber�a tener en cuenta estos dos l�mites, aunque si devuelve m�s filas el framework se limitar� a recuperar s�lo las que necesita.
   * 
   * @return WebList la instancia modificada.
   */
  public function setListFunction($function)
  {
    // Bouml preserved body begin 00109F85
    $this->listFunction = $function;
    return $this;
    // Bouml preserved body end 00109F85
  }

  /**
   * Configura el n�mero de filas totales del listado.
   * 
   * @param int $value El n�mero de filas.
   * 
   * @return WebList El WebList modificado.
   */
  public function setRowCount($value)
  {
    $this->rowCount = $value;
	return $this;
  }

  /**
   * Recupera la cantidad de filas por p�gina.
   * 
   * @return int La cantidad de registros que se muestran en una p�gina del listado.
   */
  final public function getPageRows()
  {
    return $this->pageRows;
  }

  /**
   * Configura la cantidad de filas por p�gina que muestra el listado.
   * 
   * @param int $value el n�mero de filas por p�gina que se desea mostrar.
   * 
   * @return WebList El listado modificado.
   */
  public function setPageRows($value)
  {
    $this->pageRows = $value;
	return $this;
  }

  /**
   * Recupera el template de listado configurado en el WebList.
   * 
   * @return string El template que se utiliza para renderizar una lista de �tems.
   */
  final public function getListTemplate()
  {
    return $this->listTemplate;
  }

  /**
   * Establece cu�l es el template para mostrar la lista de �tems del listado.
   * 
   * @param string $value el nombre del template que sirve para renderizar un listado.
   * 
   * @return WebList El listado modificado.
   */
  public function setListTemplate($value)
  {
    $this->listTemplate = $value;
  }

  /**
   * Recupera el template de fila configurado.
   * 
   * @return string El template que se utiliza para renderizar una fila
   */
  final public function getRowTemplate()
  {
    return $this->rowTemplate;
  }

  /**
   * Establece cu�l es el template para mostrar una fila del listado.
   * 
   * @param string $value el nombre del template que sirve para renderizar la fila del listado.
   * 
   * @return WebList El listado modificado.
   */
  public function setRowTemplate($value)
  {
    $this->rowTemplate = $value;
  }

  /**
   * Recupera la p�gina actual del listado.
   * 
   * @return int El n�mero de p�gina que se est� listando.
   */
  final public function getCurrentPage()
  {
    return $this->currentPage;
  }

  /**
   * Recupera los par�metros de ordenamiento seleccionados por el usuario.
   * 
   * @return array Retorna un arreglo indexado por el maps de la columna (si son varios elementos del maps se concatenan con "_")
   */
  public function getSort()
  {
    // Bouml preserved body begin 00111005
	return $this->sort;
    // Bouml preserved body end 00111005
  }

  /**
   * Retorna un arreglo la definici�n del objeto a fin de que sea f�cilmente interpretable por un Template de TWIG.
   * Debido a que no todos los componentes tienen el maps y el name obligatorio, se asume como regla que:
   * <ul>
   * 	<li><b>si tiene name</b>, se usa el name.</li>
   * 	<li><b>si no tiene name</b>, se usa el maps de la siguiente manera: $prefix.maps.$postfix</li>
   * </ul>
   * 
   * @param string $prefix el prefijo que emplea para generar los nombres cuando no existe el name.
   * @param string $postfix el sufijo que emplea para generar los nombres cuando no existe el name.
   * 
   * @return array El arreglo que representa el objeto y sus propiedades
   */
  public function toArray($prefix = '', $postfix = '')
  {
    // Bouml preserved body begin 000EA805
    /* $columns = array();  Ahora lo hace en WebList::deploy() */
	$actions = array();
	$aForm = array();
	/* if (is_array($this->columns) && (count($this->columns) > 0)) {
		foreach($this->columns as $column)
			$columns[]=$column->toArray($prefix, $postfix);
	}  Ahora lo hace en WebList::deploy() */
	if (is_array($this->actions) && (count($this->actions) > 0)) {
		foreach($this->actions as $action)
			$actions[]=$action->toArray($prefix, $postfix);
	}
	if (isset($this->filter) && (is_a($this->filter, "Form"))) {
		$aForm = $this->filter->toArray($prefix, $postfix);
	}
	$action = $this->context->getCurrentAction();
    return array_merge($aForm, array(
/*        'columns'		=> $columns,  Ahora lo hace en WebList::deploy() */
        'actions'		=> $actions,
		'listTemplate'	=> $this->listTemplate,
		'default_action'=> $action->getFacade()->getAlias() . "." . $action->getAlias(),
		'urlCode'		=> $action->getUrlCode(),
		'rowCount'		=> $this->rowCount,
		'totalPages'	=> intVal($this->rowCount / $this->pageRows) + (($this->rowCount % $this->pageRows) > 0 ? 1 : 0),
		'currentPage'	=> $this->currentPage,
		'orderBy'		=> $this->sort,
		'emptyMessage'  => $this->emptyMessage,
		'pageRows'		=> $this->context->getDomain()->getPageRows(),
    ));
    // Bouml preserved body end 000EA805
  }

  /**
   * Retorna la instancia necesaria para renderizar del listado.
   * 
   * @param ApplicationContext $context el contexto en el cual el Form debe hacer su trabajo.
   * @param ORM $orm el ORM a usar
   * 
   * @return Renderable el objeto que representa el listado o la secci�n del listado que se debe desplegar.
   */
  public function deploy(&$context, &$orm)
  {
    // Bouml preserved body begin 00109F05
	
	//Seteo atributos de la clase
	$this->context = $context;
    $this->orm = $orm;
	//$downlodeable = false;
	$prefix=$postfix="";//Si algun día hace falta cambiar aca y/o meter set()/get() para estas cosas.

	//Recupero la página solicitada por el usuario, si tengo que mostrar o no los filtros
	//y si me pidió sólo una fila
	$this->currentPage = $context->getParam('uws_page', "", 'PG');
	
	if ($this->currentPage==""){
		$this->currentPage = max(array(1, $context->getParam('uws_current_page', 1, 'PG')));
		
	}
	$sort = $context->getParam('uws_sort', "", 'PG');
	if ($sort=="") {
		$sort=$context->getParam('uws_current_sort', "", 'PG');
	}
	if ($sort != "") {
		list($name, $direction) = explode("__", $sort);
		foreach($this->columns as $key=>$column) {
			/* @var $column Column */
			$mapsName = $column->getMaps();
			if (is_array($mapsName)) $mapsName = implode ("_", $mapsName);
			if ($column->getName() == $name || $mapsName==$name) $this->sort=array($name, $direction, $this->columns[$key]);
		}
	}

	if ($uws_page_rows = $context->getParam('uws_page_rows', null)) {
		$this->pageRows = $uws_page_rows;
	} else {
		if (is_null($this->pageRows)) $this->pageRows = $this->context->getDomain()->getPageRows();
	}
	
	$context->set("uws_page_rows", $this->pageRows);
	
	$isAjax = $context->get('AJAX');
	$list_action = $context->getParam('uws_list_action', 'WITH_FILTER', 'PG');
	$only_row = $context->getParam('uws_only_row', null, 'PG');
	
	/* En el caso que exista, agrega al form del filtro, el valor a postear de c/s filtro */
	if (!isset($this->filter)) {
		$formDefault = new Form();
		$formDefault->setAction($context->getCurrentAction())
				    ->setMethod('POST');
		$this->filter=$formDefault;
	}

//	if (is_a($this->filter, 'Form')) {
	//Seteo el contexto del form Filtro y le digo que no cierre el tag
	$this->filter->setContext($this->context)
				 ->setCloseTag(false)
				 ->setTarget('div_list_items')
				 ->setAjaxAction('uws_submit_with_location')
				 ->setId("form_weblist")
				 ->loadValues();
		
	$eventName = $this->getValueOf('UWS_EVENT');
	if (!is_null($eventName)) {
		return $this->filter->deploy($context);
	}

	$sh_template = ($isAjax) ? 'WITHOUT_FILTER' : 'WITH_FILTER';
	$comp_list_action = new HiddenComponent();
	$comp_list_action->setId('uws_id_list_action')
						->setName('uws_list_action')
						->setValue($sh_template);
	$this->filter->addComponent($comp_list_action);
	
	$comp_uws_page_rows = new HiddenComponent();
	$comp_uws_page_rows->setId('uws_page_rows')->setName('uws_page_rows');
	if ($uws_page_rows) $comp_uws_page_rows->setValue();
	$this->filter->addComponent($comp_uws_page_rows);
	
//	}
	//Elijo el template a mostrar si es con o sin filtro
	if ($list_action == 'WITHOUT_FILTER') {
		$showTemplate = $this->listTemplate;
	} else {
		$showTemplate = "list.xhtml";
	}
	
	//Creo el Renderable
	$renderable = new Renderable($showTemplate);

	//Calculo el From/To
	if ($list_action == 'EXPORT') {
		$from_row = 1;
		$to_row = null;
	} else {
		$from_row = ($this->pageRows * ($this->currentPage - 1)) + 1;
		$to_row = ($this->pageRows * ($this->currentPage));
	}

	//Recupero las filas llamando a la funcion seteada
	$funcion = $this->listFunction;
	if ((!is_null($funcion)) && ($mainResult = $funcion($this->manager, $this, $context, $orm, $from_row, $to_row))) {
		if ($only_row != "") {
			if (count($mainResult) > 0) {
				$filaMuestra = array();
				foreach ($mainResult as $itemMR) {
					if ($itemMR['id'] == $only_row) {
						$filaMuestra = array($itemMR);
					}
				}
				$mainResult = $filaMuestra;
			}
			$renderable->setTemplate($this->rowTemplate);
		}
		
		if ($list_action == 'EXPORT') {
			$uws_format = $context->getParam('uws_format', "CSV", 'PG');
			switch ($uws_format) {
				case "CSV":
				default:
					$renderable->addHeader('Content-Type', 'text/csv')
							   ->addHeader('Content-Disposition', 'attachment; filename="list.csv')
							   ->setTemplate('lib/list_csv.twig')
							   ->setDownlodeable(true);
					break;
			}
			$columnCondition = function ($c) {return $c->getExportable(); };
		} else {
			$columnCondition = function ($c) {return !$c->getHide(); };
		}
		
		//Ahora separo las columnas de datos "necesarias"
		$columns=array();
		for($i=0; $i < count($this->columns);$i++) {
			if ($columnCondition($this->columns[$i])) {
				//Para el día que haga falta filtrar el set de datos base hacer esto.
				//$maps = $this->columns[$i]->getMaps();
				//if (is_string($maps)) $maps = array($maps);
				//$validColumns[]=array_merge($validColumns, $maps);
				$columns[]=$this->columns[$i]->toArray($prefix, $postfix);
			}
		}
		
		//TODO: Y acá se podrían eliminar los datos innecesarios para que no vayan
		//al listado... pero por ahora seria un trabajo innecesario y requiere
		//evaluar performance.
		
		$context->set('list_items', $mainResult);
		$context->set('options', array_merge($this->toArray($prefix, $postfix), array('columns'=>$columns)));
	} else {
		$context->set('options', array_merge($this->toArray($prefix, $postfix)));
	}
	$uws_list_filter = '&'.$this->filter->toURL(false);
	$uws_list_filter = str_replace('&uws_list_action=WITHOUT_FILTER', '', $uws_list_filter);
	$uws_list_filter = str_replace('&uws_list_action=WITH_FILTER', '', $uws_list_filter);
	$uws_list_filter .= '&uws_page='.$this->currentPage;
	$sort = $context->getParam('uws_sort', "", 'PG');
	if ($sort=="") {
		$sort=$context->getParam('uws_current_sort', "", 'PG');
		if ($sort != "")
			$uws_list_filter .= "&uws_current_sort=$sort";
	} else {
		$uws_list_filter .= "&sort=$sort";
	}
	$context->set('UWS_LIST_FILTER', urlencode(urlencode($uws_list_filter)));
	return $renderable;

    // Bouml preserved body end 00109F05
  }

  /**
   * Esta funci�n funciona s�lo si el listado tiene un form definido. Es un wrapper a la funci�n getValueOf() del form.
   * 
   * @parma string name el nombre del componente cuyo valor se quiere acceder.
   * 
   * @return mixed el valor que tenga el elemento.
   */
  public function getValueOf($name)
  {
    // Bouml preserved body begin 0010A305
    if (isset($this->filter)) {
        return $this->filter->getValueOf ($name);
    } else {
        return null;
    }
    // Bouml preserved body end 0010A305
  }

  /**
   * Aplica las limitaciones y condiciones de ordenamiento necesarias a la Query.
   * 
   * @param ORMQuery $query la consulta principal de un listado. Luego de que se le apliquen los filtros, los resultados pueden a�n seguir siendo modificados.
   * 
   * @return WebList el listado que aplic� las limitantes
   */
  public function limitQuery(&$query)
  {
    // Bouml preserved body begin 00117F05
	$this->rowCount = $query->count();
	$list_action = $this->context->getParam('uws_list_action', null, 'PG');
	if ($list_action=='EXPORT') {
		$from_row = 1;
		$to_row = $this->rowCount;
	} else {
		if (($this->currentPage == 0) && ($this->rowCount > 0)) $this->currentPage = 1;
		$from_row = ($this->pageRows * ($this->currentPage - 1)) + 1;
		$to_row = ($this->pageRows * ($this->currentPage));
	}

	if ($from_row > $this->rowCount) {
		$this->currentPage= intVal($this->rowCount / $this->pageRows);
	    if (($this->rowCount % $this->pageRows)> 0) {
				$this->currentPage++;
		}

		$from_row = ($this->pageRows * ($this->currentPage - 1)) + 1;
		$to_row = ($this->pageRows * ($this->currentPage));
	};

	$query->from($from_row)->to($to_row)->setMaxFetchRows($this->context->getProvider()->getMaxFetchRows());
	if ($sorts = $this->getSort()) {
		$column = $sorts[2];
		/* @var Column $column */
		$maps = $column->getMaps();
		if (is_array($maps)) {
			foreach($maps as $map)
				$query->orderBy("$map ".$sorts[1]);
		} else {
			$query->orderBy("$maps ".$sorts[1]);
		}
	}

	return $this;
    // Bouml preserved body end 00117F05
  }

  /**
   * Toma una query y asumiendo que el filtro se haya confeccionado usando en los maps los nombres que deben ir en la propia query, los agrega.
   * 
   * @param ORMQuery $query la consulta a agregarle los filtros.
   * 
   * @return WebList el listado que modific� la query.
   */
  public function applyFilter(&$query)
  {
    // Bouml preserved body begin 00119985
	if (!is_null($this->filter)) {
		$class = $query->getClass();
		$orm = $query->getORM();
		$definition = $orm->getDefinition($class);
		
		$components = $this->filter->getComponent();
		foreach($components as $component) {
			//Si no tiene maps es que el user lo va a manejar a mano
			if ($maps = $component->getMaps()) {
				//Todo lo que tenga un maps TIENE que tener un name, porque si
				//en el form HTML hay algo sin name, sencillamente no pasa el valor
				$value = $this->getValueOf($component->getName());
				//Si se pasó un valor para este atributo...
				if (!is_null($value) && $value != '') {
					if (is_string($maps)) {
						$maps = array($maps);
					}
					if (count($maps)>1) {
						$query->startGroup();
						$join = 'OR';
					} else {
						$join='AND';
					}
					foreach($maps as $map) {
							$parts = explode('.', $map);
							$tmpDefinition = $definition;
							$worryAbout = '';
							foreach($parts as $attribute) {
								$fieldsDefs = $tmpDefinition->getFieldDefinition();
								$relsDefs   = $tmpDefinition->getRelationDefinition();
								//Si es un atributo pongo la condición en base al tipo de datos
								if (isset($fieldsDefs[$attribute])) {
									if (is_array($value)) {
										$query->filterBy($map, 'IN', $value, null, $join);
										break;
									} else {
										switch ($fieldsDefs[$attribute]['type']) {
											case ORM_TYPES::ORM_ENTITY:
												//Mismo caso a que sea una relación.
												$class = $fieldsDefs[$attribute]['class'];
												$tmpDefinition = $orm->getDefinition($class);
												$worryAbout .= ($worryAbout == '') ? $attribute : ".$attribute";
												break;
											case ORM_TYPES::STRING:
												$query->filterBy($map, 'LIKE', "%$value%", null, $join);
												break;
											case ORM_TYPES::DATE:
											case ORM_TYPES::DATETIME:
												if (is_a($value, 'DateTime')) {
													$value = new DateTime($value->format("Y-m-d"));
													$value2 = clone($value);
													$value2->add(new DateInterval("PT23H59M59S"));
													$query->filterBy($map, 'BETWEEN', $value, $value2, $join);
												} else {
													$query->filterBy($map, '=', $value, null, $join);
												}
												break;
											default:
												$query->filterBy($map, '=', $value, null, $join);
												break;
										}
									}
								//En cambio si es una relación salto al paso siguiente
								} elseif(isset($relsDefs[$attribute])) {
									$class = $relsDefs[$attribute]['class'];
									$tmpDefinition = $orm->getDefinition($class);
									$worryAbout .= ($worryAbout == '') ? $attribute : ".$attribute";
								} else {
									//Acá algún problema hubo, el tipo escrbibió cualquier cosa:
									throw new Exception("No se puede alcanzar $attribute desde $class en $map. Error en componente: ".$component->getName());
									break;
								}
								if ($worryAbout != '') $query->worryAbout($worryAbout);
							}
					}
					if (count($maps)>1)
						$query->endGroup();
				}
			}
		}
	}
	return $this;
    // Bouml preserved body end 00119985
  }

  /**
   * Recupera el mensaje que se muestra cuando no hay filas para mostrar en el listado.
   * 
   * @return string El texto del mensaje
   */
  final public function getEmptyMessage()
  {
    return $this->emptyMessage;
  }

  /**
   * Configura el mensaje que se muestra cuando no hay filas para mostrar en el listado.
   * 
   * @param string $value el texto que se quiere mostrar.
   * @return WebList El listado con el texto para vacíos configurado.
   */
  public function setEmptyMessage($value)
  {
    $this->emptyMessage = $value;
    return $this;
  }

}
?>