<?php
require_once 'iplan/web/Component.php';



/**
* Author: Jorge Alexis Viqueira
* 
*/
/**
 * @method mixed getSelected()
 * @method SelectComponent setSelected()
 * @method SelectComponent setOptions()
 * @method SelectComponent  setWidth()
 * @method int getWidth()
 * @method SelectComponent setOptional()
 * @method boolean getOptional()
 */
class SelectComponent extends Component {
  /**
   * @var array las alternativas que el componente expone al usuario
   */
  protected $options;

  /**
   * @var mixed el valor seleccionado
   */
  protected $selected;

  /**
   * @var int indica el tama�o en horizontal del componente.
   */
  protected $width;

  /**
   * @var boolean indica si aparece el "-" en la lista, haci�ndola opcional. En forma predeterminada es TRUE
   */
  protected $optional = TRUE;

  /**
   * Retorna un arreglo la definici�n del objeto a fin de que sea f�cilmente interpretable por un Template de TWIG.
   * Debido a que no todos los componentes tienen el maps y el name obligatorio, se asume como regla que:
   * <ul>
   * 	<li><b>si tiene name</b>, se usa el name.</li>
   * 	<li><b>si no tiene name</b>, se usa el maps de la siguiente manera: $prefix.maps.$postfix</li>
   * </ul>
   * 
   * @param string $prefix el prefijo que emplea para generar los nombres cuando no existe el name.
   * @param string $postfix el sufijo que emplea para generar los nombres cuando no existe el name.
   * 
   * @return array El arreglo que representa el objeto y sus propiedades
   */
  public function toArray($prefix = '', $postfix = '')
  {
    // Bouml preserved body begin 000E6F05
	$useGroups = false;
	if ((is_array($this->options)) && (count($this->options) > 0)) {
		$first = reset($this->options);
		$useGroups = array_key_exists("group", $first);
	}

	return array_merge(parent::toArray($prefix, $postfix), array('selected'=>$this->selected, 
															     'type'=>'select', 
																 'options'=>$this->options, 
																 'width'=>$this->width,
																 'optional'=>$this->optional,
																 'useGroups'=>$useGroups));
    // Bouml preserved body end 000E6F05
  }

  /**
   * Retorna una versi�n string del nombre del componente y de su valor. S�lo sirve cuando ambos datos est�n definidos.
   * @param string $prefix el prefijo del nombre del elemento
   * @param string suffix el sufijo del nombre del elemento
   * @return string una porci�n de URL que representa el componente y su valor o el string vac�o si no tiene un value asignado o si no tiene un name.
   */
  public function toURL($prefix = '', $suffix = '')
  {
    // Bouml preserved body begin 00131E85
	if (!is_null($this->selected) && ($this->selected != '')) {
		return $prefix.$this->getName().$suffix."=".$this->selected;
	} else return '';
    // Bouml preserved body end 00131E85
  }

}
?>