<?php
require_once 'iplan/web/Component.php';



/**
* Author: Jorge Alexis Viqueira
* 
*/
/**
 * @method mixed getSelected()
 * @method RadioComponent setSelected()
 * @method array getOptions()
 * @method RadioComponent setOptions()
 */
class RadioComponent extends Component {
  /**
   * @var array las alternativas que el componente expone al usuario
   */
  protected $options;

  /**
   * @var bool Indica si est seleccionado o no.
   */
  protected $selected;

  /**
   * Retorna un arreglo la definicin del objeto a fin de que sea fcilmente interpretable por un Template de TWIG.
   * Debido a que no todos los componentes tienen el maps y el name obligatorio, se asume como regla que:
   * <ul>
   * 	<li><b>si tiene name</b>, se usa el name.</li>
   * 	<li><b>si no tiene name</b>, se usa el maps de la siguiente manera: $prefix.maps.$postfix</li>
   * </ul>
   * 
   * @param string $prefix el prefijo que emplea para generar los nombres cuando no existe el name.
   * @param string $postfix el sufijo que emplea para generar los nombres cuando no existe el name.
   * 
   * @return array El arreglo que representa el objeto y sus propiedades
   */
  public function toArray($prefix = '', $postfix = '')
  {
    // Bouml preserved body begin 000E6F85
	return array_merge(parent::toArray($prefix, $postfix), array('selected'=>$this->selected, 'type'=> 'radio', 'options'=>$this->options));
    // Bouml preserved body end 000E6F85
  }

}
?>