<?php
require_once 'iplan/web/SelectComponent.php';



/**
* Author: Jorge Alexis Viqueira
* 
*/
/**
 * Un lista de selecci�n m�ltiple.
 * 
 * @method MultiselectComponent setRows()
 * @method int getRows()
 */
class MultiselectComponent extends SelectComponent {
  /**
   * @var int la cantidad de filas que se muestra en simult�neo
   */
  protected $rows;

  /**
   * Retorna un arreglo la definici�n del objeto a fin de que sea f�cilmente interpretable por un Template de TWIG.
   * Debido a que no todos los componentes tienen el maps y el name obligatorio, se asume como regla que:
   * <ul>
   * 	<li><b>si tiene name</b>, se usa el name.</li>
   * 	<li><b>si no tiene name</b>, se usa el maps de la siguiente manera: $prefix.maps.$postfix</li>
   * </ul>
   * 
   * @param string $prefix el prefijo que emplea para generar los nombres cuando no existe el name.
   * @param string $postfix el sufijo que emplea para generar los nombres cuando no existe el name.
   * 
   * @return array El arreglo que representa el objeto y sus propiedades
   */
  public function toArray($prefix = '', $postfix = '')
  {
    // Bouml preserved body begin 000E8B05
	return array_merge(parent::toArray($prefix, $postfix), array('rows' => $this->rows, 'type'=>'multiple'));
    // Bouml preserved body end 000E8B05
  }

  /**
   * Retorna una versi�n string del nombre del componente y de su valor. S�lo sirve cuando ambos datos est�n definidos.
   * @param string $prefix el prefijo del nombre del elemento
   * @param string suffix el sufijo del nombre del elemento
   * @return string una porci�n de URL que representa el componente y su valor o el string vac�o si no tiene un value asignado o si no tiene un name.
   */
  public function toURL($prefix = '', $suffix = '')
  {
    // Bouml preserved body begin 00131F05
	if (!is_null($this->selected) && ($this->selected != '')) {
		if (is_array($this->selected)) {
			$selecteds = array_diff($this->selected, array(''));
			if (count($selecteds)>0) {
				$str='';
				foreach($selecteds as $value)
					$str.=$prefix.$this->getName().$suffix."[]=$value&";
				return substr($str, 0, strlen($str)-1);
			}
		} else return $prefix.$this->getName().$suffix."=".$this->selected;
	} else return '';
    // Bouml preserved body end 00131F05
  }

}
?>