<?php
require_once 'iplan/web/TemplateInterface.php';



/**
* Author: Jorge Alexis Viqueira
* 
*/
class ListSectionItem implements TemplateInterface {
  /**
   * @var string el texto a mostrar en la descripción del ítem
   */
  private $text;

  /**
   * @var string la clase CSS asociada al ítem
   */
  private $class;

  /**
   * Crea un nuevo ítem de listado con el texto especificado y el estilo indicado.
   * 
   * @param string $text el texto que describe el ítem.
   * @param string $class la clase asociada.
   * 
   * @return ListSectionItem el ítem creado
   */
  public function __construct($text, $class = null)
  {
    // Bouml preserved body begin 00176105
	$this->text=$text;
	$this->class=$class;
	return $this;
    // Bouml preserved body end 00176105
  }

  final public function getText()
  {
    return $this->text;
  }

  public function setText($value)
  {
    $this->text = $value;
  }

  final public function getClass()
  {
    return $this->class;
  }

  public function setClass($value)
  {
    $this->class = $value;
  }

  /**
   * Retorna un arreglo la definici�n del objeto a fin de que sea f�cilmente interpretable por un Template de TWIG.
   * Debido a que no todos los componentes tienen el maps y el name obligatorio, se asume como regla que:
   * <ul>
   * 	<li><b>si tiene name</b>, se usa el name.</li>
   * 	<li><b>si no tiene name</b>, se usa el maps de la siguiente manera: $prefix.maps.$postfix</li>
   * </ul>
   * 
   * @param string $prefix el prefijo que emplea para generar los nombres cuando no existe el name.
   * @param string $suffix el sufijo que emplea para generar los nombres cuando no existe el name.
   * 
   * @return array El arreglo que representa el objeto y sus propiedades
   */
  public function toArray($prefix = "", $suffix = "")
  {
    // Bouml preserved body begin 00176905
	return array("text" => $this->getText(), "cssClass" => $this->getClass());
    // Bouml preserved body end 00176905
  }

}
?>