<?php
require_once 'iplan/web/TemplateInterface.php';
require_once 'iplan/web/ListSectionItem.php';



/**
* Author: Jorge Alexis Viqueira
* 
*/
class ListSection implements TemplateInterface {
  /**
   * @var string el título de la sección
   */
  private $title;

  /**
   * @var string el estilo CSS a emplear en la construcción de la lista.
   */
  private $class;

  /**
   * @var ListSectionItem a documentar
   */
  private $currentItem;

  /**
   * @var array una colección que almacena los items a listar
   */
  private $items;

  /**
   * Crea una sección.
   * 
   * @param string $title el título de la sección.
   * @param string $class el estilo CSS que se desea aplicar a la sección
   * 
   * @return ListSection Devuelve una nueva sección con el título designado.
   */
  public function __construct($title, $class = null)
  {
    // Bouml preserved body begin 00176185
	$this->title=$title;
	$this->class=$class;
	return $this;
    // Bouml preserved body end 00176185
  }

  /**
   * Crea y agrega un ítem a la lista, posteriormente será mostrado con el estilo y el bullet especificado.
   * 
   * @param string $text el texto a exhibir al usuario
   * @param string $css la clase CSS asociada al texto del ítem
   * 
   * @return ListSection Devuelve la sección a la que se le ha agregado el ítem.
   */
  public function createItem($text, $css = null)
  {
    // Bouml preserved body begin 00176085
	$this->currentItem = new ListSectionItem($text, $css);
	$this->addItem($this->currentItem);
	return $this->currentItem;
    // Bouml preserved body end 00176085
  }

  /**
   * Agrega un ítem al listado.
   * 
   * @param ListSectionItem $item el ítem a agregar.
   * 
   * @return ListSection la sección con el ítem agregado.
   */
  public function addItem($item)
  {
    // Bouml preserved body begin 00176785
	if (is_a($item, "ListSectionItem")) {
		$this->currentItem = $item;
		$this->items[] = $item;
	} else {
		throw new Exception("El item es inválido y no puede agregarse al reporte");
	}
	return $this;
    // Bouml preserved body end 00176785
  }

  final public function getTitle()
  {
    return $this->title;
  }

  public function setTitle($value)
  {
    $this->title = $value;
  }

  final public function getClass()
  {
    return $this->class;
  }

  public function setClass($value)
  {
    $this->class = $value;
  }

  /**
   * Retorna un arreglo la definici�n del objeto a fin de que sea f�cilmente interpretable por un Template de TWIG.
   * Debido a que no todos los componentes tienen el maps y el name obligatorio, se asume como regla que:
   * <ul>
   * 	<li><b>si tiene name</b>, se usa el name.</li>
   * 	<li><b>si no tiene name</b>, se usa el maps de la siguiente manera: $prefix.maps.$postfix</li>
   * </ul>
   * 
   * @param string $prefix el prefijo que emplea para generar los nombres cuando no existe el name.
   * @param string $suffix el sufijo que emplea para generar los nombres cuando no existe el name.
   * 
   * @return array El arreglo que representa el objeto y sus propiedades
   */
  public function toArray($prefix = "", $suffix = "")
  {
    // Bouml preserved body begin 00176885
	$aItemsSeccion = array();
	if (is_array($this->items) && (count($this->items) > 0))
		foreach ($this->items as $item)
			if (is_a($item, "ListSectionItem"))
				$aItemsSeccion[] = $item->toArray($prefix = "", $suffix = "");
	
	
	
	$aSection = array(
		"titulo" => $this->title,
		"cssClass" => $this->class,
		"items" => $aItemsSeccion
	);
	
	return $aSection;
    // Bouml preserved body end 00176885
  }

}
?>