<?php
require_once 'iplan/web/ListSection.php';
require_once 'iplan/web/TemplateInterface.php';



/**
* Author: Jorge Alexis Viqueira
* 
*/
class ListReport implements TemplateInterface {
  /**
   * @var string el titulo del reporte de éxito
   */
  private $title;

  /**
   * @var string un estilo CSS a utilizar en el DIV que abarca todo el reporte.
   */
  private $class;

  /**
   * @var array la lista de secciones del reporte
   */
  private $sections;

  /**
   * @var string una variable que indica cuál es el template al que se destina el reporte
   */
  private $template = 'lib/reporte.xhtml';

  /**
   * @var ListSection la última sección creada o agregada al reporte.
   */
  private $currentSection;

  /**
   * Crea un reporte con forma de lista.
   * 
   * @param string $title el título general del reporte.
   * @param string $class el estilo CSS que se aplica al reporte entero.
   * 
   * @return ListReport Retorna un reporte nuevo.
   */
  public function __construct($title, $class = null)
  {
    // Bouml preserved body begin 00176985
	$this->title = $title;
	$this->class = $class;
	return $this;
    // Bouml preserved body end 00176985
  }

  /**
   * Crea una sección dentro del reporte actual y la devuelve.
   * 
   * @param string $title el título de la sección.
   * @param string $class el estilo CSS para la sección, opcional.
   * 
   * @return ListSection la sección creada.
   */
  public function createSection($title, $class = null)
  {
    // Bouml preserved body begin 00175D85
	$this->currentSection = new ListSection($title, $class);
	$this->addSection($this->currentSection);
	return $this->currentSection;
    // Bouml preserved body end 00175D85
  }

  /**
   * Agrega una sección al reporte actual.
   * 
   * @param ListSection $section la sección a agregar.
   * 
   * @return ListReport Retorna el reporte con la sección agregada
   */
  public function addSection($section)
  {
    // Bouml preserved body begin 00175E05
	if (is_a($section, "ListSection")) {
		$this->currentSection = $section;
		$this->sections[] = $section;
	} else {
		throw new Exception("La sección es inválida y no puede agregarse al reporte");
	}
	return $this;
    // Bouml preserved body end 00175E05
  }

  /**
   * Agrega un ítem a la sección actual
   * 
   * @param string $texto la descripción del ítem
   * @param string $class el estilo CSS asociado al ítem, opcional.
   * 
   * @return ListReport El reporte actual con el ítem agregado a la última sección creada.
   */
  public function addItem($text, $class = null)
  {
    // Bouml preserved body begin 00176205
	if (is_a($this->currentSection, "ListSection"))
		$this->currentSection->addItem(new ListSectionItem($text, $class));
	else
		throw new Exception("La el reporte no tiene una sección por defecto");
	return $this;
    // Bouml preserved body end 00176205
  }

  final public function getTitle()
  {
    return $this->title;
  }

  public function setTitle($value)
  {
    $this->title = $value;
  }

  final public function getTemplate()
  {
    return $this->template;
  }

  public function setTemplate($value)
  {
    $this->template = $value;
  }

  final public function getClass()
  {
    return $this->class;
  }

  public function setClass($value)
  {
    $this->class = $value;
  }

  /**
   * Retorna un arreglo la definici�n del objeto a fin de que sea f�cilmente interpretable por un Template de TWIG.
   * Debido a que no todos los componentes tienen el maps y el name obligatorio, se asume como regla que:
   * <ul>
   * 	<li><b>si tiene name</b>, se usa el name.</li>
   * 	<li><b>si no tiene name</b>, se usa el maps de la siguiente manera: $prefix.maps.$postfix</li>
   * </ul>
   * 
   * @param string $prefix el prefijo que emplea para generar los nombres cuando no existe el name.
   * @param string $suffix el sufijo que emplea para generar los nombres cuando no existe el name.
   * 
   * @return array El arreglo que representa el objeto y sus propiedades
   */
  public function toArray($prefix = "", $suffix = "")
  {
    // Bouml preserved body begin 00176805
	$aSecciones = array();
	if (is_array($this->sections) && (count($this->sections) > 0))
		foreach ($this->sections as $seccion)
			if (is_a($seccion, "ListSection"))
				$aSecciones[] = $seccion->toArray($prefix = "", $suffix = "");
	
	
	
	$aReport = array(
		"titulo" => $this->title,
		"cssClass" => $this->class,
		"secciones" => $aSecciones
	);
	return $aReport;
    // Bouml preserved body end 00176805
  }

}
?>