<?php
require_once 'iplan/web/Component.php';



/**
* Author: Jorge Alexis Viqueira
* 
*/
class Layout extends Component {
  /**
   * @var array la lista de elementos que se esquematizan en el layout
   */
  protected $items = array();

  /**
   * Agrega un componente al Layout
   * 
   * @param Component $element el elemento a agregar al layout
   * 
   * @return Layout el layout con el componente agregado.
   */
  public function addComponent($element)
  {
    // Bouml preserved body begin 000E8D05
    $this->items[]=$element;
    // Bouml preserved body end 000E8D05
  }

  /**
   * Recupera el componente que responde al nombre especificado.
   * 
   * @param string $name el nombre del componente a recuperar.
   * 
   * @return Component|array El componente solicitado o NULL sino existe. En el caso que se llame sin par�metros retorna un arreglo con todos los componentes del formulario en una sola lista.
   */
  public function &getComponent($name = null)
  {
    // Bouml preserved body begin 000FC905
	if ($name !== null) {
		if (is_array($this->items)) {
			foreach($this->items as $item) {
				if (($item->getName()==$name) || ($item->getMaps()==$name))
						return $item;
				elseif (is_a($item, 'Layout')) {
					$result = $item->getComponent($name);
					if (!is_null($result)) return $result;
				}
			}
		}
	} else {
		$aComponents = array();
		if (is_array($this->items)) {
			foreach($this->items as $item) {
				if (!is_a($item, 'Layout')) {
					$aComponents[] = $item;
				} else {
					$arr = $item->getComponent();
					if (is_array($arr)) {
						$aComponents = array_merge($aComponents, $arr);
					}
				}
			}
		}
		return ($aComponents);
	}
    return null;
	
    // Bouml preserved body end 000FC905
  }

  /**
   * Quita un componente del la formaci�n.
   * @param string name el nombre del componente a quitar.
   * 
   * @result Layout El layout sin el componente.
   */
  public function removeComponent($name)
  {
    // Bouml preserved body begin 0012E505
	if (is_array($this->items) && (count($this->items)>0)) {
		for($i=0;$i<count($this->items);$i++) {
			if (is_a($this->items[$i], 'Layout')) {
				$this->items[$i]->removeComponent($name);
			} elseif($this->items[$i]->getName()==$name) {
				unset ($this->items[$i]);
				break;
			}
		}
	}
	return $this;
    // Bouml preserved body end 0012E505
  }

  /**
   * Retorna un arreglo la definici�n del objeto a fin de que sea f�cilmente interpretable por un Template de TWIG.
   * Debido a que no todos los componentes tienen el maps y el name obligatorio, se asume como regla que:
   * <ul>
   * 	<li><b>si tiene name</b>, se usa el name.</li>
   * 	<li><b>si no tiene name</b>, se usa el maps de la siguiente manera: $prefix.maps.$postfix</li>
   * </ul>
   * 
   * @param string $prefix el prefijo que emplea para generar los nombres cuando no existe el name.
   * @param string $suffix el sufijo que emplea para generar los nombres cuando no existe el name.
   * 
   * @return array El arreglo que representa el objeto y sus propiedades
   */
  public function toArray($prefix = '', $suffix = '')
  {
    // Bouml preserved body begin 000E5185
    $result = array();
    foreach($this->items as $item) {
        $result[] = $item->toArray($prefix, $suffix);
    }
    
    return array(
                'type'  =>'layout',
                'name'  =>'default',
                'items' =>$result
        );
    // Bouml preserved body end 000E5185
  }

  /**
   * Retorna una versi�n string del nombre del componente y de su valor. S�lo sirve cuando ambos datos est�n definidos.
   * @param string $prefix el prefijo de los nombres generados.
   * @param string $suffix el sufijo de los nombres generados.
   * @return string una porci�n de URL que representa el componente y su valor o el string vac�o si no tiene un value asignado o si no tiene un name.
   */
  public function toURL($prefix = '', $suffix = '')
  {
    // Bouml preserved body begin 00131C05
	if (is_array($this->items) && (count($this->items)>0)) {
		$str='';
		foreach($this->items as $comp) {
			$tmpStr = $comp->toURL($prefix, $suffix);
			if ($tmpStr != '')
				$str .= $tmpStr."&";
		}
		if ($str != '')
			return substr($str, 0, strlen($str)-1);
		else return '';
	} else {
		return '';
	}
    // Bouml preserved body end 00131C05
  }

}
?>