<?php
require_once 'iplan/web/Component.php';



/**
* Author: Jorge Alexis Viqueira
* 
*/
class LabelComponent extends Component {
  /**
   * Retorna un arreglo la definici�n del objeto a fin de que sea f�cilmente interpretable por un Template de TWIG.
   * Debido a que no todos los componentes tienen el maps y el name obligatorio, se asume como regla que:
   * <ul>
   * 	<li><b>si tiene name</b>, se usa el name.</li>
   * 	<li><b>si no tiene name</b>, se usa el maps de la siguiente manera: $prefix.maps.$postfix</li>
   * </ul>
   * 
   * @param string $prefix el prefijo que emplea para generar los nombres cuando no existe el name.
   * @param string $suffix el sufijo que emplea para generar los nombres cuando no existe el name.
   * 
   * @return array El arreglo que representa el objeto y sus propiedades
   */
  public function toArray($prefix = "", $suffix = "")
  {
    // Bouml preserved body begin 0012D505
	return array_merge(parent::toArray($prefix, $suffix), array('type'=>'label'));
    // Bouml preserved body end 0012D505
  }

}
?>