<?php
require_once 'iplan/web/Layout.php';
require_once 'iplan/web/Component.php';
require_once 'iplan/web/EmptyComponent.php';



/**
* Author: Jorge Alexis Viqueira
* 
*/
class GridLayout extends Layout {
  /**
   * @var array mantiene una colecci�n de los items seg�n la estructura impuesta por el GridLayout
   */
  private $gridItems;

  /**
   * @var int la m�xima cantidad de filas del layout
   */
  protected $rows;

  /**
   * @var int el n�mero m�ximo de columnas que tiene la grilla del layout
   */
  protected $cols;

  /**
   * Crea una distribuci�n en grilla de las dimensiones indicadas.
   * 
   * @param int $rows la cantidad de filas de la grilla
   * @param int $cols la cantidad de columnas de la grilla
   * 
   * @return GridLayout La instancia de GridLayout 
   */
  public function __construct($rows, $cols)
  {
    // Bouml preserved body begin 000E5105
    $this->rows=$rows;
    $this->cols=$cols;
    return $this;
    // Bouml preserved body end 000E5105
  }

  /**
   * Agrega un componente al layout
   * 
   * @param Component $element el componente a agregar
   * @param int $row la fila del layout donde se ubica el componente
   * @param int $col la columna del layout donde se ubica el componente
   * @param int $horizontalSize el tama�o que ocupa el componente en la horizontal
   * @param int $verticalSize el tama�o que ocupa el componente en la vertical
   * @param string $halign la alineaci�n de los componentes en la celda respecto al eje X
   * @param string $valign la alineaci�n de los componentes en la celda respecto al eje Y
   * @return GridLayout El mismo objeto GridLayour modificado.
   */
  public function addComponent($element, $row = null, $col = null, $horizontalSize = 1, $verticalSize = 1, $halign = 'left', $valign = 'middle')
  {
    // Bouml preserved body begin 000E5085
	if (($row === null) || ($col === null)) throw new Exception("No se puede agregar un componente a un GridLayout sin indicar las coordenadas de fila y columna");
    //Chequeo las dimensiones de la grilla
    if ((($row+$verticalSize-1) <= $this->rows) && (($col+$horizontalSize-1) <= $this->cols)) {
        $this->gridItems[$row][$col]=array($element, $horizontalSize, $verticalSize, $halign, $valign);
		return $this;
    } else {
        throw new Exception("Desborde de la grilla. El layout es de [$this->rows,$this->cols] y se intentó ubicar un componente en [$row,$col] con dimensiones [H:$horizontalSize, V: $verticalSize]");
    }

    // Bouml preserved body end 000E5085
  }

  /**
   * Recupera el componente que responde al nombre especificado.
   * 
   * @param string $name el nombre del componente a recuperar.
   * @return Component|array El componente solicitado o NULL sino existe. En el caso que se llame sin par�metros retorna un arreglo con todos los componentes del formulario en una sola lista.
   */
  public function &getComponent($name = null)
  {
    // Bouml preserved body begin 000FC985
    /*if (is_array($this->gridItems)) {
        foreach($this->gridItems as $row) {
            foreach($row as $col) {
                list($component, $x, $y) = $col;
                if (($component->getName()==$name) || ($component->getMaps()==$name))
                        return $component;
                elseif($component->getType()=='layout') {
                    $result = $component->getComponent($name);
                    if (!is_null($result)) return $result;
                }
            }
        }
    }
    return null;
	*/
	$ret = null;
	if ($name !== null) {
		if (is_array($this->gridItems)) {
			foreach($this->gridItems as $row) {
				foreach($row as $col) {
					list($component, $x, $y, $ha, $va) = $col;
					if (($component->getName()==$name) || ($component->getMaps()==$name))
							return $component;
					elseif (is_a($component, 'Layout')) {
						$result = $component->getComponent($name);
						if (!is_null($result)) return $result;
					}
				}
			}
		}
	} else {
		$aComponents = array();
		if (is_array($this->gridItems)) {
			foreach($this->gridItems as $row) {
				foreach($row as $col) {
					list($item, $x, $y, $ha, $va) = $col;
					if (!is_a($item, 'Layout')) {
						$aComponents[] = $item;
					} else {
						$arr = $item->getComponent();
						if (is_array($arr)) {
							$aComponents = array_merge($aComponents, $arr);
						}
					}
				}
			}
		}
		return ($aComponents);
	}
    return $ret;
    // Bouml preserved body end 000FC985
  }

  /**
   * Quita un componente del layout
   * @param string name el nombre del componente a quitar.
   * 
   * @result GridLayout El formulario sin el componente.
   */
  public function removeComponent($name)
  {
    // Bouml preserved body begin 0012E585
	if (is_array($this->gridItems) && (count($this->gridItems)>0)) {
		for($row=0;$row<count($this->gridItems);$row++) {
			if (is_array($this->gridItems[$row]) && (count($this->gridItems[$row])>0)) {
				for($col=0;$col<count($this->gridItems[$row]);$col++) {
					if (is_a($this->gridItems[$row][$col][0], 'Layout')) {
						$this->gridItems[$row][$col][0]->removeComponent($name);
					} elseif($this->gridItems[$row][$col][0]->getName()==$name) {
						unset ($this->gridItems[$row][$col]);
						break;
					}
				}
			}
		}
	}
	return $this;
    // Bouml preserved body end 0012E585
  }

  /**
   * Retorna un arreglo la definici�n del objeto a fin de que sea f�cilmente interpretable por un Template de TWIG.
   * Debido a que no todos los componentes tienen el maps y el name obligatorio, se asume como regla que:
   * <ul>
   * 	<li><b>si tiene name</b>, se usa el name.</li>
   * 	<li><b>si no tiene name</b>, se usa el maps de la siguiente manera: $prefix.maps.$postfix</li>
   * </ul>
   * 
   * @param string $prefix el prefijo que emplea para generar los nombres cuando no existe el name.
   * @param string $postfix el sufijo que emplea para generar los nombres cuando no existe el name.
   * 
   * @return array El arreglo que representa el objeto y sus propiedades
   */
  public function toArray($prefix = '', $postfix = '')
  {
    // Bouml preserved body begin 000E7105
    $result = array();
    $empty = new EmptyComponent();
    
    for($row=1;$row <= $this->rows; $row++) {
        if (isset($this->gridItems[$row])) {
            $limitColumn=1;
            for($col=1; $col <= $this->cols; $col++) {
                if (isset($this->gridItems[$row][$col])) {
                    list($component, $width, $height, $halign, $valign) = $this->gridItems[$row][$col];
                    $result[$row][$col]=array($component->toArray($prefix, $postfix), $width, $height, $halign, $valign);
                    $limitColumn+=$width;
                } elseif ($limitColumn<$this->cols) {
                    $result[$row][$col]=array($empty->toArray($prefix, $postfix), 1, 1, 'center', 'middle');
                    $limitColumn++;
                }
            }
        }
    }
    return array_merge( parent::toArray($prefix, $postfix), array('name'=>'GridLayout', 'items'=>$result) );
    // Bouml preserved body end 000E7105
  }

  /**
   * Retorna una versi�n string del nombre del componente y de su valor. S�lo sirve cuando ambos datos est�n definidos.
   * @param string $prefix el prefijo de los nombres generados.
   * @param string $suffix el sufijo de los nombres generados.
   * @return string una porci�n de URL que representa el componente y su valor o el string vac�o si no tiene un value asignado o si no tiene un name.
   */
  public function toURL($prefix = '', $suffix = '')
  {
    // Bouml preserved body begin 00131C85
	if (is_array($this->gridItems) && (count($this->gridItems)>0)) {
		$str='';
		foreach($this->gridItems as $row) {
			if (is_array($row) && (count($row)>0)) {
				foreach($row as $col) {
					$tmpStr = $col[0]->toURL($prefix, $suffix);
					if ($tmpStr != '')
						$str .= $tmpStr."&";
				}
			}
		}
		if ($str != '')
			return substr($str, 0, strlen($str)-1);
		else return '';
	} else {
		return '';
	}
    // Bouml preserved body end 00131C85
  }

}
?>