<?php
require_once 'iplan/web/Component.php';



/**
* Author: Jorge Alexis Viqueira
* 
*/
/**
 * @method string|array getTypes()
 * @method FileComponent setTypes()
 */
class FileComponent extends Component {
  /**
   * @var string|array la lista de extensiones permitidas
   */
  protected $types;

  /**
   * Retorna un arreglo la definici�n del objeto a fin de que sea f�cilmente interpretable por un Template de TWIG.
   * Debido a que no todos los componentes tienen el maps y el name obligatorio, se asume como regla que:
   * <ul>
   * 	<li><b>si tiene name</b>, se usa el name.</li>
   * 	<li><b>si no tiene name</b>, se usa el maps de la siguiente manera: $prefix.maps.$postfix</li>
   * </ul>
   * 
   * @param string $prefix el prefijo que emplea para generar los nombres cuando no existe el name.
   * @param string $postfix el sufijo que emplea para generar los nombres cuando no existe el name.
   * 
   * @return array El arreglo que representa el objeto y sus propiedades
   */
  public function toArray($prefix = '', $postfix = '')
  {
    // Bouml preserved body begin 000E7085
	return array_merge(parent::toArray($prefix, $postfix), array('types'=> $this->types, 'type' => 'file'));
    // Bouml preserved body end 000E7085
  }

  /**
   * Hace las operaciones necesarias para poner el archivo en la carpeta indicada e incluso renombrarlo.
   * @param array $fileData la informaci�n de $_FILES[] obtenida por Form::getValueOf()
   * @param string $path el directorio donde ubicar la copia
   * @param string $newName en caso que no se desee usar el nombre original, es posible cambiarselo a otro arbitrario.
   * 
   * @return string La ruta al archivo definitivo.
   */
  public function placeIn($fileData, $path, $newName = null)
  {
    // Bouml preserved body begin 0013BF05
	if (substr($path, -1, 1) != DIRECTORY_SEPARATOR)
		$path .= DIRECTORY_SEPARATOR;
	if (is_null($newName))
		$newName = $fileData['name'];
	
	if (@move_uploaded_file($fileData['tmp_name'], $path.$newName))
		return $path.$newName;
	else throw new Exception('No se pudo mover el archivo temporal "'.$fileData['tmp_name']."\" a $path$newName");
    // Bouml preserved body end 0013BF05
  }

}
?>