<?php
require_once 'iplan/web/Form.php';
require_once 'iplan/web/WebList.php';
require_once 'iplan/security/AbstractManager.php';
require_once 'iplan/security/Renderable.php';
require_once 'iplan/security/ApplicationContext.php';
require_once 'iplan/orm/ORM.php';



/**
* Author: Jorge Alexis Viqueira
* 
*/
class DetailWebList extends WebList {
  /**
   * @var Form el formulario de detalle
   */
  private $detail;

  /**
   * @var string el template del detalle
   */
  private $detailTemplate;

  /**
   * @var Closure la funcion asociada al formulario de detalle
   */
  private $detailFunction;

  /**
   * Crea una instancia de WebList.
   * @param AbstractManager $manager El manager en el cual se est� creando el listado.
   * 
   * @return WebList una instancia nueva de la clase.
   */
  public function __construct(&$manager = null)
  {
    // Bouml preserved body begin 0015E505
	return parent::__construct($manager);
    // Bouml preserved body end 0015E505
  }

  /**
   * Retorna un arreglo la definici�n del objeto a fin de que sea f�cilmente interpretable por un Template de TWIG.
   * Debido a que no todos los componentes tienen el maps y el name obligatorio, se asume como regla que:
   * <ul>
   * 	<li><b>si tiene name</b>, se usa el name.</li>
   * 	<li><b>si no tiene name</b>, se usa el maps de la siguiente manera: $prefix.maps.$postfix</li>
   * </ul>
   * 
   * @param string $prefix el prefijo que emplea para generar los nombres cuando no existe el name.
   * @param string $postfix el sufijo que emplea para generar los nombres cuando no existe el name.
   * 
   * @return array El arreglo que representa el objeto y sus propiedades
   */
  public function toArray($prefix = '', $postfix = '')
  {
    // Bouml preserved body begin 0015E185
	$aDetail = array();
	if (isset($this->detail) && (is_a($this->detail, "Form"))) {
		$aDetail = array("detail" => $this->detail->toArray($prefix, $postfix));
	}
    return array_merge($aDetail, parent::toArray($prefix, $postfix));
    // Bouml preserved body end 0015E185
  }

  /**
   * Retorna la instancia necesaria para renderizar del listado.
   * 
   * @param ApplicationContext $context el contexto en el cual el Form debe hacer su trabajo.
   * @param ORM $orm el ORM a usar
   * 
   * @return Renderable el objeto que representa el listado o la secci�n del listado que se debe desplegar.
   */
  public function deploy(&$context, &$orm)
  {
    // Bouml preserved body begin 0015E205
	if ((!isset($this->detail)) || (!is_a($this->detail, "Form"))) {
		return parent::deploy($context, $orm);
	}
	  
	//Seteo el contexto al detalle.
	$this->detail->setContext($context);
	$this->detail->setTarget('div_detail_form');
	//Parche para poder usar leer datos del filtro desde la funcion.
	$this->getFilter()->setContext($context);
	
	
	$isAjax = $context->get('AJAX');
	$detail_action = $context->getParam($this->detail->getPrefix() . 'uws_detail_action' . $this->detail->getSuffix(), 'FULL_PAGE', 'PG');
	$list_action = $context->getParam($this->getFilter()->getPrefix() .'uws_list_action' . $this->getFilter()->getSuffix(), 'WITH_FILTER', 'PG');
	
	$detail_action = (!$isAjax) ? "FULL_PAGE": $detail_action;
	
	
	$comp_detail_action = new HiddenComponent();
	$comp_detail_action->setId('uws_id_detail_action')
					 ->setName('uws_detail_action')
					 ->setValue('ONLY_DETAIL');
	$this->detail->addComponent($comp_detail_action);
	
	$comp_list_action = new HiddenComponent();
	$comp_list_action->setId('uws_id_list_action')
					 ->setName('uws_list_action')
					 ->setValue($list_action);
	$this->detail->addComponent($comp_list_action);
	
	//Ejecuto la funcion del list.
	$funcion = $this->detailFunction;
	if ((!is_null($funcion)) && ($mainResult = $funcion($this->manager, $this, $context, $orm))) {
		if ($mainResult) {
			$context->set("showDetailForm", true);
		}
	}
	if ($detail_action == 'ONLY_DETAIL') {
		$parent_deploy = parent::deploy($context, $orm);
		return new Renderable("list_detail.xhtml");
	}
	
	//Hago un deploy del padre.
	$parent_deploy = parent::deploy($context, $orm);
	return $parent_deploy;
    // Bouml preserved body end 0015E205
  }

  /**
   * Retorna el nombre del template de detalle.
   * 
   * @return string el path+archivo del template.
   */
  final public function getDetailTemplate()
  {
    return $this->detailTemplate;
  }

  /**
   * Configura el template a usar para el detalle.
   * 
   * @param string $value el path+template
   * @return DetailWebList El listado modificado.
   */
  public function setDetailTemplate($value)
  {
    $this->detailTemplate = $value;
    return $this;
  }

  /**
   * La funcion asociada al detalle de listado.
   * 
   * @param Closure $func la funcion.
   * @return DetailWebList el listado con la funcion de detalle configurada.
   */
  public function setDetailFunction($func)
  {
    // Bouml preserved body begin 0015E385
	$this->detailFunction = $func;
	return $this;
    // Bouml preserved body end 0015E385
  }

  /**
   * Recupera el formulario de detalle.
   * @return Form el formulario de detalle configurado.
   */
  final public function getDetail()
  {
    return $this->detail;
  }

  /**
   * Configura el formulario de detalle
   * 
   * @param Form $value la instancia de formulario a utilizar.
   * @return DetailWebList el listado con la instancia configurada.
   */
  public function setDetail($value)
  {
	$value->setPrefix("detail_");
    $this->detail = $value;
    return $this;
  }

}
?>