<?php
require_once 'iplan/web/Component.php';



/**
* Author: Jorge Alexis Viqueira
* 
*/
class DateComponent extends Component {
  /**
   * @const int Un valor que indica al calendario que se muestre en la vista normal, es decir, día por día.
   */
  const NORMAL_VIEW = 0;

  /**
   * @const int Un valor que indica al calendario que se muestre en formato de selección por semana.
   */
  const WEEK_VIEW = 1;

  /**
   * @var string una cadena de formato basado en jQuery
   */
  protected $format;

  /**
   * @var int indica si el calendario es normal o si se emplea una vista semanal para las selecciones.
   */
  protected $calendarView = DateComponent::NORMAL_VIEW;

  /**
   * Crea un componente.
   * @param string $label el r�tulo del componente
   * @param string $name el nombre del componente
   * @param string $maps el valor al que mapea el componente
   * @param string $format el formato de la fecha acorde a la documentaci�n de PHP
   * @param mixed $value el valor predeterminado del componente
   * @param string $template el template a utilizar para el renderizado
   * @return DateComponent La instancia del componente inicializada.
   */
  public function __construct($label = null, $name = null, $maps = null, $format = "Y-m-d", $value = null, $template = null)
  {
    // Bouml preserved body begin 0015C805
	parent::__construct($label, $name, $maps, $value, $template);
	$this->format = $format;
    // Bouml preserved body end 0015C805
  }

  /**
   * Retorna un arreglo la definici�n del objeto a fin de que sea f�cilmente interpretable por un Template de TWIG.
   * Debido a que no todos los componentes tienen el maps y el name obligatorio, se asume como regla que:
   * <ul>
   * 	<li><b>si tiene name</b>, se usa el name.</li>
   * 	<li><b>si no tiene name</b>, se usa el maps de la siguiente manera: $prefix.maps.$postfix</li>
   * </ul>
   * 
   * @param string $prefix el prefijo que emplea para generar los nombres cuando no existe el name.
   * @param string $suffix el sufijo que emplea para generar los nombres cuando no existe el name.
   * 
   * @return array El arreglo que representa el objeto y sus propiedades
   */
  public function toArray($prefix = "", $suffix = "")
  {
    // Bouml preserved body begin 0015C785
	$this->format = isset($this->format) ? $this->format : "Y-m-d";
	
	$maps=array(
		'd'=>'dd',
		'j'=>'d',
		'm'=>'mm',
		'n'=>'m',
		//'y'=>'y',
		'Y'=>'yy'
	);
	
	$jqueryFormat = str_replace(array_keys($maps), $maps, $this->format);
	if ($this->getValue()) {
		$val = date_format($this->getValue(), $this->format);
	} else {
		$val = null;
	}
	return array_merge(parent::toArray($prefix, $suffix), array('type'=>'date', 'format'=> $jqueryFormat, 'value'=>$val));
    // Bouml preserved body end 0015C785
  }

  /**
   * Retorna una versi�n string del nombre del componente y de su valor. S�lo sirve cuando ambos datos est�n definidos.
   * @param string $prefix el prefijo del nombre del elemento
   * @param string suffix el sufijo del nombre del elemento
   * @return string una porci�n de URL que representa el componente y su valor o el string vac�o si no tiene un value asignado o si no tiene un name.
   */
  public function toURL($prefix = '', $suffix = '')
  {
    // Bouml preserved body begin 0016B405
	if (!is_null($this->getName()) && !is_null($this->getValue()) && ($this->getValue() != '')) {
		$this->format = isset($this->format) ? $this->format : "Y-m-d";
		if (is_a($this->getValue(), 'DateTime')) {
			return $prefix.$this->getName().$suffix."=".date_format($this->getValue(), $this->format);
		} else {
			return $prefix.$this->getName().$suffix."=".$this->getValue();
		}
	} else {
		return '';
	}
    // Bouml preserved body end 0016B405
  }

  /**
   * Función que sirve para cambiar la forma de visualizar el calendario, de una vista diaria a una semanal.
   * 
   * @param int$viewType si es true se altera la forma diaria normal a una donde la selección es visualmente por semana. Las constates son DateComponente::NORMAL_VIEW y DateComponent::WEEK_VIEW
   * @return DateComponent El componente de fecha la el formato de visualización configurado.
   */
  public function setView($viewType)
  {
    // Bouml preserved body begin 00181F85
	$this->weekCalendar = $viewType;
	return $this;
    // Bouml preserved body end 00181F85
  }

  /**
   * Retorna la semana que representa la fecha del calendario usando el estándar ISO 8601.
   * 
   * @return int el número de la semana del año. Si el valor del componente no está definido retorna "0".
   */
  public function getWeek()
  {
    // Bouml preserved body begin 00182005
	$value = $this->getValue();
	if ($value) {
		$fecha = DateTime::createFromFormat($this->format, $value);
		return $fecha->format('W');
	} else {
		return 0;
	}
    // Bouml preserved body end 00182005
  }

  /**
   * Recupera la fecha del primer día de la semana de la fecha que tiene configurada el componente.
   * 
   * @return DateTime la fecha de inicio de la semana que inicia.
   */
  public function getWeekStart()
  {
    // Bouml preserved body begin 00182085
	$value = $this->getValue();
	if ($value) {
		$anio = $fecha->format('Y');
		$fecha = DateTime::createFromFormat($this->format, $value);
		$enero1=date("N",mktime(0,0,0,1,1,$anio)); 
		if ($enero1 < 5) {
			$dias = -($enero1-1)*86400;
		} else {
			$dias = (8-$enero1)*86400;
		}
		$semana = $fecha->format('W');
		if ($semana>1) $semanasTranscurridas = ($semana-1)*604800;
		else $semanasTranscurridas = 0;
		return $timestamp = mktime(0,0,0,1,1,$anio)+$semanasTranscurridas+$dias; 
	} else {
		return 0;
	}
    // Bouml preserved body end 00182085
  }

}
?>