<?php
require_once 'iplan/web/TemplateInterface.php';
require_once 'iplan/web/ActionButton.php';
require_once 'iplan/web/ActionInterface.php';
require_once 'iplan/web/Component.php';



/**
* Author: Jorge Alexis Viqueira
* 
*/
class Column implements TemplateInterface, ActionInterface {
  /**
   * @var array acciones que afectan a la fila solicitada
   */
  private $actions;

  /**
   * @var string el t�tulo de la columna. Puede ser HTML
   */
  private $title;

  /**
   * @var string|array el nombre de una o m�s columnas del conjunto de resultados que se emplear�n en la generaci�n del contenido de cada celda de la columna
   */
  private $maps;

  /**
   * @var string una descripci�n de qu� es la informaci�n que se exhibe en la columna.
   */
  private $hint;

  /**
   * @var boolean indica si la columna debe ponerse como invisible
   */
  private $hide;

  /**
   * @var string una cadena de texto optativa que sirve para especificar renderizados especiales de las variables del "maps". Usa sintaxis TWIG
   */
  private $template;

  /**
   * @var boolean indica si la columna puede ser ordenada autom�ticamente. En caso de ser TRUE genera que se ubique un bot�n en el header de la columna que al apretarlo alterna la consulta entre DESC y ASC
   */
  private $sortable;

  /**
   * @var string el c�digo de la acci�n del sistema
   */
  private $action;

  /**
   * @var string el modo de ejecuci�n de la acci�n: inline, popup, inline-popup
   */
  private $mode;

  /**
   * @var array un arreglo clave valor con los par�metros a pasar a la acci�n
   */
  private $params;

  /**
   * @var string el �cono de la acci�n
   */
  private $icon;

  /**
   * @var string la t�cnica de refresco luego de ejecutada la acci�n: none, list, row
   */
  private $refresh;

  /**
   * @var string El nombre �nico de la columna. Usado para referenciarla internamente y por las acciones de ordenamiento.
   */
  private $name;

  /**
   * @var boolean indica si la columna debe mostrarse o no en las exportaciones.
   */
  private $exportable;

  /**
   * Crea una columna
   * @param string $title el t�tulo de la columna
   * @param string|array $maps el o los campos que se visualizar�n en la columna
   * @param boolean $sortable si la columna se puede ordenar pasar TRUE
   * @param string $template el template a emplear
   * @param boolean $exportable indica si la columna se puede exportar.
   * @param string $action la acci�n que se ejecuta al hacer clic en el contenido de la celda
   * @param array $actions las acciones espec�ficas de la fila.
   * @param boolean $hide Decide si oculta la columna.
   * @return Column La columna nueva
   */
  public function __construct($title = null, $maps = null, $sortable = false, $template = null, $exportable = true, $action = null, $actions = null, $hide = false)
  {
    // Bouml preserved body begin 00126A05
	if (!is_array($title)) {
		$defaults = array(	"title" => $title,
							"maps" => $maps,
							"sortable" => $sortable,
							"template" => $template,
							"exportable" => $exportable,
							"action" => $action,
							"actions" => $actions,
							"hide" => $hide
					);
	}
	if (is_array($title)) {
		$defaults = array(	"title" => null,
							"maps" => null,
							"sortable" => false,
							"template" => null,
							"exportable" => true,
							"action" => null,
							"actions" => null,
							"hide" => false
					);
	$defaults = array_merge($defaults, $title);
	}
	foreach ($defaults as $key => $value) {
		$this->$key = $value;
	}
	return $this;
    // Bouml preserved body end 00126A05
  }

  /**
   * Configura el c�digo de la acci�n a ejecutar
   * 
   * @param string $action el c�digo de la acci�n
   * 
   * @return ActionInterface la acci�n modificada
   */
  public function setAction($action)
  {
    // Bouml preserved body begin 000EDD85
    $this->action=$action;
    return $this;
    // Bouml preserved body end 000EDD85
  }

  /**
   * Retorna la acci�n configurada.
   * 
   * @return string el c�digo de la acci�n
   */
  public function getAction()
  {
    // Bouml preserved body begin 000F2005
	return $this->action;
    // Bouml preserved body end 000F2005
  }

  /**
   * El modo de ejecuci�n de la acci�n.
   * 
   * @param string $mode la forma en la cual la acci�n es invocada. Puede ser:
   * <ul><li>none, la acci�n se env�a a ejecutar y no requiere retorno al usuario</li>
   *     <li>inline, la acci�n se ejecuta como un link</li>
   *     <li>popup, el resultado de la acci�n se vuelca en un popup</li>
   *     <li>inline-popup, el resultado de la acci�n se devuelve en una ventana hecha con javascript y DOM</li>
   * </ul>
   */
  public function setMode($mode)
  {
    // Bouml preserved body begin 000EDE05
    $this->mode=$mode;
    return $this;
    // Bouml preserved body end 000EDE05
  }

  /**
   * Recupera el modo de ejecuci�n
   * 
   * @return string el modo de ejecuci�n de la acci�n
   */
  public function getMode()
  {
    // Bouml preserved body begin 000F2085
    return $this->mode;
    // Bouml preserved body end 000F2085
  }

  /**
   * Configura par�metros adicionales para la acci�n ejecutada.
   * 
   * @params string $params los par�metros a pasar a la acci�n
   * 
   * @return ActionInterface el objeto con los par�metros modificados
   */
  public function setParams($params)
  {
    // Bouml preserved body begin 000EDE85
    $this->params=$params;
    return $this;
    // Bouml preserved body end 000EDE85
  }

  /**
   * Devuelve los par�metros adicionales.
   * 
   * @return string los par�metros adicionales que se hayan configurado en la acci�n
   */
  public function getParams()
  {
    // Bouml preserved body begin 000F2105
    return $this->params;
    // Bouml preserved body end 000F2105
  }

  /**
   * El �cono para la acci�n
   * @param string $icon el icono a configurar en la acci�n
   * @return ActionInterface el objeto configurado con el �cono seleccionado
   */
  public function setIcon($icon)
  {
    // Bouml preserved body begin 000EDF05
    $this->icon=$icon;
    return $this;
    // Bouml preserved body end 000EDF05
  }

  /**
   * Devuelve la imagen de la acci�n.
   * 
   * @return string recupera la imagen de la acci�n
   */
  public function getIcon()
  {
    // Bouml preserved body begin 000F2185
    return $this->icon;
    // Bouml preserved body end 000F2185
  }

  /**
   * Configura el esquema de refresco de la acci�n
   * 
   * @param string $refresh el modo de refresco de la acci�n
   * @return ActionInterface el objeto con el m�todo de refresco seleccionado
   */
  public function setRefresh($refresh)
  {
    // Bouml preserved body begin 000EDF85
    $this->refresh=$refresh;
    return $this;
    // Bouml preserved body end 000EDF85
  }

  /**
   * Recupera el m�todo de refresco de la acci�n
   * 
   * @return string recupera el m�todo de refresco de la acci�n
   */
  public function getRefresh()
  {
    // Bouml preserved body begin 000F2205
    return $this->refresh;
    // Bouml preserved body end 000F2205
  }

  /**
   * Configura el t�tulo de la columna.
   * 
   * @param string $title el t�tulo que se desea asignar a la columna
   * @return Column la columna modificada
   */
  public function setTitle($title)
  {
    // Bouml preserved body begin 000F3F05
    $this->title=$title;
    return $this;
    // Bouml preserved body end 000F3F05
  }

  /**
   * Recupera el t�tulo de la columna
   * 
   * @return string el t�tulo de la columna
   */
  public function getTitle()
  {
    // Bouml preserved body begin 000F3F85
    return $this->title;
    // Bouml preserved body end 000F3F85
  }

  /**
   * Indica la/s clave/s de columna/s a utilizar en la generaci�n del contenido de la celda.
   * 
   * @param string|array $maps el nombre de la columna de datos o un arreglo con los nombres de columnas de datos a renderizar.
   * 
   * @return Column la columna modificada.
   */
  public function setMaps($maps)
  {
    // Bouml preserved body begin 000F4005
    $this->maps = $maps;
    return $this;
    // Bouml preserved body end 000F4005
  }

  /**
   * Recupera las columnas de datos que se mapean en el contenido de la celda.
   * 
   * @return string|array El nombre de la columna de datos que se usa para generar el contenido de cada celda o un arreglo con varios nombres usados a tal fin.
   */
  public function getMaps()
  {
    // Bouml preserved body begin 000F4085
    return $this->maps;
    // Bouml preserved body end 000F4085
  }

  /**
   * Configura el texto de ayuda/accesibilidad de la columna.
   * 
   * @param string $value el hint a setear.
   * 
   * @return Column la columna modificada
   */
  public function setHint($value)
  {
    $this->hint = $value;
    return $this;
  }

  /**
   * Retorna el texto de ayuda/explicativo de la columna
   * 
   * @return string Una cadena que sirve para identificar la misi�n de la columna
   */
  final public function getHint()
  {
    return $this->hint;
  }

  /**
   * Indica si la columna debe o no ser visible.
   * 
   * @param boolean True para indicar que la columna se dibuje oculta.
   * 
   * @return Column La columna con el flag cambiado
   */
  public function setHide($value)
  {
    $this->hide = $value;
    return $this;
  }

  /**
   * Recupera el nombre de la columna.
   * 
   * @return string Devuelve un string con el nombre de la columna.
   */
  final public function getName()
  {
    return $this->name;
  }

  /**
   * Configura el nombre interno de la columna.
   * 
   * @param string $value el nombre que para bautizar la columna. Este nombre es utilizado internamente por el sistema de ordenamiento.
   * 
   * @return Column La columna con el nombre configurado.
   */
  public function setName($value)
  {
    $this->name = $value;
    return $this;
  }

  /**
   * Retorna si la columna se renderiza con display:none
   * 
   * @return boolean Un TRUE si la columna es invisible
   */
  final public function getHide()
  {
    return $this->hide;
  }

  /**
   * Permite personalizar la forma en que se renderiza una celda.
   * 
   * @param string $value una cadena de texto que sigue las pautas y formatos de los templates TWIG. Soporta, obviamente, HTML y es posible acceder a las variables del maps directamente.
   * 
   * @return Column la columna con el template configurado
   */
  public function setTemplate($value)
  {
    $this->template = $value;
    return $this;
  }

  /**
   * Recupera el template de celda que est� empleando la columna.
   * 
   * @return string Un texto con el template que actualmente usa la columna o null si se trata de la renderizaci�n predeterminada.
   */
  final public function getTemplate()
  {
    return $this->template;
  }

  /**
   * Establece si la columna puede o no ordenarse alternativamente por ASC y DESC.
   * 
   * @param boolean $value un TRUE para indicar que la columna se puede "reordenar".
   * 
   * @return Column La columna con los cambios aplicados.
   */
  public function setSortable($value)
  {
    $this->sortable = $value;
    return $this;
  }

  /**
   * Indica si la columna est� configurada como ordenable.
   * 
   * @return boolean TRUE para indicar que la columna es ordenable.
   */
  final public function getSortable()
  {
    return $this->sortable;
  }

  /**
   * Agrega una acci�n que se puede ejecutar con los datos de la fila
   * 
   * @param ActionButton $action la acci�n que se quiere mostrar
   * 
   * @return Column la columna con la acci�n agregada
   */
  public function addAction($action)
  {
    // Bouml preserved body begin 000F5E05
    $this->actions[] = $action;
    return $this;
    // Bouml preserved body end 000F5E05
  }

  /**
   * @return array Un arreglo con las acciones configuradas para cada fila
   */
  public function getActions()
  {
    // Bouml preserved body begin 000F5E85
    return $this->actions;
    // Bouml preserved body end 000F5E85
  }

  /**
   * Devuelve si la columna debe o no mostrarse en las exportaciones.
   * 
   * @return boolean TRUE si tiene que verse en exportaci�n y FALSE sino.
   */
  final public function getExportable()
  {
    return $this->exportable;
  }

  /**
   * Configura si la columna debe ser mostrable en exportaci�n o no.
   * 
   * @param boolean $value un TRUE para que sea visible y FALSE para que no.
   * 
   * @return Column la columna modificada
   */
  public function setExportable($value)
  {
    $this->exportable = $value;
  }

  /**
   * Retorna un arreglo la definici�n del objeto a fin de que sea f�cilmente interpretable por un Template de TWIG.
   * Debido a que no todos los componentes tienen el maps y el name obligatorio, se asume como regla que:
   * <ul>
   * 	<li><b>si tiene name</b>, se usa el name.</li>
   * 	<li><b>si no tiene name</b>, se usa el maps de la siguiente manera: $prefix.maps.$postfix</li>
   * </ul>
   * 
   * @param string $prefix el prefijo que emplea para generar los nombres cuando no existe el name.
   * @param string $postfix el sufijo que emplea para generar los nombres cuando no existe el name.
   * 
   * @return array El arreglo que representa el objeto y sus propiedades
   */
  public function toArray($prefix = '', $postfix = '')
  {
    // Bouml preserved body begin 000F2585
    $actions = array();
	if (is_array($this->actions) && (count($this->actions) > 0))
		foreach($this->actions as $action)
            $actions[]=$action->toArray();
    
	if (is_null($this->name) || $this->name=="") {
		if (is_string($this->maps)) {
			$this->name = $prefix.$this->maps.$postfix;
		} elseif (is_array($this->maps)) {
			$this->name = $prefix.implode("_", $this->maps).$postfix;
		}
	}
	if (is_string($this->params)) {
		$params = array($this->params);
	} else $params = $this->params;
    return array(
        'action'    =>  $this->action,
        'actions'   =>  $actions,
		'name'		=>  $this->name,
        'hide'      =>  $this->hide,
        'hint'      =>  $this->hint,
        'icon'      =>  $this->icon,
        'maps'      =>  $this->maps,
        'mode'      =>  $this->mode,
        'params'    =>  $params,
        'refresh'   =>  $this->refresh,
        'sortable'  =>  $this->sortable,
        'template'  =>  $this->template,
        'title'     =>  $this->title,
		'exportable'=>  $this->exportable,
    );
    // Bouml preserved body end 000F2585
  }

}
?>