<?php
require_once 'iplan/web/Component.php';



/**
* Author: Jorge Alexis Viqueira
* 
*/
/**
 * @method mixed getChecked()
 * @method CheckboxComponent setChecked()
 * @method CheckboxComponent  setOptions()
 * @method array getOptions()
 */
class CheckboxComponent extends Component {
  /**
   * @var array las alternativas que el componente expone al usuario
   */
  protected $options;

  /**
   * @var bool Indica si est� chequeado o no.
   */
  protected $checked;

  /**
   * Retorna un arreglo la definici�n del objeto a fin de que sea f�cilmente interpretable por un Template de TWIG.
   * Debido a que no todos los componentes tienen el maps y el name obligatorio, se asume como regla que:
   * <ul>
   * 	<li><b>si tiene name</b>, se usa el name.</li>
   * 	<li><b>si no tiene name</b>, se usa el maps de la siguiente manera: $prefix.maps.$postfix</li>
   * </ul>
   * 
   * @param string $prefix el prefijo que emplea para generar los nombres cuando no existe el name.
   * @param string $postfix el sufijo que emplea para generar los nombres cuando no existe el name.
   * 
   * @return array El arreglo que representa el objeto y sus propiedades
   */
  public function toArray($prefix = '', $postfix = '')
  {
    // Bouml preserved body begin 000E7005
    return array_merge(parent::toArray($prefix, $postfix), array('checked'=>$this->checked, 'type'=>'checkbox', 'options'=>$this->options));
    // Bouml preserved body end 000E7005
  }

  /**
   * Crea un componente.
   * @param string $label el r�tulo del componente
   * @param string $name el nombre del componente
   * @param string $maps el valor al que mapea el componente
   * @param mixed $value el valor predeterminado del componente
   * @param mixed $checked el valor predeterminado del componente
   * @param string $template el template a utilizar para el renderizado
   * @return CheckboxComponent La instancia del componente inicializada.
   */
  public function __construct($label = null, $name = null, $maps = null, $value = null, $checked = null, $template = null)
  {
    // Bouml preserved body begin 00160305
	parent::__construct($label, $name, $maps, $value, $template);
	$this->checked = (is_null($checked))?false:$checked;
    // Bouml preserved body end 00160305
  }

  /**
   * Retorna una versi�n string del nombre del componente y de su valor. S�lo sirve cuando ambos datos est�n definidos.
   * @param string $prefix el prefijo del nombre del elemento
   * @param string suffix el sufijo del nombre del elemento
   * @return string una porci�n de URL que representa el componente y su valor o el string vac�o si no tiene un value asignado o si no tiene un name.
   */
  public function toURL($prefix = '', $suffix = '')
  {
    // Bouml preserved body begin 001D9985
	if ($this->checked)
		return parent::toURL($prefix, $suffix);
	else 
		return '';
    // Bouml preserved body end 001D9985
  }

}
?>