<?php
require_once 'iplan/web/Component.php';



/**
* Author: Jorge Alexis Viqueira
* 
*/
/**
 * @method ButtonComponent setAction()
 * @method string getAction()
 */
class ButtonComponent extends Component {
  /**
   * @var string la acci�n predeterminada del bot�n: submit, reset y a futuro otras opciones
   */
  protected $action;

  /**
   * @var string un c�digo JS que se vincular� a los eventos de bot�n.
   */
  protected $script;

  /**
   * Retorna un arreglo la definici�n del objeto a fin de que sea f�cilmente interpretable por un Template de TWIG.
   * Debido a que no todos los componentes tienen el maps y el name obligatorio, se asume como regla que:
   * <ul>
   * 	<li><b>si tiene name</b>, se usa el name.</li>
   * 	<li><b>si no tiene name</b>, se usa el maps de la siguiente manera: $prefix.maps.$postfix</li>
   * </ul>
   * 
   * @param string $prefix el prefijo que emplea para generar los nombres cuando no existe el name.
   * @param string $postfix el sufijo que emplea para generar los nombres cuando no existe el name.
   * 
   * @return array El arreglo que representa el objeto y sus propiedades
   */
  public function toArray($prefix = '', $postfix = '')
  {
    // Bouml preserved body begin 000E8C05
	return array_merge(parent::toArray($prefix, $postfix), array('type'=>'button', 'action'=>$this->action, 'script'=>$this->script));
    // Bouml preserved body end 000E8C05
  }

  /**
   * Retorna una versi�n string del nombre del componente y de su valor. S�lo sirve cuando ambos datos est�n definidos.
   * @param string $prefix el prefijo del nombre del elemento
   * @param string suffix el sufijo del nombre del elemento
   * @return string una porci�n de URL que representa el componente y su valor o el string vac�o si no tiene un value asignado o si no tiene un name.
   */
  public function toURL($prefix = '', $suffix = '')
  {
    // Bouml preserved body begin 00131E05
	return '';//Los botones NO DEVUELVEN NADA (sólo tiene sentido si se activan y en tiempo de interpretación NADIE PRESIONA NADA)
    // Bouml preserved body end 00131E05
  }

  /**
   * Crea un componente.
   * @param string $value el nombre del componente
   * @param string $action la acci�n del bot�n
   * @param string $scritp el c�digo javascript a ejecutar al presionar el bot�n
   * @return Component La instancia del componente inicializada.
   */
  public function __construct($value = null, $action = null, $script = null)
  {
    // Bouml preserved body begin 00144D85
	if (is_array($value))
		parent::__construct($value);
	else {
		parent::__construct(null, null, null, $value);
		$this->action = $action;
		$this->script = $script;
	}
	return $this;
    // Bouml preserved body end 00144D85
  }

}
?>