<?php



/**
* Author: Jorge Alexis Viqueira
* 
*/
/**
 * Interfaz de una accin del sistema de listado
 */
interface ActionInterface {
  /**
   * Configura el cdigo de la accin a ejecutar
   * 
   * @param string $action el cdigo de la accin
   * 
   * @return ActionInterface la accin modificada
   */
  public function setAction($action);
  /**
   * Retorna la accin configurada.
   * 
   * @return string el cdigo de la accin
   */
  public function getAction();
  /**
   * El modo de ejecucin de la accin.
   * 
   * @param string $mode la forma en la cual la accin es invocada. Puede ser:
   * <ul><li>none, la accin se enva a ejecutar y no requiere retorno al usuario</li>
   *     <li>inline, la accin se ejecuta como un link</li>
   *     <li>popup, el resultado de la accin se vuelca en un popup</li>
   *     <li>inline-popup, el resultado de la accin se devuelve en una ventana hecha con javascript y DOM</li>
   * </ul>
   */
  public function setMode($mode);
  /**
   * Recupera el modo de ejecucin
   * 
   * @return string el modo de ejecucin de la accin
   */
  public function getMode();
  /**
   * Configura parmetros adicionales para la accin ejecutada.
   * 
   * @params string $params los parmetros a pasar a la accin
   * 
   * @return ActionInterface el objeto con los parmetros modificados
   */
  public function setParams($params);
  /**
   * Devuelve los parmetros adicionales.
   * 
   * @return string los parmetros adicionales que se hayan configurado en la accin
   */
  public function getParams();
  /**
   * El cono para la accin
   * @param string $icon el icono a configurar en la accin
   * @return ActionInterface el objeto configurado con el cono seleccionado
   */
  public function setIcon($icon);
  /**
   * Devuelve la imagen de la accin.
   * 
   * @return string recupera la imagen de la accin
   */
  public function getIcon();
  /**
   * Configura el esquema de refresco de la accin
   * 
   * @param string $refresh el modo de refresco de la accin
   * @return ActionInterface el objeto con el mtodo de refresco seleccionado
   */
  public function setRefresh($refresh);
  /**
   * Recupera el mtodo de refresco de la accin
   * 
   * @return string recupera el mtodo de refresco de la accin
   */
  public function getRefresh();
}
?>