<?php
require_once 'iplan/web/Component.php';



/**
* Author: Jorge Alexis Viqueira
* 
*/
class ActionComponent extends Component {
  /**
   * @var string el modo de ejecución de la acción
   */
  protected $mode;

  /**
   * @var string la condición a ser chequeada antes demostrar el botón
   */
  protected $condition;

  /**
   * @var string un mensaje a mostrar en caso que la acción esté indicada como crítica
   */
  protected $message;

  /**
   * @var string el nombre de un ícono personalizado
   */
  protected $icon;

  /**
   * @var string el modo de refresco
   */
  protected $refresh;

  /**
   * Este constructor puede usarse de modo habitual sin parámetros ó, en caso de querer aprovechar la configuración automática, es posible pasarle sólo la acción para que se configure sola.
   * @param string $label un rótulo opcional para el botón
   * @param string $name el nombre del componente
   * @param string $actionStr una cadena de texto de la forma "FacadeAlias.ActionAlias"
   * @param string|array $params un conjunto de parámetros adicionales a pasarle a la acción
   * @param string|array $maps los parámetros a mapear para invocar la accción.
   * @param string $mode el modo de apertura o ejecución de la acción
   * @param string $condition una condición que debe ser cumplida para que se visualice la acción. Se escribe como template de Twig.
   * @param string $message un mensaje a mostrar al usuario en ciertos modos.
   * @param string $icon el ícono de la acción
   * @param string $refresh la forma en la que se debe refrescar la pantalla tras la ejecución de la acción
   * 
   * @return ActionComponent La instancia del botón con los parámetros indicados configurados.
   */
  public function __construct($label = null, $name = null, $maps = null, $actionStr = null, $params = null, $mode = null, $condition = null, $message = null, $icon = null, $refresh = null)
  {
    // Bouml preserved body begin 001CAA05
	parent::__construct($label, $name, $maps, null, null);
	$context = Application::getInstance()->getContext();
	if (!is_null($context) && !is_null($actionStr)) {
		$action = $context->getActionByAlias($actionStr);
		if (!is_null($action)) {
			$this->caption = $action->getHint();
			$this->icon = $action->getIcon();
		}
		$this->action = $actionStr;
		$this->params = $params;
		$this->mode = $mode;
		$this->refresh = $refresh;
		$this->message = $message;
		$this->condition = $condition;
		if ($icon !==null)
			$this->icon=$icon;
	}
	return $this;
    // Bouml preserved body end 001CAA05
  }

  /**
   * Retorna un arreglo la definici�n del objeto a fin de que sea f�cilmente interpretable por un Template de TWIG.
   * Debido a que no todos los componentes tienen el maps y el name obligatorio, se asume como regla que:
   * <ul>
   * 	<li><b>si tiene name</b>, se usa el name.</li>
   * 	<li><b>si no tiene name</b>, se usa el maps de la siguiente manera: $prefix.maps.$postfix</li>
   * </ul>
   * 
   * @param string $prefix el prefijo que emplea para generar los nombres cuando no existe el name.
   * @param string $suffix el sufijo que emplea para generar los nombres cuando no existe el name.
   * 
   * @return array El arreglo que representa el objeto y sus propiedades
   */
  public function toArray($prefix = '', $suffix = '')
  {
    // Bouml preserved body begin 001CA985
	  //TODO completar con la información que falta
	  
	if (is_string($this->params))
		$params = array($this->params);
	else $params = $this->params;
	
	$aParametros = array(	'type'		=>  'action',
							'action'	=>  $this->action,
							'mode'      =>  explode(" ", $this->mode),
							'icon'      =>  $this->icon,
							'params'    =>  $params,
							'refresh'   =>  $this->refresh,
							'message'   =>  $this->message,
							'condition' =>	$this->condition
						);
	return array_merge(parent::toArray($prefix, $suffix), $aParametros);
    // Bouml preserved body end 001CA985
  }

}
?>